/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.longcompression;

import java.util.Arrays;
import me.lemire.integercompression.IntWrapper;
import me.lemire.longcompression.LongBinaryPacking;
import me.lemire.longcompression.LongVariableByte;
import me.lemire.longcompression.SkippableLongCODEC;
import me.lemire.longcompression.SkippableLongComposition;

public class LongCompressor {
    SkippableLongCODEC codec;

    public LongCompressor(SkippableLongCODEC c) {
        this.codec = c;
    }

    public LongCompressor() {
        this.codec = new SkippableLongComposition(new LongBinaryPacking(), new LongVariableByte());
    }

    public long[] compress(long[] input) {
        int maxCompressedLength = this.codec.maxHeadlessCompressedLength(new IntWrapper(0), input.length);
        long[] compressed = new long[maxCompressedLength + 1];
        compressed[0] = input.length;
        IntWrapper outpos = new IntWrapper(1);
        this.codec.headlessCompress(input, new IntWrapper(0), input.length, compressed, outpos);
        compressed = Arrays.copyOf(compressed, outpos.intValue());
        return compressed;
    }

    public long[] uncompress(long[] compressed) {
        long[] decompressed = new long[(int)compressed[0]];
        IntWrapper inpos = new IntWrapper(1);
        this.codec.headlessUncompress(compressed, inpos, compressed.length - inpos.intValue(), decompressed, new IntWrapper(0), decompressed.length);
        return decompressed;
    }
}

