/*
 * Decompiled with CFR 0.152.
 */
package mn.foreman.api;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import mn.foreman.api.WebUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkWebUtil
implements WebUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JdkWebUtil.class);
    private static final String NO_CONTENT = "";
    private final String apiToken;
    private final String foremanUrl;
    private final int socketTimeoutMillis;

    public JdkWebUtil(String foremanUrl, String apiToken, int socketTimeout, TimeUnit socketTimeoutUnits) {
        this.foremanUrl = foremanUrl;
        this.apiToken = apiToken;
        this.socketTimeoutMillis = (int)socketTimeoutUnits.toMillis(socketTimeout);
    }

    @Override
    public Optional<String> get(String uri) {
        return this.get(uri, Collections.emptyMap());
    }

    @Override
    public Optional<String> get(String uri, boolean auth) {
        return this.readOp(uri, auth, Collections.emptyMap());
    }

    @Override
    public Optional<String> get(String uri, Map<String, String> params) {
        return this.readOp(uri, true, params);
    }

    @Override
    public Optional<String> post(String uri) {
        return this.post(uri, NO_CONTENT);
    }

    @Override
    public Optional<String> post(String uri, String body) {
        HttpPost httpPost = new HttpPost(String.format("%s%s", this.foremanUrl, uri));
        return this.writeableOp(uri, body, (HttpEntityEnclosingRequestBase)httpPost);
    }

    @Override
    public Optional<String> put(String uri, String body) {
        HttpPut httpPut = new HttpPut(String.format("%s%s", this.foremanUrl, uri));
        return this.writeableOp(uri, body, (HttpEntityEnclosingRequestBase)httpPut);
    }

    /*
     * Exception decompiling
     */
    private Optional<String> readOp(String uri, boolean auth, Map<String, String> params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Optional<String> writeableOp(String uri, String body, HttpEntityEnclosingRequestBase requestBase) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Optional<String> getResponse(String uri, CloseableHttpResponse httpResponse, boolean isGet) {
        String method = isGet ? "GET" : "POST";
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        try {
            String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (statusCode == 200) {
                LOG.info("Obtained {} response from Foreman: {}", (Object)method, (Object)response);
                return Optional.ofNullable(response);
            }
            LOG.error("Received non 200 for {} status of {} for uri {} : {}", new Object[]{method, statusCode, uri, response});
        }
        catch (IOException e) {
            LOG.error("Error parsing {} response for uri {} with status code {} : {}", new Object[]{method, uri, statusCode, e.getMessage()});
        }
        return Optional.empty();
    }
}

