/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.rest;

import com.google.gson.Gson;
import com.launchdarkly.eventsource.ConnectStrategy;
import com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.eventsource.FaultEvent;
import com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.eventsource.StreamEvent;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import net.luckperms.rest.event.EventCall;
import net.luckperms.rest.event.EventProducer;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.CallAdapter;

class EventCallAdapter
implements CallAdapter<Object, EventCall<?>> {
    private final Type eventType;
    private final OkHttpClient client;
    private final ExecutorService executorService;

    EventCallAdapter(Type eventType, OkHttpClient client, ExecutorService executorService) {
        this.eventType = eventType;
        this.client = client;
        this.executorService = executorService;
    }

    public Type responseType() {
        return Object.class;
    }

    public EventCall<Object> adapt(Call<Object> call) {
        return new EventCallImpl<Object>(call.request().url(), this.eventType, this.client, this.executorService);
    }

    private static final class EventCallImpl<E>
    implements EventCall<E> {
        private final HttpUrl url;
        private final Type eventType;
        private final OkHttpClient client;
        private final Executor executor;

        EventCallImpl(HttpUrl url, Type eventType, OkHttpClient client, Executor executor) {
            this.url = url;
            this.eventType = eventType;
            this.client = client;
            this.executor = executor;
        }

        @Override
        public EventProducer<E> subscribe() throws Exception {
            EventSource eventSource = new EventSource.Builder((ConnectStrategy)ConnectStrategy.http((HttpUrl)this.url).httpClient(this.client)).build();
            eventSource.start();
            return new EventProducerImpl(eventSource, this.eventType, this.executor);
        }
    }

    private static final class EventProducerImpl<E>
    implements EventProducer<E> {
        private static final Gson GSON = new Gson();
        private final EventSource eventSource;
        private final Type eventType;
        private final List<Consumer<E>> handlers;
        private final List<Consumer<Exception>> errorHandlers;

        private EventProducerImpl(EventSource eventSource, Type eventType, Executor executor) {
            this.eventSource = eventSource;
            this.eventType = eventType;
            this.handlers = new CopyOnWriteArrayList<Consumer<E>>();
            this.errorHandlers = new CopyOnWriteArrayList<Consumer<Exception>>();
            executor.execute(this::pollForEvents);
        }

        private void pollForEvents() {
            try {
                for (StreamEvent event : this.eventSource.anyEvents()) {
                    if (event instanceof MessageEvent) {
                        this.handleMessage((MessageEvent)event);
                        continue;
                    }
                    if (!(event instanceof FaultEvent)) continue;
                    this.handleError((Exception)((FaultEvent)event).getCause());
                }
            }
            catch (Exception e) {
                this.handleError(e);
            }
        }

        private void handleMessage(MessageEvent e) {
            Object parsedEvent;
            String eventName = e.getEventName();
            if (!eventName.equals("message")) {
                return;
            }
            try {
                parsedEvent = GSON.fromJson(e.getData(), this.eventType);
            }
            catch (Exception ex) {
                this.handleError(ex);
                return;
            }
            for (Consumer<E> handler : this.handlers) {
                try {
                    handler.accept(parsedEvent);
                }
                catch (Exception ex) {
                    this.handleError(ex);
                }
            }
        }

        private void handleError(Exception e) {
            for (Consumer<Exception> errorHandler : this.errorHandlers) {
                try {
                    errorHandler.accept(e);
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void subscribe(Consumer<E> consumer) {
            this.handlers.add(consumer);
        }

        @Override
        public void errorHandler(Consumer<Exception> errorHandler) {
            this.errorHandlers.add(errorHandler);
        }

        @Override
        public void close() {
            this.eventSource.close();
        }
    }
}

