/*
 * Decompiled with CFR 0.152.
 */
package net.mst.utilities.randomstring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.mst.utilities.mathematical.Random;

public class RandomString {
    private Integer length;
    private HashSet<Character> charset;

    public RandomString(Integer Length, HashSet<Character> Charset2) {
        this.length = Length;
        this.charset = Charset2;
    }

    public List<String> getOptions() {
        List<String> options = new ArrayList<String>();
        for (Character character : this.charset) {
            options.add(String.valueOf(character));
        }
        for (int i = 1; i < this.length; ++i) {
            options = this.generateNext(options);
        }
        return options;
    }

    private List<String> generateNext(List<String> original) {
        ArrayList<String> tempList = new ArrayList<String>();
        for (String string : original) {
            for (Character character : this.charset) {
                tempList.add(string + character);
            }
        }
        return tempList;
    }

    public long getOptionCount() {
        return (long)Math.pow(this.charset.size(), this.length.intValue());
    }

    public String generateRandom() {
        Object tempString = "";
        for (int i = 0; i < this.length; ++i) {
            tempString = (String)tempString + Random.pickOf(this.charset);
        }
        return tempString;
    }
}

