/*
 * Decompiled with CFR 0.152.
 */
package net.voidnote;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.voidnote.VoidNote;
import net.voidnote.VoidNoteException;

public final class StreamHandle {
    public final String url;
    public final String expiresAt;
    private final String fullToken;
    private final byte[] key;
    private final String base;

    StreamHandle(String url, String expiresAt, String fullToken, byte[] key, String base) {
        this.url = url;
        this.expiresAt = expiresAt;
        this.fullToken = fullToken;
        this.key = key;
        this.base = base;
    }

    public void write(String content) throws VoidNoteException {
        VoidNote.EncryptResult enc = VoidNote.encryptWithKey(content, this.key);
        JsonObject body = new JsonObject();
        body.addProperty("encryptedContent", enc.ciphertext());
        body.addProperty("iv", enc.iv());
        VoidNote.httpPost(this.base + "/api/stream/" + this.fullToken + "/write", VoidNote.GSON.toJson((JsonElement)body), null);
    }

    public void close() throws VoidNoteException {
        VoidNote.httpPost(this.base + "/api/stream/" + this.fullToken + "/close", "{}", null);
    }

    public void watch(Consumer<String> onMessage) throws VoidNoteException {
        VoidNote.watchSse(this.base + "/api/stream/" + this.fullToken + "/events", this.key, onMessage);
    }
}

