/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data.simple.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nl.crashdata.chartjs.colors.ChartJsRGBAColor;
import nl.crashdata.chartjs.data.ChartJsDataPoint;
import nl.crashdata.chartjs.data.simple.SimpleChartJsDataPoint;
import nl.crashdata.chartjs.data.simple.SimpleChartJsDataset;
import nl.crashdata.chartjs.data.simple.builder.SimpleChartJsBuilder;

public class SimpleChartJsDatasetBuilder<K extends Serializable, V extends Serializable>
implements SimpleChartJsBuilder<SimpleChartJsDataset<K, V>> {
    private String label;
    private ChartJsRGBAColor backgroundColor;
    private ChartJsRGBAColor borderColor;
    private String fill = "false";
    private List<ChartJsDataPoint<K, V>> data = new ArrayList<ChartJsDataPoint<K, V>>();

    public SimpleChartJsDatasetBuilder<K, V> withLabel(String label) {
        this.label = label;
        return this;
    }

    public SimpleChartJsDatasetBuilder<K, V> withBackgroundColor(ChartJsRGBAColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public SimpleChartJsDatasetBuilder<K, V> withBorderColor(ChartJsRGBAColor borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public SimpleChartJsDatasetBuilder<K, V> withFill(String fill) {
        this.fill = fill;
        return this;
    }

    public SimpleChartJsDatasetBuilder<K, V> withDataPoints(List<ChartJsDataPoint<K, V>> dataPoints) {
        this.data = dataPoints;
        return this;
    }

    public SimpleChartJsDatasetBuilder<K, V> withDataPoints(Map<K, V> dataPoints) {
        this.data = dataPoints.entrySet().stream().map(e -> new SimpleChartJsDataPoint<Serializable, Serializable>((Serializable)e.getKey(), (Serializable)e.getValue())).collect(Collectors.toList());
        return this;
    }

    public SimpleChartJsDatasetBuilder<K, V> addDataPoint(ChartJsDataPoint<K, V> dataPoint) {
        this.data.add(dataPoint);
        return this;
    }

    public SimpleChartJsDatasetBuilder<K, V> addDataPoint(K x, V y) {
        this.data.add(new SimpleChartJsDataPoint<K, V>(x, y));
        return this;
    }

    @Override
    public boolean isValid() {
        return !this.data.isEmpty();
    }

    @Override
    public SimpleChartJsDataset<K, V> build() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " is not ready to build!");
        }
        SimpleChartJsDataset<K, V> ret = new SimpleChartJsDataset<K, V>();
        ret.setBackgroundColor(this.backgroundColor);
        ret.setBorderColor(this.borderColor);
        ret.setData(this.data);
        ret.setLabel(this.label);
        ret.setFill(this.fill);
        return ret;
    }
}

