/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.colors;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public final class ChartJsRGBAColor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ChartJsRGBAColor RED = new ChartJsRGBAColor(255, 99, 132);
    public static final ChartJsRGBAColor ORANGE = new ChartJsRGBAColor(255, 159, 64);
    public static final ChartJsRGBAColor YELLOW = new ChartJsRGBAColor(255, 205, 86);
    public static final ChartJsRGBAColor GREEN = new ChartJsRGBAColor(75, 192, 192);
    public static final ChartJsRGBAColor BLUE = new ChartJsRGBAColor(54, 162, 235);
    public static final ChartJsRGBAColor PURPLE = new ChartJsRGBAColor(153, 102, 255);
    public static final ChartJsRGBAColor GREY = new ChartJsRGBAColor(201, 203, 207);
    private final short red;
    private final short green;
    private final short blue;
    private final short alpha;

    public ChartJsRGBAColor(int red, int green, int blue) {
        this(red, green, blue, 100);
    }

    public ChartJsRGBAColor(int red, int green, int blue, int alpha) {
        this.red = ChartJsRGBAColor.ensureValidColourValue(red);
        this.green = ChartJsRGBAColor.ensureValidColourValue(green);
        this.blue = ChartJsRGBAColor.ensureValidColourValue(blue);
        this.alpha = ChartJsRGBAColor.ensureValidAlphaValue(alpha);
    }

    public short getRed() {
        return this.red;
    }

    public short getGreen() {
        return this.green;
    }

    public short getBlue() {
        return this.blue;
    }

    public short getAlpha() {
        return this.alpha;
    }

    public ChartJsRGBAColor withRed(int red) {
        return new ChartJsRGBAColor(red, this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public ChartJsRGBAColor withGreen(int green) {
        return new ChartJsRGBAColor(this.getRed(), green, this.getBlue(), this.getAlpha());
    }

    public ChartJsRGBAColor withBlue(int blue) {
        return new ChartJsRGBAColor(this.getRed(), this.getGreen(), blue, this.getAlpha());
    }

    public ChartJsRGBAColor withAlpha(int alpha) {
        return new ChartJsRGBAColor(this.getRed(), this.getGreen(), this.getBlue(), alpha);
    }

    @JsonValue
    public String toJsonString() {
        return String.format(Locale.ROOT, "rgba(%d, %d, %d, %1.1f)", this.red, this.green, this.blue, Float.valueOf((float)this.alpha / 100.0f));
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%d, %d, %d, %d)", this.getClass().getSimpleName(), this.red, this.green, this.blue, this.alpha);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChartJsRGBAColor) {
            ChartJsRGBAColor other = (ChartJsRGBAColor)obj;
            return this.red == other.red && this.green == other.green && this.blue == other.blue && this.alpha == other.alpha;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.red, this.green, this.blue, this.alpha);
    }

    public static short ensureValidColourValue(int value) {
        if (value >= 0 && value <= 255) {
            return (short)value;
        }
        throw new IllegalArgumentException("Colour value should be between 0 and 255, inclusive");
    }

    public static short ensureValidAlphaValue(int value) {
        if (value >= 0 && value <= 100) {
            return (short)value;
        }
        throw new IllegalArgumentException("Alpha value should be between 0 and 100, inclusive");
    }
}

