/*
 * Decompiled with CFR 0.152.
 */
package nl.crashdata.chartjs.data;

import com.fasterxml.jackson.annotation.JsonValue;
import nl.crashdata.chartjs.data.ChartJsBoundaryType;
import nl.crashdata.chartjs.data.ChartJsFillMode;

public final class ChartJsFill {
    public static final ChartJsFill DISABLED = new ChartJsFill();
    private ChartJsFillMode mode;
    private ChartJsBoundaryType boundary;
    private Integer datasetIndex;

    private ChartJsFill() {
    }

    public static ChartJsFill disabled() {
        return DISABLED;
    }

    public static ChartJsFill boundary(ChartJsBoundaryType boundary) {
        ChartJsFill fill = new ChartJsFill();
        fill.mode = ChartJsFillMode.BOUNDARY;
        fill.boundary = boundary;
        fill.datasetIndex = null;
        return fill;
    }

    public static ChartJsFill relativeIndex(int datasetIndex) {
        if (datasetIndex == 0) {
            throw new IllegalArgumentException("Relative dataset index can not be 0!");
        }
        ChartJsFill fill = new ChartJsFill();
        fill.mode = ChartJsFillMode.RELATIVE_DATASET_INDEX;
        fill.boundary = null;
        fill.datasetIndex = datasetIndex;
        return fill;
    }

    public static ChartJsFill absoluteIndex(int datasetIndex) {
        if (datasetIndex == 0) {
            throw new IllegalArgumentException("Absolute dataset index can not be 0!");
        }
        if (datasetIndex < 0) {
            throw new IllegalArgumentException("Absolute dataset index can not negative!");
        }
        ChartJsFill fill = new ChartJsFill();
        fill.mode = ChartJsFillMode.ABSOLUTE_DATASET_INDEX;
        fill.boundary = null;
        fill.datasetIndex = datasetIndex;
        return fill;
    }

    @JsonValue
    public String toJsonString() {
        switch (this.mode) {
            case ABSOLUTE_DATASET_INDEX: {
                return String.format("%d", this.datasetIndex);
            }
            case RELATIVE_DATASET_INDEX: {
                return String.format("%+d", this.datasetIndex);
            }
            case BOUNDARY: {
                return ChartJsFill.toStringValue(this.boundary);
            }
            case DISABLED: {
                return "false";
            }
        }
        throw new IllegalStateException();
    }

    private static String toStringValue(ChartJsBoundaryType boundary) {
        switch (boundary) {
            case START: {
                return "start";
            }
            case END: {
                return "end";
            }
            case ORIGIN: {
                return "origin";
            }
        }
        throw new IllegalArgumentException("Unknown ChartJsBoundaryType: " + boundary);
    }

    static {
        ChartJsFill.DISABLED.mode = ChartJsFillMode.DISABLED;
        ChartJsFill.DISABLED.boundary = null;
        ChartJsFill.DISABLED.datasetIndex = null;
    }
}

