/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.androidannotations.annotations.EBean;
import org.androidannotations.handler.BaseGeneratingAnnotationHandler;
import org.androidannotations.holder.EBeanHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.process.ProcessHolder;

public class EBeanHandler
extends BaseGeneratingAnnotationHandler<EBeanHolder> {
    public EBeanHandler(ProcessingEnvironment processingEnvironment) {
        super(EBean.class, processingEnvironment);
    }

    @Override
    public EBeanHolder createGeneratedClassHolder(ProcessHolder processHolder, TypeElement annotatedComponent) throws Exception {
        return new EBeanHolder(processHolder, annotatedComponent);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        super.validate(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.isAbstractOrHasEmptyOrContextConstructor(element, valid);
    }

    @Override
    public void process(Element element, EBeanHolder holder) {
        EBean eBeanAnnotation = element.getAnnotation(EBean.class);
        EBean.Scope eBeanScope = eBeanAnnotation.scope();
        boolean hasSingletonScope = eBeanScope == EBean.Scope.Singleton;
        holder.createFactoryMethod(hasSingletonScope);
        if (!hasSingletonScope) {
            holder.invokeInitInConstructor();
            holder.createRebindMethod();
        }
    }
}

