/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.androidannotations.helper.Option;

public class FileHelper {
    public static Option<File> findRootProject(ProcessingEnvironment processingEnv) {
        Option<FileHolder> rootProjectHolder = FileHelper.findRootProjectHolder(processingEnv);
        if (rootProjectHolder.isAbsent()) {
            return Option.absent();
        }
        return Option.of(rootProjectHolder.get().projectRoot);
    }

    public static Option<FileHolder> findRootProjectHolder(ProcessingEnvironment processingEnv) {
        URI cleanURI;
        FileObject dummySourceFile;
        Filer filer = processingEnv.getFiler();
        try {
            dummySourceFile = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "dummy" + System.currentTimeMillis(), new Element[0]);
        }
        catch (IOException ignored) {
            return Option.absent();
        }
        String dummySourceFilePath = dummySourceFile.toUri().toString();
        if (dummySourceFilePath.startsWith("file:")) {
            if (!dummySourceFilePath.startsWith("file://")) {
                dummySourceFilePath = "file://" + dummySourceFilePath.substring("file:".length());
            }
        } else {
            dummySourceFilePath = "file://" + dummySourceFilePath;
        }
        try {
            cleanURI = new URI(dummySourceFilePath);
        }
        catch (URISyntaxException e) {
            return Option.absent();
        }
        File dummyFile = new File(cleanURI);
        File sourcesGenerationFolder = dummyFile.getParentFile();
        File projectRoot = sourcesGenerationFolder.getParentFile();
        return Option.of(new FileHolder(dummySourceFilePath, sourcesGenerationFolder, projectRoot));
    }

    public static File resolveOutputDirectory(ProcessingEnvironment processingEnv) {
        Option<File> rootProjectOption = FileHelper.findRootProject(processingEnv);
        if (rootProjectOption.isAbsent()) {
            return null;
        }
        File rootProject = rootProjectOption.get();
        File targetFolder = new File(rootProject, "target");
        if (targetFolder.isDirectory() && targetFolder.canWrite()) {
            return targetFolder;
        }
        File buildFolder = new File(rootProject, "build");
        if (buildFolder.isDirectory() && buildFolder.canWrite()) {
            return buildFolder;
        }
        File binFolder = new File(rootProject, "bin");
        if (binFolder.isDirectory() && binFolder.canWrite()) {
            return binFolder;
        }
        return rootProject;
    }

    static class FileHolder {
        String dummySourceFilePath;
        File sourcesGenerationFolder;
        File projectRoot;

        public FileHolder(String dummySourceFilePath, File sourcesGenerationFolder, File projectRoot) {
            this.dummySourceFilePath = dummySourceFilePath;
            this.sourcesGenerationFolder = sourcesGenerationFolder;
            this.projectRoot = projectRoot;
        }
    }
}

