/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.search.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.core.alignment.SimpleAlignedSequence;
import org.biojava.nbio.core.alignment.SimpleSequencePair;
import org.biojava.nbio.core.alignment.template.AlignedSequence;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Hsp<S extends Sequence<C>, C extends Compound> {
    private static final Logger logger = LoggerFactory.getLogger(Hsp.class);
    private Integer hspNum;
    private Double hspBitScore;
    private Integer hspScore;
    private Double hspEvalue;
    private Integer hspQueryFrom;
    private Integer hspQueryTo;
    private Integer hspHitFrom;
    private Integer hspHitTo;
    private Integer hspQueryFrame;
    private Integer hspHitFrame;
    private Integer hspIdentity;
    private Integer hspPositive;
    private Integer hspGaps;
    private Integer hspAlignLen;
    private String hspQseq;
    private String hspHseq;
    private String hspIdentityString;
    private Double percentageIdentity = null;
    private Integer mismatchCount = null;
    private SimpleSequencePair<S, C> returnAln;

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.hspQseq != null ? this.hspQseq.hashCode() : 0);
        hash = 67 * hash + (this.hspHseq != null ? this.hspHseq.hashCode() : 0);
        hash = 67 * hash + (this.hspIdentityString != null ? this.hspIdentityString.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hsp other = (Hsp)obj;
        if (this.hspQseq == null ? other.hspQseq != null : !this.hspQseq.equals(other.hspQseq)) {
            return false;
        }
        if (this.hspHseq == null ? other.hspHseq != null : !this.hspHseq.equals(other.hspHseq)) {
            return false;
        }
        return !(this.hspIdentityString == null ? other.hspIdentityString != null : !this.hspIdentityString.equals(other.hspIdentityString));
    }

    public SequencePair<S, C> getAlignment() {
        if (this.returnAln != null) {
            return this.returnAln;
        }
        SimpleAlignedSequence alignedQuery = new SimpleAlignedSequence(this.getSequence(this.hspQseq), this.getAlignmentsSteps(this.hspQseq));
        SimpleAlignedSequence alignedHit = new SimpleAlignedSequence(this.getSequence(this.hspHseq), this.getAlignmentsSteps(this.hspHseq));
        this.returnAln = new SimpleSequencePair(alignedQuery, alignedHit);
        return this.returnAln;
    }

    private Sequence getSequence(String gappedSequenceString) {
        if (gappedSequenceString == null) {
            return null;
        }
        AbstractSequence returnSeq = null;
        String sequenceString = gappedSequenceString.replace("-", "");
        try {
            returnSeq = sequenceString.matches("^[ACTG]+$") ? new DNASequence(sequenceString, (CompoundSet<NucleotideCompound>)DNACompoundSet.getDNACompoundSet()) : (sequenceString.matches("^[ACUG]+$") ? new RNASequence(sequenceString, (CompoundSet<NucleotideCompound>)DNACompoundSet.getDNACompoundSet()) : new ProteinSequence(sequenceString, (CompoundSet<AminoAcidCompound>)AminoAcidCompoundSet.getAminoAcidCompoundSet()));
        }
        catch (CompoundNotFoundException ex) {
            logger.error("Unexpected error, could not find compound when creating Sequence object from Hsp", (Throwable)ex);
        }
        return returnSeq;
    }

    private List<AlignedSequence.Step> getAlignmentsSteps(String gappedSequenceString) {
        ArrayList<AlignedSequence.Step> returnList = new ArrayList<AlignedSequence.Step>();
        for (char c : gappedSequenceString.toCharArray()) {
            if (c == '-') {
                returnList.add(AlignedSequence.Step.GAP);
                continue;
            }
            returnList.add(AlignedSequence.Step.COMPOUND);
        }
        return returnList;
    }

    public int getHspNum() {
        return this.hspNum;
    }

    public double getHspBitScore() {
        return this.hspBitScore;
    }

    public int getHspScore() {
        return this.hspScore;
    }

    public double getHspEvalue() {
        return this.hspEvalue;
    }

    public int getHspQueryFrom() {
        return this.hspQueryFrom;
    }

    public int getHspQueryTo() {
        return this.hspQueryTo;
    }

    public int getHspHitFrom() {
        return this.hspHitFrom;
    }

    public int getHspHitTo() {
        return this.hspHitTo;
    }

    public int getHspQueryFrame() {
        return this.hspQueryFrame;
    }

    public int getHspHitFrame() {
        return this.hspHitFrame;
    }

    public int getHspIdentity() {
        return this.hspIdentity;
    }

    public int getHspPositive() {
        return this.hspPositive;
    }

    public int getHspGaps() {
        return this.hspGaps;
    }

    public int getHspAlignLen() {
        return this.hspAlignLen;
    }

    public String getHspQseq() {
        return this.hspQseq;
    }

    public String getHspHseq() {
        return this.hspHseq;
    }

    public String getHspIdentityString() {
        return this.hspIdentityString;
    }

    public Double getPercentageIdentity() {
        if (this.percentageIdentity != null) {
            return this.percentageIdentity;
        }
        if (this.hspIdentity != null && this.hspAlignLen != null) {
            return (double)this.hspIdentity.intValue() / (double)this.hspAlignLen.intValue();
        }
        return null;
    }

    public Integer getMismatchCount() {
        if (this.mismatchCount != null) {
            return this.mismatchCount;
        }
        if (this.hspIdentity != null && this.hspAlignLen != null) {
            return this.hspIdentity - this.hspAlignLen;
        }
        return null;
    }

    public Hsp(int hspNum, double hspBitScore, int hspScore, double hspEvalue, int hspQueryFrom, int hspQueryTo, int hspHitFrom, int hspHitTo, int hspQueryFrame, int hspHitFrame, int hspIdentity, int hspPositive, int hspGaps, int hspAlignLen, String hspQseq, String hspHseq, String hspIdentityString, Double percentageIdentity, Integer mismatchCount) {
        this.hspNum = hspNum;
        this.hspBitScore = hspBitScore;
        this.hspScore = hspScore;
        this.hspEvalue = hspEvalue;
        this.hspQueryFrom = hspQueryFrom;
        this.hspQueryTo = hspQueryTo;
        this.hspHitFrom = hspHitFrom;
        this.hspHitTo = hspHitTo;
        this.hspQueryFrame = hspQueryFrame;
        this.hspHitFrame = hspHitFrame;
        this.hspIdentity = hspIdentity;
        this.hspPositive = hspPositive;
        this.hspGaps = hspGaps;
        this.hspIdentity = hspAlignLen;
        this.hspQseq = hspQseq;
        this.hspHseq = hspHseq;
        this.hspIdentityString = hspIdentityString;
        this.percentageIdentity = percentageIdentity;
        this.mismatchCount = mismatchCount;
        if (percentageIdentity != null && (percentageIdentity < 0.0 || percentageIdentity > 1.0)) {
            throw new IllegalArgumentException("Percentage identity must be between 0 and 1");
        }
    }
}

