/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.util.ArrayList;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DataSource;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFastaHeaderParser<S extends AbstractSequence<C>, C extends Compound>
implements SequenceHeaderParserInterface<S, C> {
    private static final Logger logger = LoggerFactory.getLogger(GenericFastaHeaderParser.class);

    private String[] getHeaderValues(String header) {
        String[] data = new String[]{};
        ArrayList<String> values = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        if (!header.startsWith("PDB:")) {
            for (int i = 0; i < header.length(); ++i) {
                if (header.charAt(i) == '|') {
                    values.add(sb.toString());
                    sb.setLength(0);
                } else if (i == header.length() - 1) {
                    sb.append(header.charAt(i));
                    values.add(sb.toString());
                } else {
                    sb.append(header.charAt(i));
                }
                data = new String[values.size()];
                values.toArray(data);
            }
        } else {
            data = header.split(" ");
        }
        return data;
    }

    @Override
    public void parseHeader(String header, S sequence) {
        ((AbstractSequence)sequence).setOriginalHeader(header);
        String[] data = this.getHeaderValues(header);
        if (data.length == 1) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[0]));
        } else if (data[0].equalsIgnoreCase("sp") || data[0].equalsIgnoreCase("tr")) {
            if (data[0].equalsIgnoreCase("sp")) {
                ((AbstractSequence)sequence).setAnnotationType(AbstractSequence.AnnotationType.CURATED);
            } else {
                ((AbstractSequence)sequence).setAnnotationType(AbstractSequence.AnnotationType.PREDICTED);
            }
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.UNIPROT));
            if (data.length > 2) {
                ((AbstractSequence)sequence).setDescription(data[2]);
            }
        } else if (data[0].equalsIgnoreCase("gi")) {
            DataSource giSource = DataSource.UNKNOWN;
            if (data.length >= 3) {
                if (data[2].equalsIgnoreCase("gb")) {
                    giSource = DataSource.GENBANK;
                } else if (data[2].equalsIgnoreCase("emb")) {
                    giSource = DataSource.ENA;
                } else if (data[2].equalsIgnoreCase("dbj")) {
                    giSource = DataSource.DDBJ;
                }
                ((AbstractSequence)sequence).setAccession(new AccessionID(data[3], giSource));
            } else {
                ((AbstractSequence)sequence).setAccession(new AccessionID(header, giSource));
            }
        } else if (data[0].equalsIgnoreCase("pir")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.NBRF));
        } else if (data[0].equalsIgnoreCase("prf")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.PRF));
        } else if (data[0].equalsIgnoreCase("pdb")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1] + ":" + data[2], DataSource.PDB1));
        } else if (data[0].startsWith("PDB")) {
            String[] pdbe = data[0].split(" ");
            String[] pdbaccession = pdbe[0].split(":");
            ((AbstractSequence)sequence).setAccession(new AccessionID(pdbaccession[1], DataSource.PDBe));
        } else if (data[0].indexOf(":") != -1 && data.length > 1 && data[1].equals("PDBID")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[0], DataSource.PDB2));
        } else if (data[0].equalsIgnoreCase("pat")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.PATENTS));
        } else if (data[0].equalsIgnoreCase("bbs")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.GENINFO));
        } else if (data[0].equalsIgnoreCase("gnl")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[2], DataSource.GENERAL));
        } else if (data[0].equalsIgnoreCase("ref")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.NCBI));
        } else if (data[0].equalsIgnoreCase("lcl")) {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[1], DataSource.LOCAL));
        } else {
            ((AbstractSequence)sequence).setAccession(new AccessionID(data[0]));
        }
    }
}

