/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.compound;

import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.AbstractNucleotideCompoundSet;

public class ABITracerCompoundSet
extends AbstractNucleotideCompoundSet<NucleotideCompound> {
    public static ABITracerCompoundSet getABITracerCompoundSet() {
        return InitaliseOnDemand.INSTANCE;
    }

    public ABITracerCompoundSet() {
        this.addNucleotideCompound("A", "T", new String[0]);
        this.addNucleotideCompound("T", "A", new String[0]);
        this.addNucleotideCompound("G", "C", new String[0]);
        this.addNucleotideCompound("C", "G", new String[0]);
        this.addNucleotideCompound("N", "N", new String[0]);
        this.addNucleotideCompound("K", "K", new String[0]);
        this.addNucleotideCompound("Y", "Y", new String[0]);
        this.addNucleotideCompound("R", "R", new String[0]);
        this.addNucleotideCompound("-", "-", new String[0]);
    }

    @Override
    public NucleotideCompound newNucleotideCompound(String base, String complement, String ... equivalents) {
        if (equivalents.length == 0) {
            return new NucleotideCompound(base, this, complement);
        }
        NucleotideCompound[] compounds = new NucleotideCompound[equivalents.length];
        for (int i = 0; i < compounds.length; ++i) {
            compounds[i] = (NucleotideCompound)this.getCompoundForString(equivalents[i]);
        }
        return new NucleotideCompound(base, this, complement, compounds);
    }

    private static class InitaliseOnDemand {
        public static final ABITracerCompoundSet INSTANCE = new ABITracerCompoundSet();

        private InitaliseOnDemand() {
        }
    }
}

