/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.search.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.nbio.core.search.io.Hit;
import org.biojava.nbio.core.sequence.template.Sequence;

public abstract class Result
implements Iterable<Hit> {
    private String program;
    private String version;
    private String reference;
    private String dbFile;
    private HashMap<String, String> programSpecificParameters;
    private int iterationNumber;
    private String queryID;
    private String queryDef;
    private int queryLength;
    private Sequence querySequence;
    private List<Hit> hits;
    private int hitCounter = -1;

    public Result(String program, String version, String reference, String dbFile, HashMap<String, String> programSpecificParameters, int iterationNumber, String queryID, String queryDef, int queryLength, List<Hit> hits, Sequence querySequence) {
        this.program = program;
        this.version = version;
        this.reference = reference;
        this.dbFile = dbFile;
        this.programSpecificParameters = programSpecificParameters;
        this.iterationNumber = iterationNumber;
        this.queryID = queryID;
        this.queryDef = queryDef;
        this.queryLength = queryLength;
        this.hits = hits;
        this.querySequence = querySequence;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.queryID != null ? this.queryID.hashCode() : 0);
        hash = 29 * hash + (this.queryDef != null ? this.queryDef.hashCode() : 0);
        hash = 29 * hash + (this.hits != null ? this.hits.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Result other = (Result)obj;
        if (this.queryID == null ? other.queryID != null : !this.queryID.equals(other.queryID)) {
            return false;
        }
        if (this.queryDef == null ? other.queryDef != null : !this.queryDef.equals(other.queryDef)) {
            return false;
        }
        return this.hits == other.hits || this.hits != null && this.hits.equals(other.hits);
    }

    public int getIterationNumber() {
        return this.iterationNumber;
    }

    public String getQueryID() {
        return this.queryID;
    }

    public String getQueryDef() {
        return this.queryDef;
    }

    public int getQueryLength() {
        return this.queryLength;
    }

    public int getHitCounter() {
        return this.hitCounter;
    }

    public String getProgram() {
        return this.program;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReference() {
        return this.reference;
    }

    public String getDbFile() {
        return this.dbFile;
    }

    public Set<String> getProgramSpecificParametersList() {
        return this.programSpecificParameters.keySet();
    }

    public String getProgramSpecificParameter(String key) {
        return this.programSpecificParameters.get(key);
    }

    public Sequence getQuerySequence() {
        return this.querySequence;
    }

    @Override
    public Iterator<Hit> iterator() {
        return new Iterator<Hit>(){
            int currentResult = 0;

            @Override
            public boolean hasNext() {
                return this.currentResult < Result.this.hits.size();
            }

            @Override
            public Hit next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Result.this.hits.get(this.currentResult++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove operation is not supported by this iterator");
            }
        };
    }
}

