/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.features.DBReferenceInfo;
import org.biojava.nbio.core.sequence.features.FeatureInterface;
import org.biojava.nbio.core.sequence.features.Qualifier;
import org.biojava.nbio.core.sequence.location.template.AbstractLocation;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.location.template.Point;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.util.StringManipulationHelper;

public class GenericInsdcHeaderFormat<S extends AbstractSequence<C>, C extends Compound> {
    protected static final int MAX_WIDTH = 80;
    protected static final int QUALIFIER_INDENT = 21;
    protected static final String QUALIFIER_INDENT_STR = "                     ";
    protected static final String QUALIFIER_INDENT_TMP = "     %s                ";
    private static final String lineSep = System.lineSeparator();

    private String _write_feature_qualifier(String key, String value, boolean quote) {
        Object line = "";
        if (null == value) {
            line = "                     /" + key + lineSep;
            return line;
        }
        line = quote ? "                     /" + key + "=\"" + value + "\"" : "                     /" + key + "=" + value;
        if (((String)line).length() <= 80) {
            return (String)line + lineSep;
        }
        Object goodlines = "";
        while (!"".equals(((String)line).replaceAll("^\\s+", ""))) {
            int index;
            if (((String)line).length() <= 80) {
                goodlines = (String)goodlines + (String)line + lineSep;
                break;
            }
            for (index = Math.min(((String)line).length() - 1, 80); index > 21 && ' ' != ((String)line).charAt(index); --index) {
            }
            if (' ' != ((String)line).charAt(index)) {
                index = 80;
            }
            assert (index <= 80);
            goodlines = (String)goodlines + ((String)line).substring(0, index) + lineSep;
            line = QUALIFIER_INDENT_STR + ((String)line).substring(index).replaceAll("^\\s+", "");
        }
        return goodlines;
    }

    private String _wrap_location(String location) {
        int length = 59;
        if (location.length() <= length) {
            return location;
        }
        int index = location.substring(0, length).lastIndexOf(",");
        if (-1 == index) {
            return location;
        }
        return location.substring(0, index + 1) + lineSep + QUALIFIER_INDENT_STR + this._wrap_location(location.substring(index + 1));
    }

    protected String _write_feature(FeatureInterface<AbstractSequence<C>, C> feature, int record_length) {
        String location = this._insdc_feature_location_string(feature, record_length);
        String f_type = feature.getType().replace(" ", "_");
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format(QUALIFIER_INDENT_TMP, f_type);
        String line = formatter.toString().substring(0, 21) + this._wrap_location(location) + lineSep;
        formatter.close();
        for (List<Qualifier> qualifiers : feature.getQualifiers().values()) {
            for (Qualifier q : qualifiers) {
                if (q instanceof DBReferenceInfo) {
                    DBReferenceInfo db = (DBReferenceInfo)q;
                    line = line + this._write_feature_qualifier(q.getName().replaceAll("%", "%%"), db.getDatabase().replaceAll("%", "%%") + ":" + db.getId().replaceAll("%", "%%"), db.needsQuotes());
                    continue;
                }
                line = line + this._write_feature_qualifier(q.getName().replaceAll("%", "%%"), q.getValue().replaceAll("%", "%%"), q.needsQuotes());
            }
        }
        return line;
    }

    private String _insdc_feature_location_string(FeatureInterface<AbstractSequence<C>, C> feature, int record_length) {
        if (feature.getChildrenFeatures().isEmpty()) {
            if (feature.getLocations().getSubLocations().isEmpty()) {
                String location = this._insdc_location_string_ignoring_strand_and_subfeatures(feature.getLocations(), record_length);
                if (feature.getLocations().getStrand() == Strand.NEGATIVE) {
                    StringBuilder sb = new StringBuilder();
                    Formatter formatter = new Formatter(sb, Locale.US);
                    formatter.format("complement(%s)", location);
                    String output = formatter.toString();
                    formatter.close();
                    location = output;
                }
                return location;
            }
            if (feature.getLocations().getStrand() == Strand.NEGATIVE) {
                for (Location l : feature.getLocations().getSubLocations()) {
                    if (l.getStrand() == Strand.NEGATIVE) continue;
                    StringBuilder sb = new StringBuilder();
                    Formatter formatter = new Formatter(sb, Locale.US);
                    formatter.format("Inconsistent strands: %s for parent, %s for child", new Object[]{feature.getLocations().getStrand(), l.getStrand()});
                    String output = formatter.toString();
                    formatter.close();
                    throw new RuntimeException(output);
                }
                StringBuilder sb = new StringBuilder();
                Formatter formatter = new Formatter(sb, Locale.US);
                ArrayList<String> locations = new ArrayList<String>();
                for (Location l : feature.getLocations().getSubLocations()) {
                    locations.add(this._insdc_location_string_ignoring_strand_and_subfeatures((AbstractLocation)l, record_length));
                }
                String location = StringManipulationHelper.join(locations, ",");
                formatter.format("complement(%s(%s))", "join", location);
                String output = formatter.toString();
                formatter.close();
                return output;
            }
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.US);
            ArrayList<String> locations = new ArrayList<String>();
            for (Location l : feature.getLocations().getSubLocations()) {
                locations.add(this._insdc_location_string_ignoring_strand_and_subfeatures((AbstractLocation)l, record_length));
            }
            String location = StringManipulationHelper.join(locations, ",");
            formatter.format("%s(%s)", "join", location);
            String output = formatter.toString();
            formatter.close();
            return output;
        }
        if (feature.getLocations().getStrand() == Strand.NEGATIVE) {
            for (FeatureInterface<AbstractSequence<C>, C> f : feature.getChildrenFeatures()) {
                if (f.getLocations().getStrand() == Strand.NEGATIVE) continue;
                StringBuilder sb = new StringBuilder();
                Formatter formatter = new Formatter(sb, Locale.US);
                formatter.format("Inconsistent strands: %s for parent, %s for child", new Object[]{feature.getLocations().getStrand(), f.getLocations().getStrand()});
                String output = formatter.toString();
                formatter.close();
                throw new RuntimeException(output);
            }
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.US);
            ArrayList<String> locations = new ArrayList<String>();
            for (FeatureInterface<AbstractSequence<C>, C> f : feature.getChildrenFeatures()) {
                locations.add(this._insdc_location_string_ignoring_strand_and_subfeatures(f.getLocations(), record_length));
            }
            String location = StringManipulationHelper.join(locations, ",");
            formatter.format("complement(%s(%s))", "join", location);
            String output = formatter.toString();
            formatter.close();
            return output;
        }
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        ArrayList<String> locations = new ArrayList<String>();
        for (FeatureInterface<AbstractSequence<C>, C> f : feature.getChildrenFeatures()) {
            locations.add(this._insdc_location_string_ignoring_strand_and_subfeatures(f.getLocations(), record_length));
        }
        String location = StringManipulationHelper.join(locations, ",");
        formatter.format("%s(%s)", "join", location);
        String output = formatter.toString();
        formatter.close();
        return output;
    }

    private String _insdc_location_string_ignoring_strand_and_subfeatures(AbstractLocation sequenceLocation, int record_length) {
        String ref = "";
        if (!sequenceLocation.getStart().isUncertain() && !sequenceLocation.getEnd().isUncertain() && sequenceLocation.getStart() == sequenceLocation.getEnd()) {
            if (sequenceLocation.getEnd().getPosition() == record_length) {
                StringBuilder sb = new StringBuilder();
                Formatter formatter = new Formatter(sb, Locale.US);
                formatter.format("%s%d^1", ref, record_length);
                String output = formatter.toString();
                formatter.close();
                return output;
            }
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.US);
            formatter.format("%s%d^%d", ref, sequenceLocation.getStart().getPosition(), sequenceLocation.getEnd().getPosition());
            String output = formatter.toString();
            formatter.close();
            return output;
        }
        if (!sequenceLocation.getStart().isUncertain() && !sequenceLocation.getEnd().isUncertain() && sequenceLocation.getStart().getPosition() + 1 == sequenceLocation.getEnd().getPosition()) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.US);
            formatter.format("%s%d", ref, sequenceLocation.getEnd().getPosition());
            String output = formatter.toString();
            formatter.close();
            return output;
        }
        if (sequenceLocation.getStart().isUnknown() || sequenceLocation.getEnd().isUnknown()) {
            if (sequenceLocation.getStart().isUnknown() && sequenceLocation.getEnd().isUnknown()) {
                throw new RuntimeException("Feature with unknown location");
            }
            if (sequenceLocation.getStart().isUnknown()) {
                StringBuilder sb = new StringBuilder();
                Formatter formatter = new Formatter(sb, Locale.US);
                formatter.format("%s<%d..%s", ref, sequenceLocation.getEnd().getPosition(), this._insdc_feature_position_string(sequenceLocation.getEnd()));
                String output = formatter.toString();
                formatter.close();
                return output;
            }
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.US);
            formatter.format("%s%s..>%d", ref, this._insdc_feature_position_string(sequenceLocation.getStart()), sequenceLocation.getStart().getPosition());
            String output = formatter.toString();
            formatter.close();
            return output;
        }
        Object start = this._insdc_feature_position_string(sequenceLocation.getStart());
        Object end = this._insdc_feature_position_string(sequenceLocation.getEnd());
        if (sequenceLocation.isPartial()) {
            if (sequenceLocation.isPartialOn5prime()) {
                start = "<" + (String)start;
            }
            if (sequenceLocation.isPartialOn3prime()) {
                end = ">" + (String)end;
            }
        }
        return ref + (String)start + ".." + (String)end;
    }

    private String _insdc_feature_position_string(Point location) {
        return this._insdc_feature_position_string(location, 0);
    }

    private String _insdc_feature_position_string(Point location, int increment) {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%s", location.getPosition() + increment);
        String output = formatter.toString();
        formatter.close();
        return output;
    }

    protected ArrayList<String> _split_multi_line(String text, int max_len) {
        ArrayList<String> output = new ArrayList<String>();
        if (((String)(text = ((String)text).trim())).length() <= max_len) {
            output.add((String)text);
            return output;
        }
        ArrayList words = new ArrayList();
        Collections.addAll(words, ((String)text).split("\\s+"));
        while (!words.isEmpty()) {
            text = (String)words.remove(0);
            while (!words.isEmpty() && ((String)text).length() + 1 + ((String)words.get(0)).length() <= max_len) {
                text = (String)text + " " + (String)words.remove(0);
                text = ((String)text).trim();
            }
            output.add((String)text);
        }
        assert (words.isEmpty());
        return output;
    }
}

