/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.search.io.blast;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathException;
import org.biojava.nbio.core.search.io.Hit;
import org.biojava.nbio.core.search.io.Hsp;
import org.biojava.nbio.core.search.io.Result;
import org.biojava.nbio.core.search.io.ResultFactory;
import org.biojava.nbio.core.search.io.blast.BlastHitBuilder;
import org.biojava.nbio.core.search.io.blast.BlastHspBuilder;
import org.biojava.nbio.core.search.io.blast.BlastResultBuilder;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BlastXMLParser
implements ResultFactory {
    private static final Logger logger = LoggerFactory.getLogger(Hsp.class);
    Document blastDoc = null;
    private File targetFile;
    private List<Sequence> queryReferences;
    private List<Sequence> databaseReferences;
    private Map<String, Sequence> queryReferencesMap;
    private Map<String, Sequence> databaseReferencesMap;

    @Override
    public void setFile(File f) {
        this.targetFile = f;
    }

    private void readFile(String blastFile) throws IOException, ParseException {
        logger.info("Start reading " + blastFile);
        try {
            this.blastDoc = XMLHelper.loadXML(blastFile);
        }
        catch (SAXException ex) {
            logger.error("A parsing error has occurred while reading XML blast file");
            throw new ParseException(ex.getMessage(), 0);
        }
        catch (ParserConfigurationException ex) {
            logger.error("Internal XML parser non properly configured");
            throw new ParseException(ex.getMessage(), 0);
        }
        logger.info("Read finished");
    }

    @Override
    public List<Result> createObjects(double maxEScore) throws IOException, ParseException {
        ArrayList<Result> resultsCollection;
        if (this.targetFile == null) {
            throw new IllegalStateException("File to be parsed not specified.");
        }
        this.readFile(this.targetFile.getAbsolutePath());
        this.mapIds();
        try {
            String program = XMLHelper.selectSingleElement(this.blastDoc.getDocumentElement(), "BlastOutput_program").getTextContent();
            String version = XMLHelper.selectSingleElement(this.blastDoc.getDocumentElement(), "BlastOutput_version").getTextContent();
            String reference = XMLHelper.selectSingleElement(this.blastDoc.getDocumentElement(), "BlastOutput_reference").getTextContent();
            String dbFile = XMLHelper.selectSingleElement(this.blastDoc.getDocumentElement(), "BlastOutput_db").getTextContent();
            logger.info("Query for hits in " + this.targetFile);
            List<Element> IterationsList = XMLHelper.selectElements(this.blastDoc.getDocumentElement(), "BlastOutput_iterations/Iteration[Iteration_hits]");
            logger.info(IterationsList.size() + " results");
            resultsCollection = new ArrayList<Result>();
            for (Element element : IterationsList) {
                BlastResultBuilder resultBuilder = new BlastResultBuilder();
                resultBuilder.setProgram(program).setVersion(version).setReference(reference).setDbFile(dbFile);
                resultBuilder.setIterationNumber(Integer.valueOf(XMLHelper.selectSingleElement(element, "Iteration_iter-num").getTextContent())).setQueryID(XMLHelper.selectSingleElement(element, "Iteration_query-ID").getTextContent()).setQueryDef(XMLHelper.selectSingleElement(element, "Iteration_query-def").getTextContent()).setQueryLength(Integer.valueOf(XMLHelper.selectSingleElement(element, "Iteration_query-len").getTextContent()));
                if (this.queryReferences != null) {
                    resultBuilder.setQuerySequence(this.queryReferencesMap.get(XMLHelper.selectSingleElement(element, "Iteration_query-ID").getTextContent()));
                }
                Element iterationHitsElement = XMLHelper.selectSingleElement(element, "Iteration_hits");
                List<Element> hitList = XMLHelper.selectElements(iterationHitsElement, "Hit");
                ArrayList<Hit> hitsCollection = new ArrayList<Hit>();
                for (Element hitElement : hitList) {
                    BlastHitBuilder blastHitBuilder = new BlastHitBuilder();
                    blastHitBuilder.setHitNum(Integer.valueOf(XMLHelper.selectSingleElement(hitElement, "Hit_num").getTextContent())).setHitId(XMLHelper.selectSingleElement(hitElement, "Hit_id").getTextContent()).setHitDef(XMLHelper.selectSingleElement(hitElement, "Hit_def").getTextContent()).setHitAccession(XMLHelper.selectSingleElement(hitElement, "Hit_accession").getTextContent()).setHitLen(Integer.valueOf(XMLHelper.selectSingleElement(hitElement, "Hit_len").getTextContent()));
                    if (this.databaseReferences != null) {
                        blastHitBuilder.setHitSequence(this.databaseReferencesMap.get(XMLHelper.selectSingleElement(hitElement, "Hit_id").getTextContent()));
                    }
                    Element hithspsElement = XMLHelper.selectSingleElement(hitElement, "Hit_hsps");
                    List<Element> hspList = XMLHelper.selectElements(hithspsElement, "Hsp");
                    ArrayList<Hsp> hspsCollection = new ArrayList<Hsp>();
                    for (Element hspElement : hspList) {
                        Double evalue = Double.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_evalue").getTextContent());
                        if (!(evalue <= maxEScore)) continue;
                        BlastHspBuilder blastHspBuilder = new BlastHspBuilder();
                        blastHspBuilder.setHspNum(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_num").getTextContent())).setHspBitScore(Double.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_bit-score").getTextContent())).setHspScore(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_score").getTextContent())).setHspEvalue(evalue).setHspQueryFrom(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_query-from").getTextContent())).setHspQueryTo(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_query-to").getTextContent())).setHspHitFrom(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_hit-from").getTextContent())).setHspHitTo(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_hit-to").getTextContent())).setHspQueryFrame(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_query-frame").getTextContent())).setHspHitFrame(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_hit-frame").getTextContent())).setHspIdentity(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_identity").getTextContent())).setHspPositive(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_positive").getTextContent())).setHspGaps(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_gaps").getTextContent())).setHspAlignLen(Integer.valueOf(XMLHelper.selectSingleElement(hspElement, "Hsp_align-len").getTextContent())).setHspQseq(XMLHelper.selectSingleElement(hspElement, "Hsp_qseq").getTextContent()).setHspHseq(XMLHelper.selectSingleElement(hspElement, "Hsp_hseq").getTextContent()).setHspIdentityString(XMLHelper.selectSingleElement(hspElement, "Hsp_midline").getTextContent());
                        hspsCollection.add(blastHspBuilder.createBlastHsp());
                    }
                    blastHitBuilder.setHsps(hspsCollection);
                    hitsCollection.add(blastHitBuilder.createBlastHit());
                }
                resultBuilder.setHits(hitsCollection);
                resultsCollection.add(resultBuilder.createBlastResult());
            }
        }
        catch (XPathException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        logger.info("Parsing of " + this.targetFile + " finished.");
        return resultsCollection;
    }

    @Override
    public List<String> getFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(1);
        extensions.add("blastxml");
        return extensions;
    }

    @Override
    public void setQueryReferences(List<Sequence> sequences) {
        this.queryReferences = sequences;
    }

    @Override
    public void setDatabaseReferences(List<Sequence> sequences) {
        this.databaseReferences = sequences;
    }

    private void mapIds() {
        String id;
        int counter;
        if (this.queryReferences != null) {
            this.queryReferencesMap = new HashMap<String, Sequence>(this.queryReferences.size());
            for (counter = 0; counter < this.queryReferences.size(); ++counter) {
                id = "Query_" + (counter + 1);
                this.queryReferencesMap.put(id, this.queryReferences.get(counter));
            }
        }
        if (this.databaseReferences != null) {
            this.databaseReferencesMap = new HashMap<String, Sequence>(this.databaseReferences.size());
            for (counter = 0; counter < this.databaseReferences.size(); ++counter) {
                id = "gnl|BL_ORD_ID|" + counter;
                this.databaseReferencesMap.put(id, this.databaseReferences.get(counter));
            }
        }
    }

    @Override
    public void storeObjects(List<Result> results) throws IOException, ParseException {
        throw new UnsupportedOperationException("This parser does not support writing yet.");
    }
}

