/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.core.exceptions.ParserException;
import org.biojava.nbio.core.sequence.DataSource;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.RNACompoundSet;
import org.biojava.nbio.core.sequence.features.AbstractFeature;
import org.biojava.nbio.core.sequence.features.DBReferenceInfo;
import org.biojava.nbio.core.sequence.features.Qualifier;
import org.biojava.nbio.core.sequence.features.TextFeature;
import org.biojava.nbio.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava.nbio.core.sequence.io.template.SequenceParserInterface;
import org.biojava.nbio.core.sequence.location.InsdcParser;
import org.biojava.nbio.core.sequence.location.template.AbstractLocation;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.reference.GenbankReference;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenbankSequenceParser<S extends AbstractSequence<C>, C extends Compound>
implements SequenceParserInterface {
    private String seqData = null;
    private GenericGenbankHeaderParser<S, C> headerParser;
    private String header;
    private String accession;
    private boolean isCircularSequence;
    private Map<String, List<DBReferenceInfo>> mapDB;
    private Map<String, List<AbstractFeature<AbstractSequence<C>, C>>> featureCollection;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private CompoundSet<?> compoundType;
    public static final String GENBANK_FORMAT = "GENBANK";
    protected static final String LOCUS_TAG = "LOCUS";
    protected static final String DEFINITION_TAG = "DEFINITION";
    protected static final String ACCESSION_TAG = "ACCESSION";
    protected static final String VERSION_TAG = "VERSION";
    protected static final String KEYWORDS_TAG = "KEYWORDS";
    protected static final String SOURCE_TAG = "SOURCE";
    protected static final String ORGANISM_TAG = "ORGANISM";
    protected static final String REFERENCE_TAG = "REFERENCE";
    protected static final String AUTHORS_TAG = "AUTHORS";
    protected static final String CONSORTIUM_TAG = "CONSRTM";
    protected static final String TITLE_TAG = "TITLE";
    protected static final String JOURNAL_TAG = "JOURNAL";
    protected static final String PUBMED_TAG = "PUBMED";
    protected static final String MEDLINE_TAG = "MEDLINE";
    protected static final String REMARK_TAG = "REMARK";
    protected static final String COMMENT_TAG = "COMMENT";
    protected static final String FEATURE_TAG = "FEATURES";
    protected static final String BASE_COUNT_TAG_FULL = "BASE COUNT";
    protected static final String BASE_COUNT_TAG = "BASE";
    protected static final String START_SEQUENCE_TAG = "ORIGIN";
    protected static final String DBSOURCE = "DBSOURCE";
    protected static final String PRIMARY = "PRIMARY";
    protected static final String DBLINK = "DBLINK";
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final Pattern lp = Pattern.compile("^(\\S+[\\S ]*\\S*)\\s+(\\d+)\\s+(bp|BP|aa|AA)\\s{0,4}(([dmsDMS][sS]-)?(\\S+))?\\s*(circular|CIRCULAR|linear|LINEAR)?\\s*(\\S+)?\\s*(\\S+)?$");
    protected static final Pattern lp2 = Pattern.compile("^(\\d+)\\s+(bp|BP|aa|AA)\\s{0,4}(([dmsDMS][sS]-)?(\\S+))?\\s*(circular|CIRCULAR|linear|LINEAR)?\\s*(\\S+)?\\s*(\\S+)?$");
    protected static final Pattern vp = Pattern.compile("^(\\S*?)(\\.(\\d+))?(\\s+GI:(\\S+))?$");
    protected static final Pattern refRange = Pattern.compile("^\\s*(\\d+)\\s+to\\s+(\\d+)$");
    protected static final Pattern refp = Pattern.compile("^(\\d+)\\s*(?:(\\((?:bases|residues)\\s+(\\d+\\s+to\\s+\\d+(\\s*;\\s*\\d+\\s+to\\s+\\d+)*)\\))|\\(sites\\))?");
    protected static final Pattern dbxp = Pattern.compile("^([^:]+):(\\S+)$");
    protected static final InsdcParser locationParser = new InsdcParser(DataSource.GENBANK);
    protected static final Pattern sectp = Pattern.compile("^(\\s{0,8}(\\S+)\\s{0,7}(.*)|\\s{21}(/\\S+?)=(.*)|\\s{21}(/\\S+))$");
    protected static final Pattern readableFiles = Pattern.compile(".*(g[bp]k*$|\\u002eg[bp].*)");
    protected static final Pattern headerLine = Pattern.compile("^LOCUS.*");

    private String parse(BufferedReader bufferedReader) {
        String sectionKey;
        block32: do {
            List<String[]> section;
            if ((sectionKey = (section = this.readSection(bufferedReader)).get(0)[0]) == null) {
                if (section.get(0)[1] == null || "".equals(section.get(0)[1]) || section.get(0)[1].length() == 0) {
                    throw new ParserException("end of file");
                }
                throw new ParserException("section key is null");
            }
            switch (sectionKey) {
                case "LOCUS": {
                    this.parseLocusTag(section);
                    break;
                }
                case "DEFINITION": {
                    this.parseDefinitionTag(section);
                    break;
                }
                case "ACCESSION": {
                    this.parseAccessionTag(section);
                    break;
                }
                case "VERSION": {
                    this.parseVersionTag(section);
                    break;
                }
                case "KEYWORDS": {
                    break;
                }
                case "SOURCE": {
                    break;
                }
                case "REFERENCE": {
                    this.parseReferenceTag(section);
                    break;
                }
                case "COMMENT": {
                    this.parseCommentTag(section);
                    break;
                }
                case "FEATURES": {
                    this.parseFeatureTag(section);
                    break;
                }
                case "BASE": {
                    break;
                }
                case "ORIGIN": {
                    this.parseStartSequenceTag(section);
                    break;
                }
                case "DBSOURCE": {
                    break;
                }
                case "PRIMARY": {
                    break;
                }
                case "DBLINK": {
                    break;
                }
                default: {
                    if (sectionKey.equals(END_SEQUENCE_TAG)) continue block32;
                    this.log.info("found unknown section key: %", (Object)sectionKey);
                }
            }
        } while (!sectionKey.equals(END_SEQUENCE_TAG));
        return this.seqData;
    }

    private void parseStartSequenceTag(List<String[]> section) {
        StringBuilder seq = new StringBuilder();
        for (int i = 1; i < section.size(); ++i) {
            seq.append(section.get(i)[1]);
        }
        this.seqData = seq.toString().replaceAll("\\s+", "").replaceAll("[\\.|~]", "-").toUpperCase();
    }

    private void parseFeatureTag(List<String[]> section) {
        TextFeature gbFeature = null;
        for (int i = 1; i < section.size(); ++i) {
            String key = section.get(i)[0];
            String val = section.get(i)[1];
            if (key.startsWith("/")) {
                Qualifier q;
                if (gbFeature == null) {
                    throw new ParserException("Malformed GenBank file: found a qualifier without feature.");
                }
                Boolean needsQuotes = false;
                key = key.substring(1);
                if ((val = val.replaceAll("\\s*[\\n\\r]+\\s*", " ").trim()).endsWith("\"")) {
                    val = val.substring(1, val.length() - 1);
                    needsQuotes = true;
                }
                if ("db_xref".equals(key)) {
                    Matcher m = dbxp.matcher(val);
                    if (m.matches()) {
                        String dbname = m.group(1);
                        String raccession = m.group(2);
                        DBReferenceInfo xref = new DBReferenceInfo(dbname, raccession);
                        xref.setNeedsQuotes(needsQuotes);
                        gbFeature.addQualifier(key, xref);
                        ArrayList<DBReferenceInfo> listDBEntry = new ArrayList<DBReferenceInfo>();
                        listDBEntry.add(xref);
                        this.mapDB.put(key, listDBEntry);
                        continue;
                    }
                    throw new ParserException("Bad dbxref");
                }
                if ("organism".equalsIgnoreCase(key)) {
                    q = new Qualifier(key, val.replace('\n', ' '), needsQuotes);
                    gbFeature.addQualifier(key, q);
                    continue;
                }
                if ("translation".equalsIgnoreCase(key) || "anticodon".equals(key) || "transl_except".equals(key)) {
                    val = val.replaceAll("\\s+", "");
                    q = new Qualifier(key, val, needsQuotes);
                    gbFeature.addQualifier(key, q);
                    continue;
                }
                q = new Qualifier(key, val, needsQuotes);
                gbFeature.addQualifier(key, q);
                continue;
            }
            gbFeature = new TextFeature(key, val, key, key);
            Location l = locationParser.parse(val);
            gbFeature.setLocation((AbstractLocation)l);
            if (!this.featureCollection.containsKey(key)) {
                this.featureCollection.put(key, new ArrayList());
            }
            this.featureCollection.get(key).add(gbFeature);
        }
    }

    private void parseCommentTag(List<String[]> section) {
        this.headerParser.setComment(section.get(0)[1]);
    }

    private void parseReferenceTag(List<String[]> section) {
        GenbankReference genbankReference = new GenbankReference();
        for (String[] ref : section) {
            if (ref[0].equals(AUTHORS_TAG)) {
                genbankReference.setAuthors(ref[1]);
                continue;
            }
            if (ref[0].equals(TITLE_TAG)) {
                genbankReference.setTitle(ref[1]);
                continue;
            }
            if (!ref[0].equals(JOURNAL_TAG)) continue;
            genbankReference.setJournal(ref[1]);
        }
        this.headerParser.addReference(genbankReference);
    }

    private void parseVersionTag(List<String[]> section) {
        String ver = section.get(0)[1];
        Matcher m = vp.matcher(ver);
        if (m.matches()) {
            String verAcc = m.group(1);
            if (!this.accession.equals(verAcc)) {
                this.accession = verAcc;
            }
            if (m.group(3) != null) {
                this.headerParser.setVersion(Integer.parseInt(m.group(3)));
            }
            if (m.group(5) != null) {
                this.headerParser.setIdentifier(m.group(5));
            }
        } else {
            throw new ParserException("Bad version line");
        }
    }

    private void parseAccessionTag(List<String[]> section) {
        String[] accs = section.get(0)[1].split("\\s+");
        this.accession = accs[0].trim();
        this.headerParser.setAccession(this.accession);
    }

    private void parseDefinitionTag(List<String[]> section) {
        this.headerParser.setDescription(section.get(0)[1]);
    }

    private void parseLocusTag(List<String[]> section) {
        String loc;
        this.header = loc = section.get(0)[1];
        Matcher m = lp.matcher(loc);
        Matcher m2 = lp2.matcher(loc);
        if (m.matches()) {
            String name = m.group(1).trim().replaceAll(" ", "_");
            this.headerParser.setName(name);
            this.headerParser.setAccession(name);
            long sequenceLength = Long.valueOf(m.group(2));
            String lengthUnits = m.group(3);
            String type = m.group(6);
            if ("aa".equalsIgnoreCase(lengthUnits)) {
                this.compoundType = AminoAcidCompoundSet.getAminoAcidCompoundSet();
            } else if ("bp".equalsIgnoreCase(lengthUnits)) {
                this.compoundType = type != null ? (type.contains("RNA") ? RNACompoundSet.getRNACompoundSet() : DNACompoundSet.getDNACompoundSet()) : DNACompoundSet.getDNACompoundSet();
            }
            if (m.group(7) != null) {
                this.isCircularSequence = "circular".equalsIgnoreCase(m.group(7));
            }
            locationParser.setSequenceLength(sequenceLength);
            locationParser.setSequenceCircular(this.isCircularSequence);
            this.log.debug("compound type: {}", (Object)this.compoundType.getClass().getSimpleName());
        } else if (m2.matches()) {
            this.headerParser.setName("");
            this.headerParser.setAccession("");
            long sequenceLength = Long.valueOf(m2.group(1));
            String lengthUnits = m2.group(2);
            String type = m2.group(5);
            if ("aa".equalsIgnoreCase(lengthUnits)) {
                this.compoundType = AminoAcidCompoundSet.getAminoAcidCompoundSet();
            } else if ("bp".equalsIgnoreCase(lengthUnits)) {
                this.compoundType = type != null ? (type.contains("RNA") ? RNACompoundSet.getRNACompoundSet() : DNACompoundSet.getDNACompoundSet()) : DNACompoundSet.getDNACompoundSet();
            }
            if (m2.group(6) != null) {
                this.isCircularSequence = "circular".equalsIgnoreCase(m2.group(6));
            }
            locationParser.setSequenceLength(sequenceLength);
            locationParser.setSequenceCircular(this.isCircularSequence);
            this.log.debug("compound type: {}", (Object)this.compoundType.getClass().getSimpleName());
        } else {
            throw new ParserException("Bad locus line");
        }
    }

    private List<String[]> readSection(BufferedReader bufferedReader) {
        ArrayList<String[]> section = new ArrayList<String[]>();
        String currKey = null;
        StringBuilder currVal = new StringBuilder();
        boolean done = false;
        int linecount = 0;
        try {
            while (!done) {
                String firstSecKey;
                bufferedReader.mark(320);
                String line = bufferedReader.readLine();
                String string = firstSecKey = section.isEmpty() ? "" : ((String[])section.get(0))[0];
                if (line != null && line.matches("\\p{Space}*")) continue;
                if (line == null || !line.startsWith(" ") && linecount++ > 0 && (!firstSecKey.equals(START_SEQUENCE_TAG) || line.startsWith(END_SEQUENCE_TAG))) {
                    section.add(new String[]{currKey, currVal.toString()});
                    bufferedReader.reset();
                    done = true;
                    continue;
                }
                Matcher m = sectp.matcher(line);
                if (m.matches()) {
                    if (currKey != null) {
                        section.add(new String[]{currKey, currVal.toString()});
                    }
                    currKey = m.group(2) == null ? (m.group(4) == null ? m.group(6) : m.group(4)) : m.group(2);
                    currVal = new StringBuilder();
                    currVal.append((m.group(2) == null ? (m.group(4) == null ? "" : m.group(5)) : m.group(3)).trim());
                    continue;
                }
                if (line.startsWith(START_SEQUENCE_TAG) || line.startsWith(END_SEQUENCE_TAG)) {
                    currKey = line;
                    continue;
                }
                currVal.append("\n");
                currVal.append(currKey.charAt(0) == '/' ? line.substring(21) : line.substring(12));
            }
        }
        catch (IOException | RuntimeException e) {
            throw new ParserException(e.getMessage());
        }
        return section;
    }

    @Override
    public String getSequence(BufferedReader bufferedReader, int sequenceLength) {
        this.featureCollection = new HashMap<String, List<AbstractFeature<AbstractSequence<C>, C>>>();
        this.mapDB = new LinkedHashMap<String, List<DBReferenceInfo>>();
        this.headerParser = new GenericGenbankHeaderParser();
        try {
            this.parse(bufferedReader);
        }
        catch (ParserException e) {
            if (e.getMessage().equalsIgnoreCase("end of file")) {
                return null;
            }
            throw new ParserException(e.getMessage());
        }
        return this.seqData;
    }

    public String getHeader() {
        return this.header;
    }

    public GenericGenbankHeaderParser<S, C> getSequenceHeaderParser() {
        return this.headerParser;
    }

    public Map<String, List<DBReferenceInfo>> getDatabaseReferences() {
        return this.mapDB;
    }

    public List<String> getKeyWords() {
        return new ArrayList<String>(this.featureCollection.keySet());
    }

    public List<AbstractFeature<AbstractSequence<C>, C>> getFeatures(String keyword) {
        return this.featureCollection.get(keyword);
    }

    public Map<String, List<AbstractFeature<AbstractSequence<C>, C>>> getFeatures() {
        return this.featureCollection;
    }

    public void parseFeatures(AbstractSequence<C> sequence) {
        for (String k : this.featureCollection.keySet()) {
            for (AbstractFeature<AbstractSequence<C>, C> f : this.featureCollection.get(k)) {
                sequence.addFeature(f);
            }
        }
    }

    public CompoundSet<?> getCompoundType() {
        return this.compoundType;
    }
}

