/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadUtils {
    private static final String SIZE_EXT = ".size";
    private static final String HASH_EXT = ".hash";
    private static final Logger logger = LoggerFactory.getLogger(FileDownloadUtils.class);

    public static String getFileExtension(File f) {
        String fileName = f.getName();
        String ext = "";
        int mid = fileName.lastIndexOf(".");
        ext = fileName.substring(mid + 1);
        return ext;
    }

    public static String getFilePrefix(File f) {
        String fileName = f.getName();
        int mid = fileName.indexOf(".");
        if (mid < 0) {
            return fileName;
        }
        return fileName.substring(0, mid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(URL url, File destination) throws IOException {
        int count = 0;
        int maxTries = 10;
        int timeout = 60000;
        File tempFile = Files.createTempFile(FileDownloadUtils.getFilePrefix(destination), "." + FileDownloadUtils.getFileExtension(destination), new FileAttribute[0]).toFile();
        Channel rbc = null;
        FileOutputStream fos = null;
        while (true) {
            try {
                URLConnection connection = FileDownloadUtils.prepareURLConnection(url.toString(), timeout);
                connection.connect();
                InputStream inputStream = connection.getInputStream();
                rbc = Channels.newChannel(inputStream);
                fos = new FileOutputStream(tempFile);
                fos.getChannel().transferFrom((ReadableByteChannel)rbc, 0L, Long.MAX_VALUE);
            }
            catch (SocketTimeoutException e) {
                if (++count != maxTries) continue;
                throw e;
            }
            finally {
                if (rbc != null) {
                    rbc.close();
                }
                if (fos == null) continue;
                fos.close();
                continue;
            }
            break;
        }
        logger.debug("Copying temp file [{}] to final location [{}]", (Object)tempFile, (Object)destination);
        Files.copy(tempFile.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        tempFile.delete();
    }

    public static void createValidationFiles(URL url, File localDestination, URL hashURL, Hash hash) {
        try {
            URLConnection resourceConnection = url.openConnection();
            FileDownloadUtils.createValidationFiles(resourceConnection, localDestination, hashURL, Hash.UNKNOWN);
        }
        catch (IOException e) {
            logger.warn("could not open connection to resource file due to exception: {}", (Object)e.getMessage());
        }
    }

    public static void createValidationFiles(URLConnection resourceUrlConnection, File localDestination, URL hashURL, Hash hash) {
        long size = resourceUrlConnection.getContentLengthLong();
        if (size == -1L) {
            logger.debug("Could not find expected file size for resource {}. Size validation metadata file won't be available for this download.", (Object)resourceUrlConnection.getURL());
        } else {
            logger.debug("Content-Length: {}", (Object)size);
            File sizeFile = new File(localDestination.getParentFile(), localDestination.getName() + SIZE_EXT);
            try (PrintStream sizePrintStream = new PrintStream(sizeFile);){
                sizePrintStream.print(size);
            }
            catch (FileNotFoundException e) {
                logger.warn("Could not write size validation metadata file due to exception: {}", (Object)e.getMessage());
            }
        }
        if (hashURL == null) {
            return;
        }
        if (hash == Hash.UNKNOWN) {
            throw new IllegalArgumentException("Hash URL given but algorithm is unknown");
        }
        try {
            File hashFile = new File(localDestination.getParentFile(), String.format("%s%s_%s", new Object[]{localDestination.getName(), HASH_EXT, hash}));
            FileDownloadUtils.downloadFile(hashURL, hashFile);
        }
        catch (IOException e) {
            logger.warn("Could not write validation hash file due to exception: {}", (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateFile(final File localFile) {
        File[] hashFiles;
        File sizeFile = new File(localFile.getParentFile(), localFile.getName() + SIZE_EXT);
        if (sizeFile.exists()) {
            try (Scanner scanner = new Scanner(sizeFile);){
                long expectedSize = scanner.nextLong();
                long actualSize = localFile.length();
                if (expectedSize != actualSize) {
                    logger.warn("File [{}] size ({}) does not match expected size ({}).", new Object[]{localFile, actualSize, expectedSize});
                    boolean bl = false;
                    return bl;
                }
            }
            catch (FileNotFoundException e) {
                logger.warn("could not validate size of file [{}] because no size metadata file exists.", (Object)localFile);
            }
        }
        if ((hashFiles = localFile.getParentFile().listFiles(new FilenameFilter(){
            final String hashPattern;
            {
                this.hashPattern = String.format("%s%s_(%s|%s|%s)", new Object[]{localFile.getName(), FileDownloadUtils.HASH_EXT, Hash.MD5, Hash.SHA1, Hash.SHA256});
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(this.hashPattern);
            }
        })).length <= 0) return true;
        File hashFile = hashFiles[0];
        String name = hashFile.getName();
        String algo = name.substring(name.lastIndexOf(95) + 1);
        switch (Hash.valueOf(algo)) {
            case MD5: 
            case SHA1: 
            case SHA256: {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
        throw new IllegalArgumentException("Hashing algorithm not known: " + algo);
    }

    public static String toUnixPath(String path) {
        Object uPath = path;
        if (((String)uPath).contains("\\")) {
            uPath = ((String)uPath).replaceAll("\\\\", "/");
        }
        if (((String)uPath).endsWith("//")) {
            uPath = ((String)uPath).substring(0, ((String)uPath).length() - 1);
        }
        if (!((String)uPath).endsWith("/")) {
            uPath = (String)uPath + "/";
        }
        return uPath;
    }

    public static String expandUserHome(String file) {
        if (((String)(file = ((String)file).replaceAll("/", "\\" + File.separator))).startsWith("~") && (((String)file).length() == 1 || File.separator.equals(((String)file).substring(1, 2)))) {
            file = System.getProperty("user.home") + ((String)file).substring(1);
        }
        return file;
    }

    public static boolean ping(String url, int timeout) {
        try {
            HttpURLConnection connection = (HttpURLConnection)FileDownloadUtils.prepareURLConnection(url, timeout);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            return 200 <= responseCode && responseCode <= 399;
        }
        catch (IOException exception) {
            return false;
        }
    }

    public static URLConnection prepareURLConnection(String url, int timeout) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        connection.setReadTimeout(timeout);
        connection.setConnectTimeout(timeout);
        return connection;
    }

    public static void deleteDirectory(Path dir) throws IOException {
        if (dir == null || !Files.exists(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e != null) {
                    throw e;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteDirectory(String dir) throws IOException {
        FileDownloadUtils.deleteDirectory(Paths.get(dir, new String[0]));
    }

    public static enum Hash {
        MD5,
        SHA1,
        SHA256,
        UNKNOWN;

    }
}

