/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.RNACompoundSet;
import org.biojava.nbio.core.sequence.io.DNASequenceCreator;
import org.biojava.nbio.core.sequence.io.FileProxyDNASequenceCreator;
import org.biojava.nbio.core.sequence.io.FileProxyProteinSequenceCreator;
import org.biojava.nbio.core.sequence.io.FileProxyRNASequenceCreator;
import org.biojava.nbio.core.sequence.io.GenbankReader;
import org.biojava.nbio.core.sequence.io.GenbankSequenceParser;
import org.biojava.nbio.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava.nbio.core.sequence.io.ProteinSequenceCreator;
import org.biojava.nbio.core.sequence.io.RNASequenceCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenbankReaderHelper {
    private static final Logger logger = LoggerFactory.getLogger(GenbankReaderHelper.class);

    public static Map<String, DNASequence> readGenbankDNASequence(File file, boolean lazySequenceLoad) throws Exception {
        if (!lazySequenceLoad) {
            return GenbankReaderHelper.readGenbankDNASequence(file);
        }
        GenbankReader GenbankProxyReader = new GenbankReader(file, new GenericGenbankHeaderParser(), new FileProxyDNASequenceCreator(file, DNACompoundSet.getDNACompoundSet(), new GenbankSequenceParser()));
        return GenbankProxyReader.process();
    }

    public static Map<String, ProteinSequence> readGenbankProteinSequence(File file, boolean lazySequenceLoad) throws Exception {
        if (!lazySequenceLoad) {
            return GenbankReaderHelper.readGenbankProteinSequence(file);
        }
        GenbankReader GenbankProxyReader = new GenbankReader(file, new GenericGenbankHeaderParser(), new FileProxyProteinSequenceCreator(file, AminoAcidCompoundSet.getAminoAcidCompoundSet(), new GenbankSequenceParser()));
        return GenbankProxyReader.process();
    }

    public static Map<String, RNASequence> readGenbankRNASequence(File file, boolean lazySequenceLoad) throws Exception {
        if (!lazySequenceLoad) {
            return GenbankReaderHelper.readGenbankRNASequence(file);
        }
        GenbankReader GenbankProxyReader = new GenbankReader(file, new GenericGenbankHeaderParser(), new FileProxyRNASequenceCreator(file, RNACompoundSet.getRNACompoundSet(), new GenbankSequenceParser()));
        return GenbankProxyReader.process();
    }

    public static Map<String, ProteinSequence> readGenbankProteinSequence(File file) throws Exception {
        FileInputStream inStream = new FileInputStream(file);
        Map<String, ProteinSequence> proteinSequences = GenbankReaderHelper.readGenbankProteinSequence(inStream);
        inStream.close();
        return proteinSequences;
    }

    public static Map<String, ProteinSequence> readGenbankProteinSequence(InputStream inStream) throws Exception {
        GenbankReader GenbankReader2 = new GenbankReader(inStream, new GenericGenbankHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
        return GenbankReader2.process();
    }

    public static Map<String, DNASequence> readGenbankDNASequence(InputStream inStream) throws Exception {
        GenbankReader GenbankReader2 = new GenbankReader(inStream, new GenericGenbankHeaderParser(), new DNASequenceCreator(DNACompoundSet.getDNACompoundSet()));
        return GenbankReader2.process();
    }

    public static Map<String, DNASequence> readGenbankDNASequence(File file) throws Exception {
        FileInputStream inStream = new FileInputStream(file);
        Map<String, DNASequence> dnaSequences = GenbankReaderHelper.readGenbankDNASequence(inStream);
        inStream.close();
        return dnaSequences;
    }

    public static Map<String, RNASequence> readGenbankRNASequence(InputStream inStream) throws Exception {
        GenbankReader GenbankReader2 = new GenbankReader(inStream, new GenericGenbankHeaderParser(), new RNASequenceCreator(RNACompoundSet.getRNACompoundSet()));
        return GenbankReader2.process();
    }

    public static Map<String, RNASequence> readGenbankRNASequence(File file) throws Exception {
        FileInputStream inStream = new FileInputStream(file);
        Map<String, RNASequence> rnaSequences = GenbankReaderHelper.readGenbankRNASequence(inStream);
        inStream.close();
        return rnaSequences;
    }
}

