/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.io.GenbankWriter;
import org.biojava.nbio.core.sequence.io.GenericGenbankHeaderFormat;
import org.biojava.nbio.core.sequence.io.template.GenbankHeaderFormatInterface;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;

public class GenbankWriterHelper {
    public static final String LINEAR_DNA = "linear";
    public static final String CIRCULAR_DNA = "circular";

    public static void writeProteinSequence(File file, Collection<ProteinSequence> proteinSequences) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(file);
        BufferedOutputStream bo = new BufferedOutputStream(outputStream);
        GenbankWriterHelper.writeProteinSequence(bo, proteinSequences);
        bo.close();
        outputStream.close();
    }

    public static void writeProteinSequence(OutputStream outputStream, Collection<ProteinSequence> proteinSequences) throws Exception {
        GenbankWriter genbankWriter = new GenbankWriter(outputStream, proteinSequences, new GenericGenbankHeaderFormat());
        genbankWriter.process();
    }

    public static void writeNucleotideSequence(File file, Collection<DNASequence> dnaSequences) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(file);
        BufferedOutputStream bo = new BufferedOutputStream(outputStream);
        GenbankWriterHelper.writeNucleotideSequence(bo, dnaSequences);
        bo.close();
        outputStream.close();
    }

    public static void writeNucleotideSequence(OutputStream outputStream, Collection<DNASequence> dnaSequences) throws Exception {
        GenbankWriterHelper.writeNucleotideSequence(outputStream, dnaSequences, LINEAR_DNA);
    }

    public static void writeNucleotideSequence(OutputStream outputStream, Collection<DNASequence> dnaSequences, String seqType) throws Exception {
        GenericGenbankHeaderFormat genericGenbankHeaderFormat = new GenericGenbankHeaderFormat(seqType);
        GenbankWriter genbankWriter = new GenbankWriter(outputStream, dnaSequences, genericGenbankHeaderFormat);
        genbankWriter.process();
    }

    public static void writeNucleotideSequenceOriginal(OutputStream outputStream, Collection<DNASequence> dnaSequences) throws Exception {
        GenericGenbankHeaderFormat genericGenbankHeaderFormat = new GenericGenbankHeaderFormat(true);
        GenbankWriter genbankWriter = new GenbankWriter(outputStream, dnaSequences, genericGenbankHeaderFormat);
        genbankWriter.process();
    }

    public static void writeSequence(File file, Sequence<?> sequence) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(file);
        BufferedOutputStream bo = new BufferedOutputStream(outputStream);
        GenbankWriterHelper.writeSequences(bo, GenbankWriterHelper.singleSeqToCollection(sequence));
        bo.close();
        outputStream.close();
    }

    public static void writeSequence(OutputStream outputStream, Sequence<?> sequence) throws Exception {
        GenbankWriterHelper.writeSequences(outputStream, GenbankWriterHelper.singleSeqToCollection(sequence));
    }

    private static Collection<Sequence<?>> singleSeqToCollection(Sequence<?> sequence) {
        ArrayList sequences = new ArrayList();
        sequences.add(sequence);
        return sequences;
    }

    public static void writeSequences(OutputStream outputStream, Collection<Sequence<?>> sequences) throws Exception {
        GenbankHeaderFormatInterface fhfi = new GenbankHeaderFormatInterface<Sequence<?>, Compound>(){

            @Override
            public String getHeader(Sequence<?> sequence) {
                return sequence.getAccession().toString();
            }
        };
        GenbankWriter genbankWriter = new GenbankWriter(outputStream, sequences, fhfi);
        genbankWriter.process();
    }
}

