/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.gui;

import java.awt.Component;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentJmolDisplay;
import org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.MultipleAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.util.RotationAxis;
import org.biojava.nbio.structure.symmetry.core.AxisAligner;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.gui.SymmetryListener;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGenerator;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorPointGroup;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;
import org.jmol.util.Logger;

public class SymmetryDisplay {
    public static MultipleAlignmentJmol displayRepeats(CeSymmResult symm) throws StructureException {
        MultipleAlignment repeats = SymmetryTools.toRepeatsAlignment((CeSymmResult)symm);
        MultipleAlignmentJmol jmol = MultipleAlignmentJmolDisplay.display(repeats);
        jmol.setTitle(SymmetryDisplay.getSymmTitle(symm));
        return jmol;
    }

    public static MultipleAlignmentJmol displayFull(CeSymmResult symm) throws StructureException {
        MultipleAlignment full = SymmetryTools.toFullAlignment((CeSymmResult)symm);
        MultipleAlignmentJmol jmol = MultipleAlignmentJmolDisplay.display(full);
        jmol.setColorByBlocks(true);
        jmol.setTitle(SymmetryDisplay.getSymmTitle(symm));
        return jmol;
    }

    public static AbstractAlignmentJmol display(CeSymmResult symmResult) throws StructureException {
        if (symmResult.isSignificant() && symmResult.isRefined()) {
            MultipleAlignment msa = symmResult.getMultipleAlignment();
            List atoms = msa.getAtomArrays();
            MultipleAlignmentJmol jmol = new MultipleAlignmentJmol(msa, atoms);
            jmol.setTitle(jmol.getStructure().getPDBHeader().getTitle());
            SymmetryDisplay.addSymmetryMenu(jmol, symmResult);
            jmol.evalString(SymmetryDisplay.printSymmetryGroup(symmResult));
            jmol.evalString(SymmetryDisplay.printSymmetryAxes(symmResult, false));
            jmol.setTitle(SymmetryDisplay.getSymmTitle(symmResult));
            return jmol;
        }
        Logger.info((String)"Showing optimal self-alignment");
        Atom[] cloned = StructureTools.cloneAtomArray((Atom[])symmResult.getAtoms());
        StructureAlignmentJmol jmol = StructureAlignmentDisplay.display(symmResult.getSelfAlignment(), symmResult.getAtoms(), cloned);
        RotationAxis axis = new RotationAxis(symmResult.getSelfAlignment());
        jmol.evalString(axis.getJmolScript(symmResult.getAtoms()));
        jmol.setTitle(SymmetryDisplay.getSymmTitle(symmResult));
        return jmol;
    }

    private static void addSymmetryMenu(MultipleAlignmentJmol jmol, CeSymmResult symmResult) {
        JMenuBar menubar = jmol.getFrame().getJMenuBar();
        JMenu symm = new JMenu("Symmetry");
        symm.setMnemonic(83);
        SymmetryListener li = new SymmetryListener(jmol, symmResult);
        JMenuItem repeats = new JMenuItem("Repeats Superposition");
        repeats.addActionListener(li);
        symm.add(repeats);
        JMenuItem multiple = new JMenuItem("Multiple Structure Alignment");
        multiple.addActionListener(li);
        symm.add(multiple);
        JMenuItem self = new JMenuItem("Optimal Self Alignment");
        self.addActionListener(li);
        symm.add(self);
        JMenuItem pg = new JMenuItem("Show Symmetry Group");
        pg.addActionListener(li);
        symm.add(pg);
        JMenuItem ax = new JMenuItem("Show Symmetry Axes");
        ax.addActionListener(li);
        symm.add(ax);
        JMenuItem news = new JMenuItem("New Symmetry Analysis");
        news.addActionListener(li);
        symm.add(news);
        menubar.add((Component)symm, 3);
        jmol.getFrame().pack();
    }

    public static String printSymmetryAxes(CeSymmResult symm, boolean elementary) {
        int id = 0;
        String script = "";
        Atom[] atoms = symm.getAtoms();
        List symmAxes = null;
        symmAxes = elementary ? symm.getAxes().getElementaryAxes() : symm.getAxes().getSymmetryAxes();
        for (Matrix4d axis : symmAxes) {
            RotationAxis rot = new RotationAxis(axis);
            script = script + rot.getJmolScript(atoms, id);
            ++id;
        }
        return script;
    }

    public static String printSymmetryGroup(CeSymmResult symm) throws StructureException {
        QuatSymmetryResults gSymmetry = SymmetryTools.getQuaternarySymmetry((CeSymmResult)symm);
        AxisAligner axes = AxisAligner.getInstance((QuatSymmetryResults)gSymmetry);
        JmolSymmetryScriptGenerator scriptGenerator = JmolSymmetryScriptGeneratorPointGroup.getInstance(axes, "g");
        String script = "save selection; set measurementUnits ANGSTROMS;select all; set antialiasDisplay true; autobond=false; ";
        script = script + scriptGenerator.getInstantaneousOrientation(0);
        script = script + "restore selection; ";
        script = script + scriptGenerator.drawPolyhedron();
        script = script + scriptGenerator.drawAxes();
        script = script + "draw axes* on; draw poly* on; ";
        return script;
    }

    public static String getSymmTitle(CeSymmResult result) {
        StringBuffer buff = new StringBuffer();
        buff.append(result.getMultipleAlignment().getEnsemble().getAlgorithmName());
        buff.append(" V");
        buff.append(result.getMultipleAlignment().getEnsemble().getVersion());
        buff.append(": ");
        buff.append(result.toString());
        return buff.toString();
    }
}

