/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentJmolDisplay;
import org.biojava.nbio.structure.align.gui.StructureAlignmentDisplay;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.MultipleAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.StructureAlignmentJmol;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.util.RotationAxis;
import org.biojava.nbio.structure.symmetry.core.AxisAligner;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.gui.SymmetryListener;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.biojava.nbio.structure.symmetry.internal.SymmetryAxes;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGenerator;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorPointGroup;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetryDisplay {
    private static final Logger logger = LoggerFactory.getLogger(SymmetryDisplay.class);

    public static MultipleAlignmentJmol displayRepeats(CeSymmResult symm) throws StructureException {
        MultipleAlignment repeats = SymmetryTools.toRepeatsAlignment((CeSymmResult)symm);
        MultipleAlignmentJmol jmol = MultipleAlignmentJmolDisplay.display(repeats);
        jmol.setTitle(SymmetryDisplay.getSymmTitle(symm));
        return jmol;
    }

    public static MultipleAlignmentJmol displayFull(CeSymmResult symm) throws StructureException {
        MultipleAlignment full = SymmetryTools.toFullAlignment((CeSymmResult)symm);
        MultipleAlignmentJmol jmol = MultipleAlignmentJmolDisplay.display(full);
        jmol.setColorByBlocks(true);
        jmol.setTitle(SymmetryDisplay.getSymmTitle(symm));
        return jmol;
    }

    public static AbstractAlignmentJmol display(CeSymmResult symmResult) throws StructureException {
        if (symmResult.isSignificant() && symmResult.isRefined()) {
            MultipleAlignment msa = symmResult.getMultipleAlignment();
            List atoms = msa.getAtomArrays();
            Atom[] allAtoms = (Atom[])atoms.get(0);
            List hetatms = StructureTools.getUnalignedGroups((Atom[])allAtoms);
            allAtoms = Arrays.copyOf(allAtoms, allAtoms.length + hetatms.size());
            for (int h = 0; h < hetatms.size(); ++h) {
                int index = allAtoms.length - hetatms.size() + h;
                allAtoms[index] = ((Group)hetatms.get(h)).getAtom(0);
            }
            for (int s = 0; s < msa.size(); ++s) {
                atoms.set(s, allAtoms);
            }
            MultipleAlignmentJmol jmol = new MultipleAlignmentJmol(msa, atoms);
            jmol.setTitle(jmol.getStructure().getPDBHeader().getTitle());
            SymmetryDisplay.addSymmetryMenu(jmol, symmResult);
            jmol.evalString(SymmetryDisplay.printSymmetryGroup(symmResult));
            jmol.evalString(SymmetryDisplay.printSymmetryAxes(symmResult));
            jmol.setTitle(SymmetryDisplay.getSymmTitle(symmResult));
            return jmol;
        }
        logger.info("Showing optimal self-alignment");
        Atom[] cloned = StructureTools.cloneAtomArray((Atom[])symmResult.getAtoms());
        StructureAlignmentJmol jmol = StructureAlignmentDisplay.display(symmResult.getSelfAlignment(), symmResult.getAtoms(), cloned);
        RotationAxis axis = new RotationAxis(symmResult.getSelfAlignment());
        jmol.evalString(axis.getJmolScript(symmResult.getAtoms()));
        return jmol;
    }

    private static void addSymmetryMenu(MultipleAlignmentJmol jmol, CeSymmResult symmResult) {
        JMenuBar menubar = jmol.getFrame().getJMenuBar();
        JMenu symm = new JMenu("Symmetry");
        symm.setMnemonic(83);
        SymmetryListener li = new SymmetryListener(jmol, symmResult);
        JMenuItem repeats = new JMenuItem("Repeats Superposition");
        repeats.addActionListener(li);
        symm.add(repeats);
        JMenuItem multiple = new JMenuItem("Multiple Structure Alignment");
        multiple.addActionListener(li);
        symm.add(multiple);
        JMenuItem self = new JMenuItem("Optimal Self Alignment");
        self.addActionListener(li);
        symm.add(self);
        JMenuItem pg = new JMenuItem("Show Symmetry Group");
        pg.addActionListener(li);
        symm.add(pg);
        JMenuItem ax = new JMenuItem("Show Symmetry Axes");
        ax.addActionListener(li);
        symm.add(ax);
        JMenuItem news = new JMenuItem("New Symmetry Analysis");
        news.addActionListener(li);
        symm.add(news);
        menubar.add((Component)symm, 3);
        jmol.getFrame().pack();
    }

    public static String printSymmetryAxes(CeSymmResult symm) throws StructureException {
        return SymmetryDisplay.printSymmetryAxes(symm, true);
    }

    public static String printSymmetryAxes(CeSymmResult symm, boolean allAxes) throws StructureException {
        int id = 0;
        String script = "";
        SymmetryAxes axes = symm.getAxes();
        List repeats = SymmetryTools.toRepeatsAlignment((CeSymmResult)symm).getAtomArrays();
        List symmAxes = allAxes ? axes.getSymmetryAxes() : axes.getElementaryAxesObjects();
        for (SymmetryAxes.Axis a : symmAxes) {
            RotationAxis rot = a.getRotationAxis();
            List cyclicForm = axes.getRepeatsCyclicForm(a);
            ArrayList<Object> repAtoms = new ArrayList<Object>();
            for (List cycle : cyclicForm) {
                for (Integer repeat : cycle) {
                    repAtoms.addAll(Arrays.asList((Object[])repeats.get(repeat)));
                }
            }
            script = script + rot.getJmolScript(repAtoms.toArray(new Atom[repAtoms.size()]), id);
            ++id;
        }
        return script;
    }

    public static String printSymmetryGroup(CeSymmResult symm) throws StructureException {
        QuatSymmetryResults gSymmetry = SymmetryTools.getQuaternarySymmetry((CeSymmResult)symm);
        AxisAligner axes = AxisAligner.getInstance((QuatSymmetryResults)gSymmetry);
        JmolSymmetryScriptGenerator scriptGenerator = JmolSymmetryScriptGeneratorPointGroup.getInstance(axes, "g");
        String script = "save selection; set measurementUnits ANGSTROMS;select all; set antialiasDisplay true; autobond=false; ";
        script = script + scriptGenerator.getInstantaneousOrientation(0);
        script = script + "restore selection; ";
        script = script + scriptGenerator.drawPolyhedron();
        script = script + scriptGenerator.drawAxes();
        script = script + "draw axes* on; draw poly* on; ";
        return script;
    }

    public static String getSymmTitle(CeSymmResult result) {
        StringBuffer buff = new StringBuffer();
        buff.append(result.getMultipleAlignment().getEnsemble().getAlgorithmName());
        buff.append(" V");
        buff.append(result.getMultipleAlignment().getEnsemble().getVersion());
        buff.append(": ");
        buff.append(result.toString());
        return buff.toString();
    }
}

