/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;

public class ParameterGUI
extends JFrame {
    private static final long serialVersionUID = 723386061184110161L;
    private ConfigStrucAligParams params;
    private List<Component> textFields;

    public ParameterGUI(ConfigStrucAligParams params, String algorithm) {
        if (params == null) {
            return;
        }
        this.params = params;
        this.setTitle("Parameters for " + algorithm);
        List names = params.getUserConfigParameterNames();
        List keys = params.getUserConfigParameters();
        List types = params.getUserConfigTypes();
        List helps = params.getUserConfigHelp();
        assert (names.size() == keys.size());
        assert (names.size() == types.size());
        assert (names.size() == helps.size());
        this.textFields = new ArrayList<Component>();
        Box vBox = Box.createVerticalBox();
        for (int i = 0; i < keys.size(); ++i) {
            JComponent field;
            JComboBox jcbox;
            Object[] values;
            Class type = (Class)types.get(i);
            Box hBox = Box.createHorizontalBox();
            String name = (String)names.get(i);
            JLabel label = new JLabel(name);
            String help = (String)helps.get(i);
            label.setToolTipText(help);
            String key = (String)keys.get(i);
            Object value = this.getValue(key);
            String data = value.toString();
            if (type.isEnum()) {
                values = type.getEnumConstants();
                jcbox = new JComboBox(values);
                jcbox.setSelectedItem(value);
                field = jcbox;
            } else if (type == Boolean.class) {
                values = new String[]{"true", "false"};
                jcbox = new JComboBox(values);
                if (data.equalsIgnoreCase("false")) {
                    jcbox.setSelectedIndex(1);
                } else {
                    jcbox.setSelectedIndex(0);
                }
                field = jcbox;
            } else {
                JTextField tfield = new JTextField(10);
                if (type == String[].class) {
                    String stuff = "";
                    for (String da : (String[])value) {
                        stuff = stuff + da + " ";
                    }
                    data = stuff;
                }
                tfield.setText(data);
                tfield.setToolTipText(help);
                field = tfield;
            }
            hBox.add(label);
            hBox.add(Box.createGlue());
            hBox.add(field);
            vBox.add(hBox);
            this.textFields.add(field);
        }
        JButton abort = new JButton("Cancel");
        abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ParameterGUI.this.destroy();
                ParameterGUI.this.dispose();
            }
        });
        JButton defaultB = new JButton("Default");
        defaultB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ParameterGUI.this.setDefault();
            }
        });
        JButton close = new JButton("Apply");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ParameterGUI.this.storeParameters();
                ParameterGUI.this.destroy();
                ParameterGUI.this.dispose();
            }
        });
        Box hBox = Box.createHorizontalBox();
        hBox.add(abort);
        hBox.add(Box.createGlue());
        hBox.add(defaultB);
        hBox.add(Box.createGlue());
        hBox.add(close);
        vBox.add(hBox);
        this.getContentPane().add(vBox);
        this.pack();
        this.setVisible(true);
    }

    protected void setDefault() {
        this.params.reset();
        List keys = this.params.getUserConfigParameters();
        List types = this.params.getUserConfigTypes();
        for (int i = 0; i < keys.size(); ++i) {
            JComponent field;
            Class type = (Class)types.get(i);
            Object data = this.getValue((String)keys.get(i));
            if (type.isEnum()) {
                field = (JComboBox)this.textFields.get(i);
                ((JComboBox)field).setSelectedItem(data);
                ((JComboBox)field).updateUI();
                continue;
            }
            if (type == Boolean.class) {
                field = (JComboBox)this.textFields.get(i);
                if (data.toString().equalsIgnoreCase("false")) {
                    ((JComboBox)field).setSelectedIndex(1);
                } else {
                    ((JComboBox)field).setSelectedIndex(0);
                }
                ((JComboBox)field).updateUI();
                continue;
            }
            field = (JTextField)this.textFields.get(i);
            if (type.isArray()) {
                String stuff = "";
                for (String da : (String[])data) {
                    stuff = stuff + da + " ";
                }
                ((JTextComponent)field).setText(stuff);
            } else {
                ((JTextComponent)field).setText(data.toString());
            }
            ((JTextComponent)field).updateUI();
        }
        this.repaint();
    }

    private void destroy() {
        this.textFields = null;
        this.params = null;
    }

    protected void storeParameters() {
        List keys = this.params.getUserConfigParameters();
        List types = this.params.getUserConfigTypes();
        for (int i = 0; i < keys.size(); ++i) {
            JComponent field;
            Class type = (Class)types.get(i);
            String key = (String)keys.get(i);
            String value = null;
            System.out.println(key);
            if (type.isEnum()) {
                field = (JComboBox)this.textFields.get(i);
                Enum sel = (Enum)((JComboBox)field).getSelectedItem();
                value = sel.name();
            } else if (type == Boolean.class) {
                field = (JComboBox)this.textFields.get(i);
                int sel = ((JComboBox)field).getSelectedIndex();
                Boolean flag = true;
                if (sel == 1) {
                    flag = false;
                }
                value = flag.toString();
            } else {
                field = (JTextField)this.textFields.get(i);
                value = ((JTextComponent)field).getText();
            }
            this.setValue(key, type, value);
        }
        System.out.println("new parameters: " + this.params.toString());
    }

    private void setValue(String name, Class type, String value) {
        try {
            String methodName = "set" + name;
            Class<?> paramC = this.params.getClass();
            Method m = paramC.getMethod(methodName, type);
            Object data = null;
            if (type == Integer.class) {
                data = Integer.parseInt(value);
            } else if (type == Double.class) {
                data = Double.parseDouble(value);
            } else if (type == Float.class) {
                data = Float.valueOf(Float.parseFloat(value));
            } else if (type == Boolean.class) {
                data = Boolean.parseBoolean(value);
            } else if (type == Short.class) {
                data = Short.parseShort(value);
            } else if (type == String[].class) {
                data = value.split(" ");
            } else if (type.isEnum()) {
                data = Enum.valueOf(type, value);
            }
            if (data == null) {
                System.err.println("Could not set value " + value + " for field " + name);
                return;
            }
            m.invoke((Object)this.params, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object getValue(String name) {
        try {
            Method m;
            String methodName = "get" + name;
            Class<?> paramC = this.params.getClass();
            try {
                m = paramC.getMethod(methodName, null);
            }
            catch (NoSuchMethodException e) {
                methodName = "is" + name;
                m = paramC.getMethod(methodName, null);
            }
            Object value = m.invoke((Object)this.params, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

