/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.jmol;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.align.gui.jmol.AtomInfo;
import org.biojava.nbio.structure.align.gui.jmol.AtomInfoParser;
import org.biojava.nbio.structure.align.gui.jmol.JmolPanel;
import org.biojava.nbio.structure.align.util.ResourceManager;
import org.biojava.nbio.structure.jama.Matrix;
import org.jcolorbrewer.ColorBrewer;
import org.jmol.api.JmolViewer;
import org.jmol.viewer.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAlignmentJmol
implements MouseMotionListener,
MouseListener,
WindowListener,
ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAlignmentJmol.class);
    protected Structure structure;
    protected ColorBrewer colorPalette = ColorBrewer.Spectral;
    protected JmolPanel jmolPanel;
    protected JFrame frame;
    protected JTextField text;
    protected JTextField status;
    protected static final String COMMAND_LINE_HELP = "enter Jmol scripting command...";
    protected static final int DEFAULT_HEIGHT = 500;
    protected static final int DEFAULT_WIDTH = 500;
    protected static final String DEFAULT_SCRIPT = ResourceManager.getResourceManager((String)"ce").getString("default.alignment.jmol.script");
    protected static int nrOpenWindows = 0;

    protected abstract void initCoords();

    public void destroy() {
        logger.debug("cleaning up AlignmentJmol window");
        this.jmolPanel.removeMouseListener(this);
        this.jmolPanel.removeMouseMotionListener(this);
        this.jmolPanel.destroy();
    }

    public abstract void resetDisplay();

    public void setAtoms(Atom[] atoms) {
        StructureImpl s = new StructureImpl();
        ChainImpl c = new ChainImpl();
        c.setChainID("A");
        for (Atom a : atoms) {
            c.addGroup(a.getGroup());
        }
        s.addChain((Chain)c);
        this.setStructure((Structure)s);
    }

    public ColorBrewer getColorPalette() {
        return this.colorPalette;
    }

    public JmolPanel getJmolPanel() {
        return this.jmolPanel;
    }

    public void setJmolPanel(JmolPanel jmolPanel) {
        this.jmolPanel = jmolPanel;
    }

    public void evalString(String rasmolScript) {
        if (this.jmolPanel == null) {
            logger.error("please install Jmol first");
            return;
        }
        this.jmolPanel.evalString(rasmolScript);
    }

    public void setStructure(Structure s) {
        if (this.jmolPanel == null) {
            logger.error("please install Jmol first");
            return;
        }
        this.setTitle(s.getPDBCode());
        this.jmolPanel.setStructure(s);
        this.structure = s;
    }

    public Structure getStructure() {
        return this.structure;
    }

    public abstract List<Matrix> getDistanceMatrices();

    public void setTitle(String title) {
        this.frame.setTitle(title);
        this.frame.repaint();
    }

    public String getTitle() {
        return this.frame.getTitle();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JmolViewer viewer = this.jmolPanel.getViewer();
        int pos = viewer.findNearestAtomIndex(e.getX(), e.getY());
        if (pos == -1) {
            return;
        }
        String atomInfo = ((Viewer)viewer).getAtomInfo(pos);
        this.text.setText(atomInfo);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JmolViewer viewer = this.jmolPanel.getViewer();
        int pos = viewer.findNearestAtomIndex(e.getX(), e.getY());
        if (pos == -1) {
            return;
        }
        String atomInfo = ((Viewer)viewer).getAtomInfo(pos);
        this.status.setText("clicked: " + atomInfo);
        AtomInfo ai = AtomInfoParser.parse(atomInfo);
        String cmd = "select " + ai.getResidueNumber() + ":" + ai.getChainId() + "/" + ai.getModelNumber() + "; set display selected;";
        this.evalString(cmd);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.destroy();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);
}

