/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.jmolScript;

import org.biojava.nbio.structure.symmetry.core.RotationAxisAligner;
import org.biojava.nbio.structure.symmetry.geometry.Polyhedron;
import org.biojava.nbio.structure.symmetry.geometry.Prism;
import org.biojava.nbio.structure.symmetry.jmolScript.JmolSymmetryScriptGeneratorPointGroup;

public class JmolSymmetryScriptGeneratorDn
extends JmolSymmetryScriptGeneratorPointGroup {
    public JmolSymmetryScriptGeneratorDn(RotationAxisAligner axisTransformation, String name) {
        super(axisTransformation, name);
        int fold = axisTransformation.getRotationGroup().getRotation(0).getFold();
        if (axisTransformation.getRotationGroup().getPointGroup().equals("D2")) {
            fold = 4;
        }
        Prism p = new Prism(fold);
        p.setHeight(axisTransformation.getDimension().z * 2.0);
        p.setInscribedRadius(axisTransformation.getRadius());
        this.setPolyhedron((Polyhedron)p);
    }

    @Override
    public int getZoom() {
        double polyhedronExtension;
        double maxExtension = this.getMaxExtension();
        int zoom = Math.round((float)(maxExtension / (polyhedronExtension = Math.max(this.getPolyhedron().getCirumscribedRadius(), this.getAxisTransformation().getDimension().z)) * 110.0));
        if (zoom > 100) {
            zoom = 100;
        }
        return zoom;
    }

    @Override
    public int getOrientationCount() {
        return this.getPolyhedron().getViewCount() - 1;
    }

    @Override
    public String getOrientationName(int index) {
        if (index == 0 && this.getAxisTransformation().getRotationGroup().getPointGroup().equals("D2")) {
            return "Front C2 axis";
        }
        return this.getPolyhedron().getViewName(index);
    }
}

