/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.MultipleStructureAligner;
import org.biojava.nbio.structure.align.gui.AlignmentCalculationRunnable;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentGUI;
import org.biojava.nbio.structure.align.gui.MultipleAlignmentJmolDisplay;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleAlignmentCalc
implements AlignmentCalculationRunnable {
    private static final Logger logger = LoggerFactory.getLogger(MultipleAlignmentCalc.class);
    private List<StructureIdentifier> names;
    private List<Structure> structures;
    private MultipleAlignmentGUI parent;

    public MultipleAlignmentCalc(MultipleAlignmentGUI parent, List<Structure> structures, List<StructureIdentifier> names) {
        this.parent = parent;
        this.structures = structures;
        this.names = names;
    }

    @Override
    public void run() {
        MultipleStructureAligner algorithm = this.parent.getMultipleStructureAligner();
        try {
            ArrayList<Atom[]> atomArrays = new ArrayList<Atom[]>();
            for (Structure s : this.structures) {
                Atom[] ca = StructureTools.getRepresentativeAtomArray((Structure)s);
                atomArrays.add(ca);
            }
            MultipleAlignment msa = algorithm.align(atomArrays);
            msa.getEnsemble().setStructureIdentifiers(this.names);
            MultipleAlignmentJmolDisplay.display(msa);
        }
        catch (StructureException e) {
            e.printStackTrace();
            logger.warn(e.getMessage());
        }
        this.parent.notifyCalcFinished();
    }

    @Override
    public void interrupt() {
    }

    @Override
    public void cleanup() {
        this.parent.notifyCalcFinished();
        this.parent = null;
        this.structures = null;
        this.names = null;
    }

    @Override
    public void setNrCPUs(int useNrCPUs) {
    }
}

