/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui.jmol;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.gui.AlignmentGui;
import org.biojava.nbio.structure.align.gui.DisplayAFP;
import org.biojava.nbio.structure.align.gui.MenuCreator;
import org.biojava.nbio.structure.align.gui.jmol.AbstractAlignmentJmol;
import org.biojava.nbio.structure.align.gui.jmol.JmolPanel;
import org.biojava.nbio.structure.align.gui.jmol.JmolTools;
import org.biojava.nbio.structure.align.gui.jmol.MyJmolStatusListener;
import org.biojava.nbio.structure.align.gui.jmol.RasmolCommandListener;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.model.AfpChainWriter;
import org.biojava.nbio.structure.align.util.AlignmentTools;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.ResourceManager;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.align.webstart.AligUIManager;
import org.biojava.nbio.structure.gui.util.color.ColorUtils;
import org.biojava.nbio.structure.jama.Matrix;

public class StructureAlignmentJmol
extends AbstractAlignmentJmol
implements ChangeListener {
    private Atom[] ca1;
    private Atom[] ca2;
    private AFPChain afpChain;
    private static final String LIGAND_DISPLAY_SCRIPT = ResourceManager.getResourceManager((String)"ce").getString("default.ligand.jmol.script");

    public static void main(String[] args) {
        try {
            UserConfiguration config = new UserConfiguration();
            AtomCache cache = new AtomCache(config);
            Structure struc = cache.getStructure("5pti");
            StructureAlignmentJmol jmolPanel = new StructureAlignmentJmol(null, null, null);
            jmolPanel.setStructure(struc);
            jmolPanel.evalString("select * ; color chain;");
            jmolPanel.evalString("select *; spacefill off; wireframe off; backbone 0.4;  ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StructureAlignmentJmol() {
        this(null, null, null);
    }

    public StructureAlignmentJmol(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        AligUIManager.setLookAndFeel();
        ++nrOpenWindows;
        this.jmolPanel = new JmolPanel();
        this.frame = new JFrame();
        JMenuBar menu = MenuCreator.initJmolMenu(this.frame, this, afpChain, null);
        this.frame.setJMenuBar(menu);
        this.afpChain = afpChain;
        this.ca1 = ca1;
        this.ca2 = ca2;
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StructureAlignmentJmol.this.destroy();
                if (--AbstractAlignmentJmol.nrOpenWindows > 0) {
                    StructureAlignmentJmol.this.frame.dispose();
                } else {
                    AlignmentGui gui = AlignmentGui.getInstanceNoVisibilityChange();
                    if (gui.isVisible()) {
                        StructureAlignmentJmol.this.frame.dispose();
                        gui.requestFocus();
                    } else {
                        System.exit(0);
                    }
                }
            }
        });
        Container contentPane = this.frame.getContentPane();
        Box vBox = Box.createVerticalBox();
        this.jmolPanel.addMouseMotionListener(this);
        this.jmolPanel.addMouseListener(this);
        this.jmolPanel.setPreferredSize(new Dimension(500, 500));
        vBox.add(this.jmolPanel);
        JTextField field = new JTextField();
        field.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        field.setText("enter Jmol scripting command...");
        RasmolCommandListener listener = new RasmolCommandListener(this.jmolPanel, field);
        field.addActionListener(listener);
        field.addMouseListener(listener);
        field.addKeyListener(listener);
        vBox.add(field);
        Box hBox1 = Box.createHorizontalBox();
        hBox1.add(Box.createGlue());
        String[] styles = new String[]{"Cartoon", "Backbone", "CPK", "Ball and Stick", "Ligands", "Ligands and Pocket"};
        JComboBox<String> style = new JComboBox<String>(styles);
        hBox1.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        hBox1.add(new JLabel("Style"));
        hBox1.add(style);
        vBox.add(hBox1);
        contentPane.add(vBox);
        style.addActionListener(this.jmolPanel);
        String[] colorModes = new String[]{"Secondary Structure", "By Chain", "Rainbow", "By Element", "By Amino Acid", "Hydrophobicity", "Suggest Domains", "Show SCOP Domains"};
        JComboBox<String> colors = new JComboBox<String>(colorModes);
        colors.addActionListener(this.jmolPanel);
        hBox1.add(Box.createGlue());
        hBox1.add(new JLabel("Color"));
        hBox1.add(colors);
        Box hBox2 = Box.createHorizontalBox();
        hBox2.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        JButton resetDisplay = new JButton("Reset Display");
        resetDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("reset!!");
                StructureAlignmentJmol.this.jmolPanel.executeCmd("restore STATE state_1");
            }
        });
        hBox2.add(resetDisplay);
        hBox2.add(Box.createGlue());
        JCheckBox toggleSelection = new JCheckBox("Show Selection");
        toggleSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean showSelection;
                boolean bl = showSelection = e.getStateChange() == 1;
                if (showSelection) {
                    StructureAlignmentJmol.this.jmolPanel.executeCmd("set display selected");
                } else {
                    StructureAlignmentJmol.this.jmolPanel.executeCmd("set display off");
                }
            }
        });
        hBox2.add(toggleSelection);
        hBox2.add(Box.createGlue());
        vBox.add(hBox2);
        Box hBox3 = Box.createHorizontalBox();
        hBox3.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        JLabel sliderLabel = new JLabel("Zoom");
        hBox3.add(Box.createGlue());
        hBox3.add(sliderLabel);
        JSlider zoomSlider = new JSlider(0, 0, 500, 100);
        zoomSlider.addChangeListener(this);
        zoomSlider.setMajorTickSpacing(100);
        zoomSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0%"));
        labelTable.put(new Integer(100), new JLabel("100%"));
        labelTable.put(new Integer(200), new JLabel("200%"));
        labelTable.put(new Integer(300), new JLabel("300%"));
        labelTable.put(new Integer(400), new JLabel("400%"));
        labelTable.put(new Integer(500), new JLabel("500%"));
        zoomSlider.setLabelTable(labelTable);
        zoomSlider.setPaintLabels(true);
        hBox3.add(zoomSlider);
        hBox3.add(Box.createGlue());
        JCheckBox toggleSpin = new JCheckBox("Spin");
        toggleSpin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean spinOn;
                boolean bl = spinOn = e.getStateChange() == 1;
                if (spinOn) {
                    StructureAlignmentJmol.this.jmolPanel.executeCmd("spin ON");
                } else {
                    StructureAlignmentJmol.this.jmolPanel.executeCmd("spin OFF");
                }
            }
        });
        hBox3.add(toggleSpin);
        hBox3.add(Box.createGlue());
        vBox.add(hBox3);
        Box hBox = Box.createHorizontalBox();
        this.status = new JTextField();
        this.status.setBackground(Color.white);
        this.status.setEditable(false);
        this.status.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.status.setPreferredSize(new Dimension(250, 30));
        this.status.setMinimumSize(new Dimension(250, 30));
        hBox.add(this.status);
        this.text = new JTextField();
        this.text.setBackground(Color.white);
        this.text.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.text.setPreferredSize(new Dimension(250, 30));
        this.text.setMinimumSize(new Dimension(250, 30));
        this.text.setText("Display of Atom info");
        this.text.setEditable(false);
        hBox.add(this.text);
        vBox.add(hBox);
        contentPane.add(vBox);
        MyJmolStatusListener li = (MyJmolStatusListener)this.jmolPanel.getStatusListener();
        li.setTextField(this.status);
        this.frame.pack();
        this.frame.setVisible(true);
        this.initCoords();
        this.resetDisplay();
    }

    @Override
    protected void initCoords() {
        try {
            if (this.ca1 == null || this.ca2 == null) {
                if (this.structure != null) {
                    this.setStructure(this.structure);
                } else {
                    return;
                }
            }
            Structure artificial = AlignmentTools.getAlignedStructure((Atom[])this.ca1, (Atom[])this.ca2);
            PDBHeader header = new PDBHeader();
            String title = this.afpChain.getAlgorithmName() + " V." + this.afpChain.getVersion() + " : " + this.afpChain.getName1() + " vs. " + this.afpChain.getName2();
            header.setTitle(title);
            artificial.setPDBHeader(header);
            this.setStructure(artificial);
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.afpChain = null;
        this.ca1 = null;
        this.ca2 = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("View Text Only")) {
            if (this.afpChain == null) {
                System.err.println("Currently not viewing an alignment!");
                return;
            }
            AFPChain textAFP = (AFPChain)this.afpChain.clone();
            String result = AfpChainWriter.toWebSiteDisplay((AFPChain)textAFP, (Atom[])this.ca1, (Atom[])this.ca2);
            DisplayAFP.showAlignmentImage(this.afpChain, result);
        } else if (cmd.equals("View Aligned Pairs")) {
            if (this.afpChain == null) {
                System.err.println("Currently not viewing an alignment!");
                return;
            }
            String result = AfpChainWriter.toAlignedPairs((AFPChain)this.afpChain, (Atom[])this.ca1, (Atom[])this.ca2);
            DisplayAFP.showAlignmentImage(this.afpChain, result);
        } else if (cmd.equals("Alignment Panel")) {
            if (this.afpChain == null) {
                System.err.println("Currently not viewing an alignment!");
                return;
            }
            try {
                DisplayAFP.showAlignmentPanel(this.afpChain, this.ca1, this.ca2, this);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return;
            }
        } else if (cmd.equals("View as FATCAT result")) {
            if (this.afpChain == null) {
                System.err.println("Currently not viewing an alignment!");
                return;
            }
            Object result = this.afpChain.toFatcat(this.ca1, this.ca2);
            result = (String)result + AFPChain.newline;
            result = (String)result + this.afpChain.toRotMat();
            DisplayAFP.showAlignmentImage(this.afpChain, (String)result);
        }
    }

    public static String getJmolString(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        if (afpChain.getBlockNum() > 1) {
            return StructureAlignmentJmol.getMultiBlockJmolScript(afpChain, ca1, ca2);
        }
        StringBuffer j = new StringBuffer();
        j.append(DEFAULT_SCRIPT);
        StringBuffer sel = new StringBuffer();
        List<String> pdb1 = DisplayAFP.getPDBresnum(0, afpChain, ca1);
        sel.append("select ");
        int pos = 0;
        for (String string : pdb1) {
            if (pos > 0) {
                sel.append(",");
            }
            ++pos;
            sel.append(string);
            sel.append("/1");
        }
        if (pos == 0) {
            sel.append("none");
        }
        sel.append(";");
        sel.append("backbone 0.6 ;   color orange;");
        sel.append("select */2; color lightgrey; model 2; ");
        List<String> pdb2 = DisplayAFP.getPDBresnum(1, afpChain, ca2);
        sel.append("select ");
        pos = 0;
        for (String res : pdb2) {
            if (pos > 0) {
                sel.append(",");
            }
            ++pos;
            sel.append(res);
            sel.append("/2");
        }
        if (pos == 0) {
            sel.append("none");
        }
        sel.append("; backbone 0.6 ;   color cyan;");
        j.append(sel);
        j.append("model 0;  ");
        j.append(LIGAND_DISPLAY_SCRIPT);
        StringBuffer stringBuffer = new StringBuffer("select ");
        int count = 0;
        for (String res : pdb1) {
            if (count > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(res);
            stringBuffer.append("/1");
            ++count;
        }
        for (String res : pdb2) {
            stringBuffer.append(",");
            stringBuffer.append(res);
            stringBuffer.append("/2");
        }
        j.append(stringBuffer);
        return j.toString();
    }

    public static String getJmolScript4Block(AFPChain afpChain, Atom[] ca1, Atom[] ca2, int blockNr) {
        int blockNum = afpChain.getBlockNum();
        if (blockNr >= blockNum) {
            return DEFAULT_SCRIPT;
        }
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        if (optLen == null) {
            return DEFAULT_SCRIPT;
        }
        StringWriter jmol = new StringWriter();
        jmol.append(DEFAULT_SCRIPT);
        jmol.append("select */2; color lightgrey; model 2; ");
        StructureAlignmentJmol.printJmolScript4Block(ca1, ca2, blockNum, optLen, optAln, jmol, blockNr);
        jmol.append("model 0;  ");
        jmol.append(LIGAND_DISPLAY_SCRIPT);
        return jmol.toString();
    }

    private static String getMultiBlockJmolScript(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        int blockNum = afpChain.getBlockNum();
        int[] optLen = afpChain.getOptLen();
        int[][][] optAln = afpChain.getOptAln();
        if (optLen == null) {
            return DEFAULT_SCRIPT;
        }
        StringWriter jmol = new StringWriter();
        jmol.append(DEFAULT_SCRIPT);
        jmol.append("select */2; color lightgrey; model 2; ");
        for (int bk = 0; bk < blockNum; ++bk) {
            StructureAlignmentJmol.printJmolScript4Block(ca1, ca2, blockNum, optLen, optAln, jmol, bk);
        }
        jmol.append("model 0;  ");
        jmol.append(LIGAND_DISPLAY_SCRIPT);
        return jmol.toString();
    }

    private static void printJmolScript4Block(Atom[] ca1, Atom[] ca2, int blockNum, int[] optLen, int[][][] optAln, StringWriter jmol, int bk) {
        int colorPos = bk;
        if (colorPos > ColorUtils.colorWheel.length) {
            colorPos = ColorUtils.colorWheel.length % colorPos;
        }
        Color end1 = ColorUtils.rotateHue(ColorUtils.orange, 0.041666668f * (float)blockNum);
        Color end2 = ColorUtils.rotateHue(ColorUtils.cyan, 0.041666668f * (float)(blockNum + 1));
        Color c1 = ColorUtils.getIntermediate(ColorUtils.orange, end1, blockNum, bk);
        Color c2 = ColorUtils.getIntermediate(ColorUtils.cyan, end2, blockNum, bk);
        ArrayList<String> pdb1 = new ArrayList<String>();
        ArrayList<String> pdb2 = new ArrayList<String>();
        for (int i = 0; i < optLen[bk]; ++i) {
            int pos1 = optAln[bk][0][i];
            pdb1.add(JmolTools.getPdbInfo(ca1[pos1]));
            int pos2 = optAln[bk][1][i];
            pdb2.add(JmolTools.getPdbInfo(ca2[pos2]));
        }
        StringBuffer buf = new StringBuffer("select ");
        int count = 0;
        for (String res : pdb1) {
            if (count > 0) {
                buf.append(",");
            }
            buf.append(res);
            buf.append("/1");
            ++count;
        }
        buf.append("; backbone 0.6 ; color [" + c1.getRed() + "," + c1.getGreen() + "," + c1.getBlue() + "]; select ");
        count = 0;
        for (String res : pdb2) {
            if (count > 0) {
                buf.append(",");
            }
            buf.append(res);
            buf.append("/2");
            ++count;
        }
        buf.append("; backbone 0.6 ; color [" + c2.getRed() + "," + c2.getGreen() + "," + c2.getBlue() + "];");
        jmol.append(buf);
    }

    @Override
    public void resetDisplay() {
        if (this.afpChain != null && this.ca1 != null && this.ca2 != null) {
            String script = StructureAlignmentJmol.getJmolString(this.afpChain, this.ca1, this.ca2);
            this.evalString(script);
            this.jmolPanel.evalString("save STATE state_1");
        }
    }

    @Override
    public List<Matrix> getDistanceMatrices() {
        if (this.afpChain == null) {
            return null;
        }
        return Arrays.asList(this.afpChain.getDisTable1(), this.afpChain.getDisTable2());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            int zoomValue = source.getValue();
            this.jmolPanel.executeCmd("zoom " + zoomValue);
        }
    }
}

