/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui.util.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import org.biojava.nbio.structure.gui.util.color.ColorInterpolator;

public class LinearColorInterpolator
implements ColorInterpolator {
    private ColorSpace colorSpace;
    private InterpolationDirection[] interpolationDirection;

    public LinearColorInterpolator() {
        this(ColorSpace.getInstance(1000));
    }

    public LinearColorInterpolator(ColorSpace colorSpace) {
        this.setColorSpace(colorSpace);
    }

    @Override
    public Color interpolate(Color a, Color b, float mixing) {
        float[] compA = a.getColorSpace().equals(this.colorSpace) ? a.getComponents(null) : a.getComponents(this.colorSpace, null);
        float[] compB = b.getColorSpace().equals(this.colorSpace) ? b.getComponents(null) : b.getComponents(this.colorSpace, null);
        float[] compMixed = new float[compA.length];
        for (int i = 0; i < compA.length; ++i) {
            float right;
            float left = compA[i];
            InterpolationDirection dir = i < this.interpolationDirection.length ? this.interpolationDirection[i] : InterpolationDirection.INNER;
            switch (dir.ordinal()) {
                case 0: {
                    right = compB[i];
                    break;
                }
                case 1: {
                    if (compA[i] < compB[i]) {
                        right = compB[i] - 1.0f;
                        break;
                    }
                    right = compB[i] + 1.0f;
                    break;
                }
                case 2: {
                    if (compA[i] < compB[i]) {
                        right = compB[i];
                        break;
                    }
                    right = compB[i] + 1.0f;
                    break;
                }
                case 3: {
                    if (compA[i] < compB[i]) {
                        right = compB[i] - 1.0f;
                        break;
                    }
                    right = compB[i];
                    break;
                }
                default: {
                    throw new IllegalStateException("Unkown interpolation Direction " + String.valueOf((Object)this.interpolationDirection[i]));
                }
            }
            compMixed[i] = mixing * left + (1.0f - mixing) * right;
            if (dir == InterpolationDirection.INNER) continue;
            if (compMixed[i] < 0.0f) {
                int n = i;
                compMixed[n] = compMixed[n] + 1.0f;
            }
            if (!(compMixed[i] > 1.0f)) continue;
            int n = i;
            compMixed[n] = compMixed[n] - 1.0f;
        }
        return new Color(this.colorSpace, compMixed, compMixed[compMixed.length - 1]);
    }

    public void setColorSpace(ColorSpace colorSpace, InterpolationDirection[] dir) {
        if (dir.length < colorSpace.getNumComponents()) {
            throw new IllegalArgumentException("Must specify an interpolation direction for each colorspace component (" + colorSpace.getNumComponents() + ")");
        }
        this.colorSpace = colorSpace;
        this.interpolationDirection = dir;
    }

    public void setColorSpace(ColorSpace colorSpace) {
        InterpolationDirection[] dir = new InterpolationDirection[colorSpace.getNumComponents()];
        for (int i = 0; i < dir.length; ++i) {
            dir[i] = InterpolationDirection.INNER;
        }
        this.setColorSpace(colorSpace, dir);
    }

    public void setInterpolationDirection(int componentIndex, InterpolationDirection dir) {
        this.interpolationDirection[componentIndex] = dir;
    }

    public static enum InterpolationDirection {
        INNER,
        OUTER,
        UPPER,
        LOWER;

    }
}

