/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.webstart;

import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigXMLHandler
extends DefaultHandler {
    UserConfiguration config = new UserConfiguration();

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if ("PDBFILEPATH".equals(qName)) {
            String autoFetch;
            String path = atts.getValue("path");
            if (path != null) {
                this.config.setPdbFilePath(path);
            }
            if ((autoFetch = atts.getValue("autoFetch")) == null || !"false".equals(autoFetch)) {
                this.config.setFetchBehavior(LocalPDBDirectory.FetchBehavior.DEFAULT);
            } else {
                this.config.setFetchBehavior(LocalPDBDirectory.FetchBehavior.LOCAL_ONLY);
            }
            String fetchBehavior = atts.getValue("fetchBehavior");
            if (fetchBehavior == null) {
                this.config.setFetchBehavior(LocalPDBDirectory.FetchBehavior.DEFAULT);
            } else {
                this.config.setFetchBehavior(LocalPDBDirectory.FetchBehavior.valueOf((String)fetchBehavior));
            }
            String obsoleteBehavior = atts.getValue("obsoleteBehavior");
            if (obsoleteBehavior == null) {
                this.config.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.DEFAULT);
            } else {
                this.config.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.valueOf((String)obsoleteBehavior));
            }
            String fileFormat = atts.getValue("fileFormat");
            this.config.setFileFormat("PDB");
            if (fileFormat != null && fileFormat.equals("mmCif")) {
                this.config.setFileFormat("mmCif");
            }
        }
    }

    public UserConfiguration getConfig() {
        return this.config;
    }
}

