/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.ce.CeMain;
import org.biojava.nbio.structure.align.ce.CeParameters;
import org.biojava.nbio.structure.align.helper.JointFragments;
import org.biojava.nbio.structure.align.model.AFP;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.gui.ScaleableMatrixPanel;
import org.biojava.nbio.structure.jama.Matrix;

public class DotPlotPanel
extends ScaleableMatrixPanel {
    private static final long serialVersionUID = -7641953255857483895L;

    public DotPlotPanel(AFPChain alignment) {
        double defaultBackground = 100.0;
        AlternativeAlignment[] aligns = new AlternativeAlignment[alignment.getBlockNum()];
        int[][][] optAln = alignment.getOptAln();
        for (int alignNumber = 0; alignNumber < optAln.length; ++alignNumber) {
            ArrayList<int[]> alignPairs = new ArrayList<int[]>();
            for (int pos = 0; pos < optAln[alignNumber][0].length; ++pos) {
                alignPairs.add(new int[]{optAln[alignNumber][0][pos], optAln[alignNumber][1][pos]});
            }
            JointFragments frag = new JointFragments();
            frag.setIdxlist(alignPairs);
            aligns[alignNumber] = new AlternativeAlignment();
            aligns[alignNumber].apairs_from_idxlst(frag);
        }
        this.setAlternativeAligs(aligns);
        this.setSelectedAlignmentPos(0);
        Matrix background = alignment.getDistanceMatrix();
        if (background == null) {
            background = new Matrix(alignment.getCa1Length(), alignment.getCa2Length());
            for (int i = 0; i < background.getRowDimension(); ++i) {
                for (int j = 0; j < background.getColumnDimension(); ++j) {
                    background.set(i, j, 100.0);
                }
            }
        }
        this.setMatrix(background);
    }

    private static JFrame showDotPlotJFrame(AFPChain afpChain) {
        DotPlotPanel dotplot = new DotPlotPanel(afpChain);
        String title = String.format("Dot plot of %s vs. %s", afpChain.getName1(), afpChain.getName2());
        JFrame frame = new JFrame(title);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JFrame f = (JFrame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
        frame.getContentPane().add(dotplot);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public static void main(String[] args) {
        String name1 = "1iu9.A";
        String name2 = "1h0r.A";
        AtomCache cache = new AtomCache();
        try {
            CeMain ceA = (CeMain)StructureAlignmentFactory.getAlgorithm((String)"jCE");
            CeParameters params = (CeParameters)ceA.getParameters();
            params.setMaxGapSize(Integer.valueOf(0));
            Atom[] ca1 = cache.getAtoms(name1);
            Atom[] ca2 = cache.getAtoms(name2);
            AFPChain afpChain = ceA.align(ca1, ca2);
            afpChain.setName1(name1);
            afpChain.setName2(name2);
            for (AFP afpI : afpChain.getAfpSet()) {
                System.out.println(afpI);
            }
            DotPlotPanel.showDotPlotJFrame(afpChain);
            ceA = (CeMain)StructureAlignmentFactory.getAlgorithm((String)"jCE Circular Permutation");
            System.out.format("Aligning %s[%d] with %s[%d] with CPs\n", name1, ca1.length, name2, ca2.length);
            afpChain = ceA.align(ca1, ca2);
            afpChain.setName1(name1);
            afpChain.setName2(name2 + "-" + name2);
            for (AFP afpI : afpChain.getAfpSet()) {
                System.out.println(afpI);
            }
            DotPlotPanel.showDotPlotJFrame(afpChain);
        }
        catch (StructureException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

