/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.align.multiple.AbstractScoresCache;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentTools;

public class BlockImpl
extends AbstractScoresCache
implements Serializable,
Block,
Cloneable {
    private static final long serialVersionUID = -5804042669466177641L;
    private BlockSet parent;
    private List<List<Integer>> alignRes;
    private int coreLength;

    public BlockImpl(BlockSet blockSet) {
        this.parent = blockSet;
        if (this.parent != null) {
            this.parent.getBlocks().add(this);
        }
        this.alignRes = null;
        this.coreLength = -1;
    }

    public BlockImpl(BlockImpl b) {
        super(b);
        this.parent = b.parent;
        this.coreLength = b.coreLength;
        this.alignRes = null;
        if (b.alignRes != null) {
            this.alignRes = new ArrayList<List<Integer>>();
            for (int k = 0; k < b.size(); ++k) {
                this.alignRes.add(new ArrayList(b.alignRes.get(k)));
            }
        }
    }

    @Override
    public Block clone() {
        return new BlockImpl(this);
    }

    @Override
    public void clear() {
        super.clear();
        this.coreLength = -1;
    }

    public String toString() {
        return "BlockImpl [alignRes=" + this.alignRes + ", coreLength=" + this.coreLength + "]";
    }

    @Override
    public void setBlockSet(BlockSet parent) {
        this.parent = parent;
    }

    @Override
    public BlockSet getBlockSet() {
        return this.parent;
    }

    @Override
    public List<List<Integer>> getAlignRes() {
        return this.alignRes;
    }

    @Override
    public void setAlignRes(List<List<Integer>> alignRes) {
        this.alignRes = alignRes;
    }

    @Override
    public int length() {
        if (this.alignRes == null) {
            return 0;
        }
        if (this.alignRes.size() == 0) {
            return 0;
        }
        return this.alignRes.get(0).size();
    }

    @Override
    public int size() {
        return this.alignRes.size();
    }

    @Override
    public int getCoreLength() {
        if (this.coreLength == -1) {
            this.updateCoreLength();
        }
        return this.coreLength;
    }

    protected void updateCoreLength() {
        this.coreLength = MultipleAlignmentTools.getCorePositions(this).size();
    }

    @Override
    public int getStartIndex(int str) {
        int index = -1;
        Integer start = null;
        while (start == null && index < this.alignRes.get(str).size()) {
            start = this.alignRes.get(str).get(++index);
        }
        return index;
    }

    @Override
    public int getStartResidue(int str) {
        return this.alignRes.get(str).get(this.getStartIndex(str));
    }

    @Override
    public int getFinalIndex(int str) {
        int index = this.alignRes.get(str).size();
        Integer end = null;
        while (end == null && index >= 0) {
            end = this.alignRes.get(str).get(--index);
        }
        return index;
    }

    @Override
    public int getFinalResidue(int str) {
        return this.alignRes.get(str).get(this.getFinalIndex(str));
    }
}

