/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.align.model.AFP;
import org.biojava.nbio.structure.align.model.AfpChainWriter;
import org.biojava.nbio.structure.align.util.AFPAlignmentDisplay;
import org.biojava.nbio.structure.jama.Matrix;

public class AFPChain
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4474029015606617947L;
    public static final String newline = System.getProperty("line.separator");
    public static final String UNKNOWN_ALGORITHM = "unknown";
    private String algorithmName;
    private String version;
    private String name1;
    private String name2;
    private long ioTime;
    private long calculationTime;
    private long id;
    private double alignScore;
    private double alignScoreUpdate;
    private int afpChainTwiNum;
    private double tmScore;
    private int minLen;
    private List<AFP> afpSet;
    private int[][] afpIndex;
    private int[][] afpAftIndex;
    private int[][] afpBefIndex;
    private Matrix disTable1;
    private Matrix disTable2;
    private int[] twi = null;
    private int afpChainLen;
    private int[] afpChainList;
    private double[] afpChainTwiBin;
    private double[] afpChainTwiList;
    private double chainRmsd;
    private int chainLen;
    private int misLen;
    private int gapLen;
    private int blockNum;
    private int blockNumIni;
    private int blockNumClu;
    private int blockNumSpt;
    private double[] blockRmsd;
    private int[] block2Afp;
    private int[] blockSize;
    private double[] blockScore;
    private int[] blockGap;
    private int[] blockResSize;
    private int[][][] blockResList;
    private Matrix[] blockRotationMatrix;
    private Atom[] blockShiftVector;
    private int focusResn;
    private int[] focusRes1;
    private int[] focusRes2;
    private int focusAfpn;
    private int[] focusAfpList;
    private boolean shortAlign;
    private String[][][] pdbAln;
    private int[][][] optAln;
    private int[] optLen;
    private double[] optRmsd;
    private int optLength;
    private char[] alnsymb;
    private char[] alnseq1;
    private char[] alnseq2;
    private int alnLength;
    private int alnbeg1;
    private int alnbeg2;
    private int totalLenIni;
    private int totalLenOpt = 0;
    private double totalRmsdIni;
    private double totalRmsdOpt;
    private int ca1Length;
    private int ca2Length;
    private int maxTra = 5;
    private Double conn;
    private Double dvar;
    private double probability;
    private double identity;
    private double similarity;
    private double normAlignScore;
    private int myResultsEQR;
    private int myResultsSimilarity1;
    private int myResultsSimilarity2;
    private boolean sequentialAlignment;
    private Matrix distanceMatrix;
    private String description2;

    public AFPChain(String algorithmName) {
        this.algorithmName = algorithmName;
        this.init();
    }

    @Deprecated
    public AFPChain() {
        this.algorithmName = UNKNOWN_ALGORITHM;
        this.init();
    }

    public AFPChain(AFPChain o) {
        this.algorithmName = o.algorithmName;
        this.version = o.version;
        this.name1 = o.name1;
        this.name2 = o.name2;
        this.ioTime = o.ioTime;
        this.calculationTime = o.calculationTime;
        this.id = o.id;
        this.alignScore = o.alignScore;
        this.alignScoreUpdate = o.alignScoreUpdate;
        this.afpChainTwiNum = o.afpChainTwiNum;
        this.minLen = o.minLen;
        this.afpSet = new ArrayList<AFP>(o.afpSet);
        this.afpIndex = o.afpIndex == null ? (int[][])null : (int[][])o.afpIndex.clone();
        this.afpAftIndex = o.afpAftIndex == null ? (int[][])null : (int[][])o.afpAftIndex.clone();
        this.afpBefIndex = o.afpBefIndex == null ? (int[][])null : (int[][])o.afpBefIndex.clone();
        this.disTable1 = o.disTable1 == null ? null : (Matrix)o.disTable1.clone();
        this.disTable2 = o.disTable2 == null ? null : (Matrix)o.disTable2.clone();
        this.twi = o.twi == null ? null : (int[])o.twi.clone();
        this.afpChainLen = o.afpChainLen;
        this.afpChainList = o.afpChainList == null ? null : (int[])o.afpChainList.clone();
        this.afpChainTwiBin = o.afpChainTwiBin == null ? null : (double[])o.afpChainTwiBin.clone();
        this.afpChainTwiList = o.afpChainTwiList == null ? null : (double[])o.afpChainTwiList.clone();
        this.chainRmsd = o.chainRmsd;
        this.chainLen = o.chainLen;
        this.misLen = o.misLen;
        this.gapLen = o.gapLen;
        this.blockNum = o.blockNum;
        this.blockNumIni = o.blockNumIni;
        this.blockNumClu = o.blockNumClu;
        this.blockNumSpt = o.blockNumSpt;
        this.blockRmsd = o.blockRmsd == null ? null : (double[])o.blockRmsd.clone();
        this.block2Afp = o.block2Afp == null ? null : (int[])o.block2Afp.clone();
        this.blockSize = o.blockSize == null ? null : (int[])o.blockSize.clone();
        this.blockScore = o.blockScore == null ? null : (double[])o.blockScore.clone();
        this.blockGap = o.blockGap == null ? null : (int[])o.blockGap.clone();
        this.blockResSize = o.blockResSize == null ? null : (int[])o.blockResSize.clone();
        this.blockResList = o.blockResList == null ? (int[][][])null : (int[][][])o.blockResList.clone();
        this.blockRotationMatrix = o.blockRotationMatrix == null ? null : (Matrix[])o.blockRotationMatrix.clone();
        this.blockShiftVector = o.blockShiftVector == null ? null : (Atom[])o.blockShiftVector.clone();
        this.focusResn = o.focusResn;
        this.focusRes1 = o.focusRes1 == null ? null : (int[])o.focusRes1.clone();
        this.focusRes2 = o.focusRes2 == null ? null : (int[])o.focusRes2.clone();
        this.focusAfpn = o.focusAfpn;
        this.focusAfpList = o.focusAfpList == null ? null : (int[])o.focusAfpList.clone();
        this.shortAlign = o.shortAlign;
        this.pdbAln = o.pdbAln == null ? (String[][][])null : (String[][][])o.pdbAln.clone();
        this.optAln = o.optAln == null ? (int[][][])null : (int[][][])o.optAln.clone();
        this.optLen = o.optLen == null ? null : (int[])o.optLen.clone();
        this.optRmsd = o.optRmsd == null ? null : (double[])o.optRmsd.clone();
        this.optLength = o.optLength;
        this.alnsymb = o.alnsymb == null ? null : (char[])o.alnsymb.clone();
        this.alnseq1 = o.alnseq1 == null ? null : (char[])o.alnseq1.clone();
        this.alnseq2 = o.alnseq2 == null ? null : (char[])o.alnseq2.clone();
        this.alnLength = o.alnLength;
        this.alnbeg1 = o.alnbeg1;
        this.alnbeg2 = o.alnbeg2;
        this.totalLenIni = o.totalLenIni;
        this.totalLenOpt = o.totalLenOpt;
        this.totalRmsdIni = o.totalRmsdIni;
        this.totalRmsdOpt = o.totalRmsdOpt;
        this.ca1Length = o.ca1Length;
        this.ca2Length = o.ca2Length;
        this.maxTra = o.maxTra;
        this.conn = new Double(o.conn);
        this.dvar = new Double(o.dvar);
        this.probability = o.probability;
        this.identity = o.identity;
        this.similarity = o.similarity;
        this.normAlignScore = o.normAlignScore;
        this.myResultsEQR = o.myResultsEQR;
        this.myResultsSimilarity1 = o.myResultsSimilarity1;
        this.myResultsSimilarity2 = o.myResultsSimilarity2;
        this.distanceMatrix = o.distanceMatrix;
    }

    public Object clone() {
        return new AFPChain(this);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String toCE(Atom[] ca1, Atom[] ca2) {
        return AfpChainWriter.toCE(this, ca1, ca2);
    }

    public String toRotMat() {
        return AfpChainWriter.toRotMat(this);
    }

    public String toFatcat(Atom[] ca1, Atom[] ca2) {
        return AfpChainWriter.toFatCat(this, ca1, ca2);
    }

    public String toDBSearchResult() {
        return AfpChainWriter.toDBSearchResult(this);
    }

    protected void calcSimilarity() {
        Map<String, Double> idMap = AFPAlignmentDisplay.calcIdSimilarity(this.alnseq1, this.alnseq2, this.alnLength);
        this.similarity = idMap.get("similarity");
        this.identity = idMap.get("identity");
    }

    public int getNrEQR() {
        if (this.myResultsEQR < 0) {
            if (this.optLen == null) {
                this.myResultsEQR = 0;
                return 0;
            }
            int nrEqr = 0;
            for (int bk = 0; bk < this.blockNum; ++bk) {
                for (int i = 0; i < this.optLen[bk]; ++i) {
                    ++nrEqr;
                }
            }
            this.myResultsEQR = nrEqr;
        }
        return this.myResultsEQR;
    }

    public int getCoverage1() {
        if (this.myResultsSimilarity1 < 0) {
            int distance = this.ca1Length + this.ca2Length - 2 * this.getNrEQR();
            int similarity = (this.ca1Length + this.ca2Length - distance) / 2;
            this.myResultsSimilarity1 = Math.round((float)similarity / (float)this.ca1Length * 100.0f);
        }
        return this.myResultsSimilarity1;
    }

    public int getCoverage2() {
        if (this.myResultsSimilarity2 < 0) {
            int distance = this.ca1Length + this.ca2Length - 2 * this.getNrEQR();
            int similarity = (this.ca1Length + this.ca2Length - distance) / 2;
            this.myResultsSimilarity2 = Math.round((float)similarity / (float)this.ca2Length * 100.0f);
        }
        return this.myResultsSimilarity2;
    }

    @Deprecated
    public int getSimilarity1() {
        return this.getCoverage1();
    }

    @Deprecated
    public int getSimilarity2() {
        return this.getCoverage2();
    }

    public String toString() {
        StringBuffer str = new StringBuffer("");
        str.append("EQR:");
        str.append(this.getNrEQR());
        str.append("\tLen1:");
        str.append(this.getCa1Length());
        str.append("\tLen2:");
        str.append(this.getCa2Length());
        str.append(String.format("\tscore: %.2f", this.getAlignScore()));
        str.append("\t");
        if (this.algorithmName.equalsIgnoreCase("jCE") || this.algorithmName.equalsIgnoreCase("jCE-sidechain")) {
            str.append("Z-score:");
            str.append(String.format("%.2f", this.getProbability()));
        } else {
            str.append("Probability:");
            str.append(String.format("%.2e", this.getProbability()));
        }
        str.append("\tRMSD:");
        str.append(String.format("%.2f", this.getTotalRmsdOpt()));
        str.append("\tSeqID:");
        str.append(String.format("%.0f", this.getIdentity() * 100.0));
        str.append("%\tSeqSim:");
        str.append(String.format("%.0f", this.getSimilarity() * 100.0));
        str.append("%\tCov1:");
        str.append(this.getCoverage1());
        str.append("%\tCov2:");
        str.append(this.getCoverage2());
        str.append("%");
        if (this.tmScore != -1.0) {
            str.append("\ttmScore:");
            str.append(String.format("%.2f", this.tmScore));
        }
        str.append(newline);
        return str.toString();
    }

    public boolean isSignificantResult() {
        return this.algorithmName.equalsIgnoreCase("jCE") || this.algorithmName.equalsIgnoreCase("jCE-sidechain") ? this.probability >= 3.5 : this.probability < 0.01;
    }

    private void init() {
        this.shortAlign = false;
        this.afpChainLen = 0;
        this.afpChainList = null;
        this.afpChainTwiBin = null;
        this.afpChainTwiList = null;
        this.chainRmsd = 0.0;
        this.gapLen = 0;
        this.misLen = 0;
        this.chainLen = 0;
        this.blockResSize = null;
        this.blockScore = null;
        this.blockGap = null;
        this.optAln = null;
        this.pdbAln = null;
        this.optLen = null;
        this.optRmsd = null;
        this.block2Afp = new int[this.maxTra + 1];
        this.blockSize = new int[this.maxTra + 1];
        this.blockRmsd = new double[this.maxTra + 1];
        this.blockScore = new double[this.maxTra + 1];
        this.blockGap = new int[this.maxTra + 1];
        this.blockResSize = new int[this.maxTra + 1];
        this.afpSet = new ArrayList<AFP>();
        this.totalLenOpt = 0;
        this.totalLenIni = 0;
        this.totalRmsdOpt = 0.0;
        this.totalRmsdIni = 0.0;
        this.afpChainTwiNum = 0;
        this.alignScore = 0.0;
        this.alignScoreUpdate = 0.0;
        this.conn = new Double(0.0);
        this.dvar = new Double(0.0);
        this.calculationTime = 0L;
        this.similarity = -1.0;
        this.identity = -1.0;
        this.myResultsEQR = -1;
        this.myResultsSimilarity1 = -1;
        this.myResultsSimilarity2 = -1;
        this.version = "1.0";
        this.sequentialAlignment = true;
        this.distanceMatrix = null;
        this.tmScore = -1.0;
        this.description2 = null;
    }

    private void invalidate() {
        this.myResultsEQR = -1;
        this.myResultsSimilarity1 = -1;
        this.myResultsSimilarity2 = -1;
        this.identity = -1.0;
        this.similarity = -1.0;
    }

    public String[][][] getPdbAln() {
        return this.pdbAln;
    }

    public void setPdbAln(String[][][] pdbAln) {
        this.pdbAln = pdbAln;
    }

    public Double getConn() {
        return this.conn;
    }

    public void setConn(Double conn) {
        this.conn = conn;
    }

    public Double getDVar() {
        return this.dvar;
    }

    public void setDVar(Double dvar) {
        this.dvar = dvar;
    }

    public int getMaxTra() {
        return this.maxTra;
    }

    public void setMaxTra(int maxTra) {
        this.maxTra = maxTra;
    }

    public double getAlignScore() {
        return this.alignScore;
    }

    public void setAlignScore(double alignScore) {
        this.alignScore = alignScore;
    }

    public double getAlignScoreUpdate() {
        return this.alignScoreUpdate;
    }

    public void setAlignScoreUpdate(double alignScoreUpdate) {
        this.alignScoreUpdate = alignScoreUpdate;
    }

    public int getAfpChainTwiNum() {
        return this.afpChainTwiNum;
    }

    public void setAfpChainTwiNum(int afpChainTwiNum) {
        this.afpChainTwiNum = afpChainTwiNum;
    }

    public int getMinLen() {
        return this.minLen;
    }

    public void setMinLen(int minLen) {
        this.minLen = minLen;
    }

    public List<AFP> getAfpSet() {
        return this.afpSet;
    }

    public void setAfpSet(List<AFP> afpSet) {
        this.afpSet = afpSet;
    }

    public int[][] getAfpIndex() {
        return this.afpIndex;
    }

    public void setAfpIndex(int[][] afpIndex) {
        this.afpIndex = afpIndex;
    }

    public int[][] getAfpAftIndex() {
        return this.afpAftIndex;
    }

    public void setAfpAftIndex(int[][] afpAftIndex) {
        this.afpAftIndex = afpAftIndex;
    }

    public int[][] getAfpBefIndex() {
        return this.afpBefIndex;
    }

    public void setAfpBefIndex(int[][] afpBefIndex) {
        this.afpBefIndex = afpBefIndex;
    }

    public Matrix getDisTable1() {
        return this.disTable1;
    }

    public void setDisTable1(Matrix disTable1) {
        this.disTable1 = disTable1;
    }

    public Matrix getDisTable2() {
        return this.disTable2;
    }

    public void setDisTable2(Matrix disTable2) {
        this.disTable2 = disTable2;
    }

    public int[] getTwi() {
        return this.twi;
    }

    public void setTwi(int[] twi) {
        this.twi = twi;
    }

    public int getAfpChainLen() {
        return this.afpChainLen;
    }

    public void setAfpChainLen(int afpChainLen) {
        this.afpChainLen = afpChainLen;
    }

    public int[] getAfpChainList() {
        return this.afpChainList;
    }

    public void setAfpChainList(int[] afpChainList) {
        this.afpChainList = afpChainList;
    }

    public double[] getAfpChainTwiBin() {
        return this.afpChainTwiBin;
    }

    public void setAfpChainTwiBin(double[] afpChainTwiBin) {
        this.afpChainTwiBin = afpChainTwiBin;
    }

    public double[] getAfpChainTwiList() {
        return this.afpChainTwiList;
    }

    public void setAfpChainTwiList(double[] afpChainTwiList) {
        this.afpChainTwiList = afpChainTwiList;
    }

    public double getChainRmsd() {
        return this.chainRmsd;
    }

    public void setChainRmsd(double chainRmsd) {
        this.chainRmsd = chainRmsd;
    }

    public int getChainLen() {
        return this.chainLen;
    }

    public void setChainLen(int chainLen) {
        this.chainLen = chainLen;
    }

    public int getMisLen() {
        return this.misLen;
    }

    public void setMisLen(int misLen) {
        this.misLen = misLen;
    }

    public int getGapLen() {
        return this.gapLen;
    }

    public void setGapLen(int gapLen) {
        this.gapLen = gapLen;
    }

    public int getBlockNum() {
        return this.blockNum;
    }

    public void setBlockNum(int blockNum) {
        this.blockNum = blockNum;
    }

    public int getBlockNumIni() {
        return this.blockNumIni;
    }

    public void setBlockNumIni(int blockNumIni) {
        this.blockNumIni = blockNumIni;
    }

    public int getBlockNumClu() {
        return this.blockNumClu;
    }

    public void setBlockNumClu(int blockNumClu) {
        this.blockNumClu = blockNumClu;
    }

    public int getBlockNumSpt() {
        return this.blockNumSpt;
    }

    public void setBlockNumSpt(int blockNumSpt) {
        this.blockNumSpt = blockNumSpt;
    }

    public double[] getBlockRmsd() {
        return this.blockRmsd;
    }

    public void setBlockRmsd(double[] blockRmsd) {
        this.blockRmsd = blockRmsd;
    }

    public int[] getBlock2Afp() {
        return this.block2Afp;
    }

    public void setBlock2Afp(int[] block2Afp) {
        this.block2Afp = block2Afp;
    }

    public int[] getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int[] blockSize) {
        this.blockSize = blockSize;
    }

    public double[] getBlockScore() {
        return this.blockScore;
    }

    public void setBlockScore(double[] blockScore) {
        this.blockScore = blockScore;
    }

    public int[] getBlockGap() {
        return this.blockGap;
    }

    public void setBlockGap(int[] blockGap) {
        this.blockGap = blockGap;
    }

    public int[] getBlockResSize() {
        return this.blockResSize;
    }

    public void setBlockResSize(int[] blockResSize) {
        this.blockResSize = blockResSize;
    }

    public int[][][] getBlockResList() {
        return this.blockResList;
    }

    public void setBlockResList(int[][][] blockResList) {
        this.blockResList = blockResList;
    }

    public int getFocusResn() {
        return this.focusResn;
    }

    public void setFocusResn(int focusResn) {
        this.focusResn = focusResn;
    }

    public int[] getFocusRes1() {
        return this.focusRes1;
    }

    public void setFocusRes1(int[] focusRes1) {
        this.focusRes1 = focusRes1;
    }

    public int[] getFocusRes2() {
        return this.focusRes2;
    }

    public void setFocusRes2(int[] focusRes2) {
        this.focusRes2 = focusRes2;
    }

    public int getFocusAfpn() {
        return this.focusAfpn;
    }

    public void setFocusAfpn(int focusAfpn) {
        this.focusAfpn = focusAfpn;
    }

    public int[] getFocusAfpList() {
        return this.focusAfpList;
    }

    public void setFocusAfpList(int[] focusAfpList) {
        this.focusAfpList = focusAfpList;
    }

    public boolean isShortAlign() {
        return this.shortAlign;
    }

    public void setShortAlign(boolean shortAlign) {
        this.shortAlign = shortAlign;
    }

    public int[][][] getOptAln() {
        return this.optAln;
    }

    public void setOptAln(int[][][] optAln) {
        this.invalidate();
        this.optAln = optAln;
    }

    public int[] getOptLen() {
        return this.optLen;
    }

    public void setOptLen(int[] optLen) {
        this.optLen = optLen;
    }

    public double[] getOptRmsd() {
        return this.optRmsd;
    }

    public void setOptRmsd(double[] optRmsd) {
        this.optRmsd = optRmsd;
    }

    public int getOptLength() {
        return this.optLength;
    }

    public void setOptLength(int optLength) {
        this.optLength = optLength;
    }

    public char[] getAlnsymb() {
        return this.alnsymb;
    }

    public void setAlnsymb(char[] alnsymb) {
        this.alnsymb = alnsymb;
    }

    public char[] getAlnseq1() {
        return this.alnseq1;
    }

    public void setAlnseq1(char[] alnseq1) {
        this.alnseq1 = alnseq1;
    }

    public char[] getAlnseq2() {
        return this.alnseq2;
    }

    public void setAlnseq2(char[] alnseq2) {
        this.alnseq2 = alnseq2;
    }

    public int getAlnLength() {
        return this.alnLength;
    }

    public void setAlnLength(int alnLength) {
        this.alnLength = alnLength;
    }

    public int getAlnbeg1() {
        return this.alnbeg1;
    }

    public void setAlnbeg1(int alnbeg1) {
        this.alnbeg1 = alnbeg1;
    }

    public int getAlnbeg2() {
        return this.alnbeg2;
    }

    public void setAlnbeg2(int alnbeg2) {
        this.alnbeg2 = alnbeg2;
    }

    public int getTotalLenIni() {
        return this.totalLenIni;
    }

    public void setTotalLenIni(int totalLenIni) {
        this.totalLenIni = totalLenIni;
    }

    public int getTotalLenOpt() {
        return this.totalLenOpt;
    }

    public void setTotalLenOpt(int totalLenOpt) {
        this.totalLenOpt = totalLenOpt;
    }

    public double getTotalRmsdIni() {
        return this.totalRmsdIni;
    }

    public void setTotalRmsdIni(double totalRmsdIni) {
        this.totalRmsdIni = totalRmsdIni;
    }

    public double getTotalRmsdOpt() {
        return this.totalRmsdOpt;
    }

    public void setTotalRmsdOpt(double totalRmsdOpt) {
        this.totalRmsdOpt = totalRmsdOpt;
    }

    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public long getCalculationTime() {
        return this.calculationTime;
    }

    public void setCalculationTime(long calculationTime) {
        this.calculationTime = calculationTime;
    }

    public int getCa1Length() {
        return this.ca1Length;
    }

    public void setCa1Length(int ca1Length) {
        this.ca1Length = ca1Length;
    }

    public int getCa2Length() {
        return this.ca2Length;
    }

    public void setCa2Length(int ca2Length) {
        this.ca2Length = ca2Length;
    }

    public long getIoTime() {
        return this.ioTime;
    }

    public void setIoTime(long ioTime) {
        this.ioTime = ioTime;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public double getIdentity() {
        if (this.identity <= 0.0) {
            this.calcSimilarity();
        }
        return this.identity;
    }

    public void setIdentity(double identity) {
        this.identity = identity;
    }

    public double getSimilarity() {
        if (this.similarity < 0.0) {
            this.calcSimilarity();
        }
        return this.similarity;
    }

    public void setSimilarity(double similarity) {
        this.similarity = similarity;
    }

    public double getNormAlignScore() {
        return this.normAlignScore;
    }

    public void setNormAlignScore(double normAlignScore) {
        this.normAlignScore = normAlignScore;
    }

    public Matrix[] getBlockRotationMatrix() {
        return this.blockRotationMatrix;
    }

    public void setBlockRotationMatrix(Matrix[] blockRotationMatrix) {
        this.blockRotationMatrix = blockRotationMatrix;
    }

    public Atom[] getBlockShiftVector() {
        return this.blockShiftVector;
    }

    public void setBlockShiftVector(Atom[] blockShiftVector) {
        this.blockShiftVector = blockShiftVector;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isSequentialAlignment() {
        return this.sequentialAlignment;
    }

    public void setSequentialAlignment(boolean sequentialAlignment) {
        this.sequentialAlignment = sequentialAlignment;
    }

    public Matrix getDistanceMatrix() {
        return this.distanceMatrix;
    }

    public void setDistanceMatrix(Matrix distanceMatrix) {
        this.distanceMatrix = distanceMatrix;
    }

    public void setTMScore(double tmScore) {
        this.tmScore = tmScore;
    }

    public double getTMScore() {
        return this.tmScore;
    }

    public String getDescription2() {
        return this.description2;
    }

    public void setDescription2(String desc) {
        this.description2 = desc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blockNum;
        result = 31 * result + this.ca1Length;
        result = 31 * result + this.ca2Length;
        result = 31 * result + Arrays.hashCode((Object[])this.optAln);
        result = 31 * result + Arrays.hashCode(this.optLen);
        result = 31 * result + this.optLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AFPChain other = (AFPChain)obj;
        if (this.blockNum != other.blockNum) {
            return false;
        }
        if (this.ca1Length != other.ca1Length) {
            return false;
        }
        if (this.ca2Length != other.ca2Length) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.optAln, (Object[])other.optAln)) {
            return false;
        }
        if (!Arrays.equals(this.optLen, other.optLen)) {
            return false;
        }
        return this.optLength == other.optLength;
    }
}

