/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.seq;

import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.ce.AbstractUserArgumentProcessor;
import org.biojava.nbio.structure.align.ce.StartupParameters;
import org.biojava.nbio.structure.align.seq.SmithWaterman3DParameters;
import org.biojava.nbio.structure.align.seq.SmithWaterman3Daligner;

public class SmithWatermanUserArgumentProcessor
extends AbstractUserArgumentProcessor {
    @Override
    public StructureAlignment getAlgorithm() {
        return new SmithWaterman3Daligner();
    }

    @Override
    public Object getParameters() {
        StructureAlignment alignment = this.getAlgorithm();
        SmithWaterman3DParameters p = (SmithWaterman3DParameters)alignment.getParameters();
        SmithWatermanStartupParams startup = (SmithWatermanStartupParams)this.params;
        if (p == null) {
            p = new SmithWaterman3DParameters();
        }
        p.setGapExtend(startup.getGapExtend());
        p.setGapOpen(startup.getGapOpen());
        return p;
    }

    @Override
    public String getDbSearchLegend() {
        String legend = "# name1\tname2\tscore\tz-score\trmsd\tlen1\tlen2\tsim1\tsim2\t ";
        return legend;
    }

    @Override
    protected StartupParameters getStartupParametersInstance() {
        return new SmithWatermanStartupParams();
    }

    protected static class SmithWatermanStartupParams
    extends StartupParameters {
        private short gapOpen;
        private short gapExtend;

        public short getGapOpen() {
            return this.gapOpen;
        }

        public void setGapOpen(short gapOpen) {
            this.gapOpen = gapOpen;
        }

        public short getGapExtend() {
            return this.gapExtend;
        }

        public void setGapExtend(short gapExtend) {
            this.gapExtend = gapExtend;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SmithWatermanStartupParams [gapOpen=").append(this.gapOpen).append(", gapExtend=").append(this.gapExtend).append("]");
            return builder.toString();
        }
    }
}

