/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.quaternary.CartesianProduct;
import org.biojava.nbio.structure.quaternary.OrderedPair;

public class BioAssemblyTools {
    public static boolean isUnaryExpression(String expression) {
        int first = expression.indexOf("(");
        int last = expression.lastIndexOf("(");
        if (first < 0 || last < 0) {
            return true;
        }
        return first != 0 || last <= first;
    }

    public static List<String> parseUnaryOperatorExpression(String operatorExpression) throws IllegalArgumentException {
        return BioAssemblyTools.parseSubExpression(operatorExpression);
    }

    private static List<String> parseSubExpression(String expression) throws IllegalArgumentException {
        String tmp = expression.replace("(", "");
        tmp = tmp.replace(")", "");
        List<String> components = null;
        try {
            components = Arrays.asList(tmp.split(","));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid oper_expression: " + expression);
        }
        ArrayList<String> operators = new ArrayList<String>();
        for (String component : components) {
            if (component.contains("-")) {
                operators.addAll(BioAssemblyTools.expandRange(component));
                continue;
            }
            operators.add(component);
        }
        return operators;
    }

    private static List<String> expandRange(String expression) throws IllegalArgumentException {
        int first = 0;
        int last = 0;
        try {
            String[] range = expression.split("-");
            first = Integer.parseInt(range[0]);
            last = Integer.parseInt(range[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid range specification in oper_expression: " + expression);
        }
        ArrayList<String> expandedExpression = new ArrayList<String>(last - first + 1);
        for (int i = first; i <= last; ++i) {
            expandedExpression.add(String.valueOf(i));
        }
        return expandedExpression;
    }

    public static List<OrderedPair<String>> parseBinaryOperatorExpression(String expression) throws IllegalArgumentException {
        String[] subExpressions = null;
        try {
            subExpressions = expression.split("\\)\\(");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid oper_expression: " + expression);
        }
        if (subExpressions.length != 2) {
            throw new IllegalArgumentException("Invalid oper_expression: " + expression);
        }
        List<String> leftSide = BioAssemblyTools.parseSubExpression(subExpressions[0]);
        List<String> rightSide = BioAssemblyTools.parseSubExpression(subExpressions[1]);
        CartesianProduct<String> product = new CartesianProduct<String>(leftSide, rightSide);
        return product.getOrderedPairs();
    }

    public static double[][] getBiologicalMoleculeBounds(Structure asymStructure, List<BiologicalAssemblyTransformation> transformations) {
        Atom[] atoms;
        double[][] coordinateBounds = new double[2][3];
        coordinateBounds[0][0] = Double.MAX_VALUE;
        coordinateBounds[0][1] = Double.MAX_VALUE;
        coordinateBounds[0][2] = Double.MAX_VALUE;
        coordinateBounds[1][0] = Double.MIN_VALUE;
        coordinateBounds[1][1] = Double.MIN_VALUE;
        coordinateBounds[1][2] = Double.MIN_VALUE;
        double[] transformedCoords = new double[3];
        for (Atom a : atoms = StructureTools.getAllAtomArray(asymStructure)) {
            Chain c = a.getGroup().getChain();
            String intChainID = c.getInternalChainID();
            if (intChainID == null) {
                intChainID = c.getChainID();
            }
            for (BiologicalAssemblyTransformation m : transformations) {
                if (!m.getChainId().equals(intChainID)) continue;
                double[] coords = a.getCoords();
                transformedCoords[0] = coords[0];
                transformedCoords[1] = coords[1];
                transformedCoords[2] = coords[2];
                if (transformedCoords[0] < coordinateBounds[0][0]) {
                    coordinateBounds[0][0] = transformedCoords[0];
                }
                if (transformedCoords[1] < coordinateBounds[0][1]) {
                    coordinateBounds[0][1] = transformedCoords[1];
                }
                if (transformedCoords[2] < coordinateBounds[0][2]) {
                    coordinateBounds[0][2] = transformedCoords[2];
                }
                if (transformedCoords[0] > coordinateBounds[1][0]) {
                    coordinateBounds[1][0] = transformedCoords[0];
                }
                if (transformedCoords[1] > coordinateBounds[1][1]) {
                    coordinateBounds[1][1] = transformedCoords[1];
                }
                if (!(transformedCoords[2] > coordinateBounds[1][2])) continue;
                coordinateBounds[1][2] = transformedCoords[2];
            }
        }
        return coordinateBounds;
    }

    public static double[][] getAtomCoordinateBounds(Structure s) {
        Atom[] atoms = StructureTools.getAllAtomArray(s);
        int atomCount = atoms.length;
        double[][] coordinateBounds = new double[2][3];
        if (atomCount <= 0) {
            return coordinateBounds;
        }
        Atom a = atoms[0];
        coordinateBounds[0][0] = a.getX();
        coordinateBounds[0][1] = a.getY();
        coordinateBounds[0][2] = a.getZ();
        coordinateBounds[1][0] = a.getX();
        coordinateBounds[1][1] = a.getY();
        coordinateBounds[1][2] = a.getZ();
        for (int i = 1; i < atomCount; ++i) {
            a = atoms[i];
            if (a.getX() < coordinateBounds[0][0]) {
                coordinateBounds[0][0] = a.getX();
            }
            if (a.getY() < coordinateBounds[0][1]) {
                coordinateBounds[0][1] = a.getY();
            }
            if (a.getZ() < coordinateBounds[0][2]) {
                coordinateBounds[0][2] = a.getZ();
            }
            if (a.getX() > coordinateBounds[1][0]) {
                coordinateBounds[1][0] = a.getX();
            }
            if (a.getY() > coordinateBounds[1][1]) {
                coordinateBounds[1][1] = a.getY();
            }
            if (!(a.getZ() > coordinateBounds[1][2])) continue;
            coordinateBounds[1][2] = a.getZ();
        }
        return coordinateBounds;
    }

    public static double getMaximumExtend(Structure structure) {
        double[][] bounds = BioAssemblyTools.getAtomCoordinateBounds(structure);
        double xMax = Math.abs(bounds[0][0] - bounds[1][0]);
        double yMax = Math.abs(bounds[0][1] - bounds[1][1]);
        double zMax = Math.abs(bounds[0][2] - bounds[1][2]);
        return Math.max(xMax, Math.max(yMax, zMax));
    }

    public static double getBiologicalMoleculeMaximumExtend(Structure structure, List<BiologicalAssemblyTransformation> transformations) {
        double[][] bounds = BioAssemblyTools.getBiologicalMoleculeBounds(structure, transformations);
        double xMax = Math.abs(bounds[0][0] - bounds[1][0]);
        double yMax = Math.abs(bounds[0][1] - bounds[1][1]);
        double zMax = Math.abs(bounds[0][2] - bounds[1][2]);
        return Math.max(xMax, Math.max(yMax, zMax));
    }

    public static double[] getBiologicalMoleculeCentroid(Structure asymUnit, List<BiologicalAssemblyTransformation> transformations) throws IllegalArgumentException {
        if (asymUnit == null) {
            throw new IllegalArgumentException("null structure");
        }
        Atom[] atoms = StructureTools.getAllAtomArray(asymUnit);
        int atomCount = atoms.length;
        double[] centroid = new double[3];
        if (atomCount <= 0) {
            return centroid;
        }
        if (transformations.size() == 0) {
            return Calc.getCentroid(atoms).getCoords();
        }
        int count = 0;
        double[] transformedCoordinate = new double[3];
        for (int i = 0; i < atomCount; ++i) {
            Atom atom = atoms[i];
            Chain chain = atom.getGroup().getChain();
            String intChainID = chain.getInternalChainID();
            if (intChainID == null) {
                intChainID = chain.getChainID();
            }
            for (BiologicalAssemblyTransformation m : transformations) {
                if (!m.getChainId().equals(intChainID)) continue;
                double[] coords = atom.getCoords();
                transformedCoordinate[0] = coords[0];
                transformedCoordinate[1] = coords[1];
                transformedCoordinate[2] = coords[2];
                m.transformPoint(transformedCoordinate);
                centroid[0] = centroid[0] + transformedCoordinate[0];
                centroid[1] = centroid[1] + transformedCoordinate[1];
                centroid[2] = centroid[2] + transformedCoordinate[2];
                ++count;
            }
        }
        centroid[0] = centroid[0] / (double)count;
        centroid[1] = centroid[1] / (double)count;
        centroid[2] = centroid[2] / (double)count;
        return centroid;
    }

    @Deprecated
    public static Structure getReducedCAStructure(Structure orig) {
        StructureImpl s = new StructureImpl();
        s.setPDBHeader(orig.getPDBHeader());
        for (Chain c : orig.getChains()) {
            ChainImpl c1 = new ChainImpl();
            c1.setChainID(c.getChainID());
            s.addChain(c1);
            for (Group g : c.getAtomGroups()) {
                try {
                    Atom a = g.getAtom("CA");
                    if (a == null) continue;
                    Group g1 = (Group)g.clone();
                    g1.clearAtoms();
                    g1.addAtom(a);
                    c1.addGroup(g1);
                }
                catch (Exception exception) {}
            }
        }
        return s;
    }

    public static Structure getReducedStructure(Structure orig) {
        StructureImpl s = new StructureImpl();
        s.setPDBHeader(orig.getPDBHeader());
        for (Chain c : orig.getChains()) {
            ChainImpl c1 = new ChainImpl();
            c1.setChainID(c.getChainID());
            s.addChain(c1);
            for (Group g : c.getAtomGroups()) {
                try {
                    Atom a = null;
                    switch (g.getType()) {
                        case AMINOACID: {
                            a = g.getAtom("CA");
                            break;
                        }
                        case NUCLEOTIDE: {
                            a = g.getAtom("P");
                            break;
                        }
                    }
                    if (a == null) continue;
                    Group g1 = (Group)g.clone();
                    g1.clearAtoms();
                    g1.addAtom(a);
                    c1.addGroup(g1);
                }
                catch (Exception exception) {}
            }
        }
        return s;
    }
}

