/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.structure.ExperimentalTechnique;
import org.biojava.nbio.structure.JournalArticle;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBRecord;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePdbrevRecord;
import org.biojava.nbio.structure.quaternary.BioAssemblyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDBHeader
implements PDBRecord {
    private static final long serialVersionUID = -5834326174085429508L;
    private static final Logger logger = LoggerFactory.getLogger(PDBHeader.class);
    private String title;
    private String description;
    private String idCode;
    private String classification;
    private Date depDate = new Date(0L);
    private Date relDate;
    private Date modDate = new Date(0L);
    private Set<ExperimentalTechnique> techniques;
    private PDBCrystallographicInfo crystallographicInfo;
    private float resolution = 99.0f;
    private float rFree = 1.0f;
    private float rWork = 1.0f;
    private JournalArticle journalArticle;
    private String authors;
    public static final float DEFAULT_RESOLUTION = 99.0f;
    public static final float DEFAULT_RFREE = 1.0f;
    private Long id;
    public static final String newline = System.getProperty("line.separator");
    private DateFormat dateFormat;
    private Map<Integer, BioAssemblyInfo> bioAssemblies;
    List<DatabasePdbrevRecord> revisionRecords;

    public PDBHeader() {
        this.relDate = new Date(0L);
        this.dateFormat = new SimpleDateFormat("dd-MMM-yy", Locale.US);
        this.bioAssemblies = new HashMap<Integer, BioAssemblyInfo>();
        this.crystallographicInfo = new PDBCrystallographicInfo();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            Method[] methods;
            Class<?> c = Class.forName(PDBHeader.class.getName());
            for (Method m : methods = c.getMethods()) {
                Object o;
                String name = m.getName();
                if (!name.substring(0, 3).equals("get") || name.equals("getClass") || (o = m.invoke((Object)this, new Object[0])) == null) continue;
                buf.append(name.substring(3, name.length()));
                buf.append(": ").append(o).append(" ");
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Exception caught while creating toString  ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("Exception caught while creating toString ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Exception caught while creating toString ", (Throwable)e);
        }
        return buf.toString();
    }

    @Override
    public String toPDB() {
        StringBuffer buf = new StringBuffer();
        this.toPDB(buf);
        return buf.toString();
    }

    @Override
    public void toPDB(StringBuffer buf) {
        this.printHeader(buf);
        this.printTitle(buf);
        this.printExpdata(buf);
        this.printAuthors(buf);
        this.printResolution(buf);
    }

    private void printResolution(StringBuffer buf) {
        if (this.getResolution() == 99.0f) {
            return;
        }
        DecimalFormat d2 = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        d2.setMaximumIntegerDigits(2);
        d2.setMinimumFractionDigits(2);
        d2.setMaximumFractionDigits(2);
        buf.append("REMARK   2 RESOLUTION. ");
        String x = d2.format(this.resolution);
        buf.append(x);
        buf.append(" ANGSTROMS.");
        this.fillLine(buf, 34 + x.length());
        buf.append(newline);
    }

    private void printExpdata(StringBuffer buf) {
        Set<ExperimentalTechnique> exp = this.getExperimentalTechniques();
        if (exp == null) {
            return;
        }
        buf.append("EXPDTA    ");
        int length = 0;
        int i = 0;
        for (ExperimentalTechnique et : exp) {
            if (i > 0) {
                buf.append("; ");
                length += 2;
            }
            buf.append(et.getName());
            length += et.getName().length();
            ++i;
        }
        int l = length + 10;
        this.fillLine(buf, l);
        buf.append(newline);
    }

    private void printAuthors(StringBuffer buf) {
        String authors = this.getAuthors();
        if (authors == null) {
            return;
        }
        if (authors.equals("")) {
            return;
        }
        this.printMultiLine(buf, "AUTHOR   ", authors, ',');
    }

    private void printMultiLine(StringBuffer buf, String lineStart, String data, char breakChar) {
        int l;
        if (lineStart.length() != 9) {
            logger.info("lineStart != 9, there will be problems :" + lineStart);
        }
        if (data.length() < 58) {
            buf.append(lineStart);
            buf.append(" ");
            buf.append(data);
            buf.append(newline);
            return;
        }
        String thisLine = "";
        int count = 1;
        while (data.length() > 57) {
            boolean charFound = false;
            for (int i = 57; i > -1; --i) {
                char c = data.charAt(i);
                if (c != breakChar) continue;
                thisLine = data.substring(0, i + 1);
                if (i == 0) {
                    ++i;
                }
                data = data.substring(i);
                charFound = true;
                break;
            }
            if (!charFound) {
                thisLine = data.substring(0, 58);
                data = data.substring(57);
            }
            if (breakChar == ',' && data.charAt(0) == ',') {
                data = data.substring(1);
            }
            buf.append(lineStart);
            if (count > 1) {
                buf.append(count);
                if (breakChar != ' ') {
                    buf.append(" ");
                }
            } else {
                buf.append(" ");
            }
            buf.append(thisLine);
            for (l = thisLine.length() + 10; l < 67; ++l) {
                buf.append(" ");
            }
            buf.append(newline);
            ++count;
        }
        if (!data.trim().isEmpty()) {
            buf.append(lineStart);
            buf.append(count);
            int filledLeft = 10;
            if (breakChar != ' ') {
                buf.append(" ");
                ++filledLeft;
            }
            buf.append(data);
            l = data.length() + filledLeft;
            this.fillLine(buf, l);
            buf.append(newline);
        }
    }

    private void fillLine(StringBuffer buf, int currentPos) {
        for (int l = currentPos; l < 67; ++l) {
            buf.append(" ");
        }
    }

    private void printHeader(StringBuffer buf) {
        String classification = this.getClassification();
        if (classification == null || classification.isEmpty()) {
            return;
        }
        buf.append("HEADER    ");
        buf.append(classification);
        buf.append(" ");
        for (int l = classification.length() + 10; l < 49; ++l) {
            buf.append(" ");
        }
        Date d = this.getDepDate();
        if (d != null) {
            buf.append(this.dateFormat.format(d));
        } else {
            buf.append("         ");
        }
        buf.append("   ");
        String id = this.getIdCode();
        if (id != null) {
            buf.append(this.getIdCode());
            buf.append(" ");
        } else {
            buf.append("    ");
        }
        buf.append(newline);
    }

    private void printTitle(StringBuffer buf) {
        String title = this.getTitle();
        if (title == null || title.trim().isEmpty()) {
            return;
        }
        this.printMultiLine(buf, "TITLE    ", title, ' ');
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public boolean equals(PDBHeader other) {
        try {
            Method[] methods;
            Class<?> c = Class.forName(PDBHeader.class.getName());
            for (Method m : methods = c.getMethods()) {
                String name = m.getName();
                if (!name.substring(0, 3).equals("get") || name.equals("getClass")) continue;
                Object a = m.invoke((Object)this, new Object[0]);
                Object b = m.invoke((Object)other, new Object[0]);
                if (a == null) {
                    if (b == null) continue;
                    logger.warn(name + " a is null, where other is " + b);
                    return false;
                }
                if (b == null) {
                    logger.warn(name + " other is null, where a is " + a);
                    return false;
                }
                if (a.equals(b)) continue;
                logger.warn("mismatch with " + name + " >" + a + "< >" + b + "<");
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Exception caught while comparing PDBHeader objects ", (Throwable)e);
            return false;
        }
        catch (InvocationTargetException e) {
            logger.error("Exception caught while comparing PDBHeader objects ", (Throwable)e);
            return false;
        }
        catch (IllegalAccessException e) {
            logger.error("Exception caught while comparing PDBHeader objects ", (Throwable)e);
            return false;
        }
        return true;
    }

    public String getIdCode() {
        return this.idCode;
    }

    public void setIdCode(String idCode) {
        this.idCode = idCode;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public Date getDepDate() {
        return this.depDate;
    }

    public void setDepDate(Date depDate) {
        this.depDate = depDate;
    }

    public Set<ExperimentalTechnique> getExperimentalTechniques() {
        return this.techniques;
    }

    public boolean setExperimentalTechnique(String techniqueStr) {
        ExperimentalTechnique et = ExperimentalTechnique.getByName(techniqueStr);
        if (et == null) {
            return false;
        }
        if (this.techniques == null) {
            this.techniques = EnumSet.of(et);
            return true;
        }
        return this.techniques.add(et);
    }

    public PDBCrystallographicInfo getCrystallographicInfo() {
        return this.crystallographicInfo;
    }

    public void setCrystallographicInfo(PDBCrystallographicInfo crystallographicInfo) {
        this.crystallographicInfo = crystallographicInfo;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void setResolution(float resolution) {
        this.resolution = resolution;
    }

    public float getRfree() {
        return this.rFree;
    }

    public void setRfree(float rFree) {
        this.rFree = rFree;
    }

    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date modDate) {
        this.modDate = modDate;
    }

    public Date getRelDate() {
        return this.relDate;
    }

    public void setRelDate(Date relDate) {
        this.relDate = relDate;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public boolean hasJournalArticle() {
        return this.journalArticle != null;
    }

    public JournalArticle getJournalArticle() {
        return this.journalArticle;
    }

    public void setJournalArticle(JournalArticle journalArticle) {
        this.journalArticle = journalArticle;
    }

    public Map<Integer, BioAssemblyInfo> getBioAssemblies() {
        return this.bioAssemblies;
    }

    public void setBioAssemblies(Map<Integer, BioAssemblyInfo> bioAssemblies) {
        this.bioAssemblies = bioAssemblies;
    }

    public int getNrBioAssemblies() {
        return this.bioAssemblies.size();
    }

    public List<DatabasePdbrevRecord> getRevisionRecords() {
        return this.revisionRecords;
    }

    public void setRevisionRecords(List<DatabasePdbrevRecord> revisionRecords) {
        this.revisionRecords = revisionRecords;
    }

    public float getRwork() {
        return this.rWork;
    }

    public void setRwork(float rWork) {
        this.rWork = rWork;
    }
}

