/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.UnitQuaternions;
import org.biojava.nbio.structure.symmetry.core.QuatSuperpositionScorer;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryScores;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySolver;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetrySubunits;
import org.biojava.nbio.structure.symmetry.core.Rotation;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;

public class C2RotationSolver
implements QuatSymmetrySolver {
    private QuatSymmetrySubunits subunits = null;
    private QuatSymmetryParameters parameters = null;
    private Vector3d centroid = new Vector3d();
    private Matrix4d centroidInverse = new Matrix4d();
    private RotationGroup rotations = new RotationGroup();

    public C2RotationSolver(QuatSymmetrySubunits subunits, QuatSymmetryParameters parameters) {
        if (subunits.getSubunitCount() != 2) {
            throw new IllegalArgumentException("C2RotationSolver can only be applied to cases with 2 centers");
        }
        this.subunits = subunits;
        this.parameters = parameters;
    }

    @Override
    public RotationGroup getSymmetryOperations() {
        if (this.rotations.getOrder() == 0) {
            this.solve();
        }
        return this.rotations;
    }

    private void solve() {
        this.initialize();
        Vector3d trans = new Vector3d((Tuple3d)this.subunits.getCentroid());
        trans.negate();
        List<Point3d[]> traces = this.subunits.getTraces();
        Point3d[] x = CalcPoint.clonePoint3dArray(traces.get(0));
        CalcPoint.translate(trans, x);
        Point3d[] y = CalcPoint.clonePoint3dArray(traces.get(1));
        CalcPoint.translate(trans, y);
        Quat4d quat = UnitQuaternions.relativeOrientation(x, y);
        AxisAngle4d axisAngle = new AxisAngle4d();
        Matrix4d transformation = new Matrix4d();
        transformation.set(quat);
        axisAngle.set(quat);
        Vector3d axis = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
        if (axis.lengthSquared() < 1.0E-6) {
            axisAngle.x = 0.0;
            axisAngle.y = 0.0;
            axisAngle.z = 1.0;
            axisAngle.angle = 0.0;
        } else {
            axis.normalize();
            axisAngle.x = axis.x;
            axisAngle.y = axis.y;
            axisAngle.z = axis.z;
        }
        CalcPoint.transform(transformation, y);
        double angleThresholdRadians = Math.toRadians(this.parameters.getAngleThreshold());
        double deltaAngle = Math.abs(Math.PI - axisAngle.angle);
        if (deltaAngle > angleThresholdRadians) {
            this.rotations.setC1(this.subunits.getSubunitCount());
            return;
        }
        this.addEOperation();
        int fold = 2;
        this.combineWithTranslation(transformation);
        List<Integer> permutation = Arrays.asList(1, 0);
        QuatSymmetryScores scores = QuatSuperpositionScorer.calcScores(this.subunits, transformation, permutation);
        scores.setRmsdCenters(0.0);
        if (scores.getRmsd() > this.parameters.getRmsdThreshold() || deltaAngle > angleThresholdRadians) {
            this.rotations.setC1(this.subunits.getSubunitCount());
            return;
        }
        Rotation symmetryOperation = this.createSymmetryOperation(permutation, transformation, axisAngle, fold, scores);
        this.rotations.addRotation(symmetryOperation);
    }

    private void addEOperation() {
        List<Integer> permutation = Arrays.asList(0, 1);
        Matrix4d transformation = new Matrix4d();
        transformation.setIdentity();
        this.combineWithTranslation(transformation);
        AxisAngle4d axisAngle = new AxisAngle4d();
        QuatSymmetryScores scores = new QuatSymmetryScores();
        int fold = 1;
        Rotation rotation = this.createSymmetryOperation(permutation, transformation, axisAngle, fold, scores);
        this.rotations.addRotation(rotation);
    }

    private void combineWithTranslation(Matrix4d rotation) {
        rotation.setTranslation(this.centroid);
        rotation.mul(rotation, this.centroidInverse);
    }

    private Rotation createSymmetryOperation(List<Integer> permutation, Matrix4d transformation, AxisAngle4d axisAngle, int fold, QuatSymmetryScores scores) {
        Rotation s = new Rotation();
        s.setPermutation(new ArrayList<Integer>(permutation));
        s.setTransformation(new Matrix4d(transformation));
        s.setAxisAngle(new AxisAngle4d(axisAngle));
        s.setFold(fold);
        s.setScores(scores);
        return s;
    }

    private void initialize() {
        this.centroid = new Vector3d((Tuple3d)this.subunits.getCentroid());
        Vector3d reverse = new Vector3d(this.centroid);
        reverse.negate();
        this.centroidInverse.set(reverse);
        this.centroidInverse.setElement(3, 3, 1.0);
    }
}

