/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class SynchronizedOutFile {
    File file;
    String[] tmp;
    int ARR_SIZE = 100;
    Integer counter;
    boolean useGzipCompression = false;

    public SynchronizedOutFile(File f, boolean gzipCompress) throws FileNotFoundException, IOException {
        if (f.isDirectory()) {
            throw new FileNotFoundException("please provide a file and not a directory");
        }
        if (!f.exists()) {
            System.out.println("creating output file: " + f.getAbsolutePath());
            f.createNewFile();
        }
        this.file = f;
        this.tmp = new String[this.ARR_SIZE];
        this.counter = -1;
        this.useGzipCompression = gzipCompress;
    }

    public SynchronizedOutFile(File f) throws FileNotFoundException, IOException {
        this(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(String message) throws IOException {
        Integer n = this.counter;
        synchronized (n) {
            Integer n2 = this.counter;
            this.counter = this.counter + 1;
            this.tmp[this.counter.intValue()] = message;
            if (this.counter >= this.ARR_SIZE - 1) {
                this.writeArr();
                this.counter = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() throws IOException {
        Integer n = this.counter;
        synchronized (n) {
            this.writeArr();
            this.counter = -1;
        }
    }

    public void close() throws IOException {
        this.writeArr();
        this.tmp = new String[this.ARR_SIZE];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeArr() throws IOException {
        OutputStream out = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.file, true);
            OutputStream outputstream = this.useGzipCompression ? new GZIPOutputStream(fileOutputStream) : fileOutputStream;
            out = new BufferedOutputStream(outputstream);
            for (int i = 0; i <= this.counter; ++i) {
                if (this.tmp[i] == null) continue;
                byte[] data = this.tmp[i].getBytes();
                out.write(data, 0, data.length);
            }
        }
        catch (Exception x) {
            System.err.println(x);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

