/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.client;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.core.util.FileDownloadUtils;
import org.biojava.nbio.structure.BioAssemblyIdentifier;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.URLIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.cath.CathFactory;
import org.biojava.nbio.structure.ecod.EcodFactory;
import org.biojava.nbio.structure.scop.ScopDatabase;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureName
implements Comparable<StructureName>,
Serializable,
StructureIdentifier {
    private static final long serialVersionUID = 4021229518711762957L;
    private static final Logger logger = LoggerFactory.getLogger(StructureName.class);
    protected String name;
    protected PdbId pdbId;
    protected String chainName;
    private static final Pattern cathPattern = Pattern.compile("^(?:CATH:)?([0-9][a-z0-9]{3})(\\w)([0-9]{2})$", 2);
    private static final Pattern scopPattern = Pattern.compile("^(?:SCOP:)?d([0-9][a-z0-9]{3}|s046)(\\w|\\.)(\\w)$", 2);
    private static final Pattern ecodPattern = Pattern.compile("^(?:ECOD:)?e([0-9][a-z0-9]{3})(?:\\w|\\.)\\w+$", 2);
    private Source mySource = null;
    private StructureIdentifier base = null;

    public StructureName(String name) {
        this.name = name;
        this.init();
    }

    private void init() {
        String[] prefix = this.name.split(":", 2);
        this.mySource = null;
        if (prefix.length > 1) {
            String suffix = prefix[1];
            try {
                this.mySource = Source.valueOf(prefix[0].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.mySource = null;
            }
            if (this.mySource != null) {
                switch (this.mySource) {
                    case SCOP: {
                        if (!this.initFromScop(suffix)) {
                            throw new IllegalArgumentException("Malformed SCOP domain name:" + suffix);
                        }
                        return;
                    }
                    case CATH: {
                        if (!this.initFromCATH(suffix)) {
                            throw new IllegalArgumentException("Malformed CATH domain name:" + suffix);
                        }
                        return;
                    }
                    case BIO: {
                        if (!this.initFromBIO(this.name)) {
                            throw new IllegalArgumentException("Malformed BIO name:" + suffix);
                        }
                        return;
                    }
                    case ECOD: {
                        if (!this.initFromECOD(suffix)) {
                            throw new IllegalArgumentException("Malformed ECOD domain name:" + suffix);
                        }
                        return;
                    }
                    case PDB: {
                        if (!this.initFromPDB(suffix)) {
                            throw new IllegalArgumentException("Malformed PDB specification:" + suffix);
                        }
                        return;
                    }
                    case FILE: {
                        if (!suffix.startsWith("/")) {
                            this.initFromFile();
                            return;
                        }
                    }
                    case URL: {
                        if (!this.initFromURL(this.name)) {
                            throw new IllegalArgumentException("Malformed URL specification:" + suffix);
                        }
                        return;
                    }
                }
                throw new IllegalStateException("Unimplemented Source " + this.mySource);
            }
        }
        if (this.initFromScop(this.name)) {
            return;
        }
        if (this.initFromCATH(this.name)) {
            return;
        }
        if (this.initFromECOD(this.name)) {
            return;
        }
        if (this.initFromURL(this.name)) {
            return;
        }
        File file = new File(FileDownloadUtils.expandUserHome((String)this.name));
        if (file.canRead() && !file.isDirectory()) {
            if (this.name.matches("\\d\\w\\w\\w")) {
                logger.warn("Provided 4-letter structure name '{}' matches file name in directory {}. Will read structure data from file {} and not consider the name as a structure identifier. If this is not what you want, use 'FILE:{}'", new Object[]{this.name, file.getAbsoluteFile().getParent(), file.getAbsolutePath(), this.name});
            } else {
                logger.info("Provided structure name '{}' matches file name in directory {}. Will read structure data from file {}.", new Object[]{this.name, file.getAbsoluteFile().getParent(), file.getAbsolutePath()});
            }
            this.initFromFile();
            return;
        }
        this.initFromPDB(this.name);
    }

    private boolean initFromScop(String name) {
        Matcher matcher = scopPattern.matcher(name);
        if (matcher.matches()) {
            this.mySource = Source.SCOP;
            this.pdbId = new PdbId(matcher.group(1));
            this.chainName = matcher.group(2);
            return true;
        }
        return false;
    }

    private boolean initFromCATH(String name) {
        Matcher matcher = cathPattern.matcher(name);
        if (matcher.matches()) {
            this.mySource = Source.CATH;
            this.pdbId = new PdbId(matcher.group(1));
            this.chainName = matcher.group(2);
            return true;
        }
        return false;
    }

    private boolean initFromECOD(String name) {
        Matcher matcher = ecodPattern.matcher(name);
        if (matcher.matches()) {
            this.mySource = Source.ECOD;
            this.pdbId = new PdbId(matcher.group(1));
            this.chainName = null;
            return true;
        }
        return false;
    }

    private boolean initFromBIO(String name) {
        Matcher matcher = BioAssemblyIdentifier.BIO_NAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            this.pdbId = new PdbId(matcher.group(1));
            return true;
        }
        return false;
    }

    private boolean initFromPDB(String suffix) {
        this.mySource = Source.PDB;
        SubstructureIdentifier si = new SubstructureIdentifier(suffix);
        this.base = si;
        this.pdbId = si.getPdbId();
        Set<String> chains = StructureName.getChainNames(si);
        this.chainName = chains.size() == 1 ? chains.iterator().next() : (chains.size() > 1 ? "." : null);
        return true;
    }

    private boolean initFromURL(String suffix) {
        try {
            URL url = new URL(suffix);
            String path = url.getPath();
            this.mySource = Source.URL;
            try {
                this.pdbId = new PdbId(URLIdentifier.guessPDBID(path.substring(path.lastIndexOf(47) + 1)));
            }
            catch (IllegalArgumentException e) {
                this.pdbId = null;
            }
            this.chainName = null;
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private boolean initFromFile() {
        this.mySource = Source.FILE;
        this.pdbId = null;
        this.chainName = null;
        return true;
    }

    private static Set<String> getChainNames(SubstructureIdentifier si) {
        TreeSet<String> chains = new TreeSet<String>();
        List<ResidueRange> ranges = si.getResidueRanges();
        for (ResidueRange range : ranges) {
            String chainName = range.getChainName();
            if (chainName == null) continue;
            chains.add(chainName);
        }
        return chains;
    }

    public PdbId getPdbId() throws StructureException {
        if (this.pdbId == null) {
            this.pdbId = this.toCanonical().getPdbId();
        }
        return this.pdbId;
    }

    public String getChainId() {
        return this.chainName;
    }

    @Override
    public String getIdentifier() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isScopName() {
        return this.mySource == Source.SCOP;
    }

    public boolean isCathID() {
        return this.mySource == Source.CATH;
    }

    public boolean isPdbId() {
        return this.mySource == Source.PDB;
    }

    public boolean isURL() {
        return this.mySource == Source.URL;
    }

    public boolean isFile() {
        return this.mySource == Source.FILE;
    }

    public boolean isEcodDomain() {
        return this.mySource == Source.ECOD;
    }

    public boolean isBioAssembly() {
        return this.mySource == Source.BIO;
    }

    public Source getSource() {
        return this.mySource;
    }

    public StructureIdentifier getBaseIdentifier() throws StructureException {
        if (this.base == null) {
            switch (this.mySource) {
                case CATH: {
                    this.base = CathFactory.getCathDatabase().getDescriptionByCathId(this.getIdentifier());
                    break;
                }
                case ECOD: {
                    try {
                        this.base = EcodFactory.getEcodDatabase().getDomainsById(this.name);
                        break;
                    }
                    catch (IOException e) {
                        throw new StructureException("Unable to get ECOD domain " + this.name, e);
                    }
                }
                case SCOP: {
                    this.base = StructureName.guessScopDomain(this.getIdentifier(), ScopFactory.getSCOP());
                    if (this.base != null) break;
                    this.base = "_".equals(this.chainName) ? new SubstructureIdentifier(this.pdbId.getId()) : new SubstructureIdentifier(this.pdbId, ResidueRange.parseMultiple(this.chainName));
                    logger.error("Unable to find {}, so using {}", (Object)this.name, (Object)this.base);
                    break;
                }
                case FILE: {
                    try {
                        String[] prefix = this.name.split(":", 2);
                        String filename = prefix.length > 1 ? prefix[1] : this.name;
                        filename = FileDownloadUtils.expandUserHome((String)filename);
                        this.base = new URLIdentifier(new File(filename).toURI().toURL());
                        break;
                    }
                    catch (MalformedURLException e) {
                        throw new StructureException("Unable to get URL for file: " + this.name, e);
                    }
                }
                case URL: {
                    try {
                        this.base = new URLIdentifier(this.name);
                        break;
                    }
                    catch (MalformedURLException e) {
                        throw new StructureException("Invalid URL: " + this.name, e);
                    }
                }
                case BIO: {
                    this.base = new BioAssemblyIdentifier(this.name);
                    break;
                }
                case PDB: {
                    this.base = new SubstructureIdentifier(this.getIdentifier());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unimplemented source: " + this.mySource);
                }
            }
        }
        return this.base;
    }

    @Override
    public SubstructureIdentifier toCanonical() throws StructureException {
        return this.getBaseIdentifier().toCanonical();
    }

    @Override
    public Structure reduce(Structure input) throws StructureException {
        return this.getBaseIdentifier().reduce(input);
    }

    @Override
    public Structure loadStructure(AtomCache cache) throws StructureException, IOException {
        return this.getBaseIdentifier().loadStructure(cache);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureName other = (StructureName)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(StructureName o) {
        if (this.equals(o)) {
            return 0;
        }
        PdbId pdb1 = null;
        PdbId pdb2 = null;
        try {
            pdb1 = this.getPdbId();
        }
        catch (StructureException structureException) {
            // empty catch block
        }
        try {
            pdb2 = this.getPdbId();
        }
        catch (StructureException structureException) {
            // empty catch block
        }
        int comp = 0;
        if (pdb1 == null) {
            if (pdb2 != null) {
                return 1;
            }
        } else {
            if (pdb2 == null) {
                return -1;
            }
            comp = pdb1.compareTo(pdb2);
        }
        if (comp != 0) {
            return comp;
        }
        String pdb1Str = this.getIdentifier();
        String pdb2Str = o.getIdentifier();
        return pdb1Str.compareTo(pdb2Str);
    }

    public static ScopDomain guessScopDomain(String name, ScopDatabase scopDB) {
        Iterator match;
        LinkedList<ScopDomain> matches = new LinkedList<ScopDomain>();
        ScopDomain domain = scopDB.getDomainByScopID(name);
        if (domain != null) {
            return domain;
        }
        logger.warn("Warning, could not find SCOP domain: " + name);
        Matcher scopMatch = scopPattern.matcher(name);
        if (scopMatch.matches()) {
            String pdbID = scopMatch.group(1);
            String chainName = scopMatch.group(2);
            String domainID = scopMatch.group(3);
            for (ScopDomain potentialSCOP : scopDB.getDomainsForPDB(pdbID)) {
                Matcher potMatch = scopPattern.matcher(potentialSCOP.getScopId());
                if (!potMatch.matches() || !chainName.equals(potMatch.group(2)) && !"_".equals(chainName) && !".".equals(chainName) && !"_".equals(potMatch.group(2)) && !".".equals(potMatch.group(2)) || !domainID.equals(potMatch.group(3)) && !"_".equals(domainID) && !"_".equals(potMatch.group(3))) continue;
                matches.add(potentialSCOP);
            }
        }
        if ((match = matches.iterator()).hasNext()) {
            ScopDomain bestMatch = (ScopDomain)match.next();
            if (logger.isWarnEnabled()) {
                StringBuilder warnMsg = new StringBuilder();
                warnMsg.append("Trying domain " + bestMatch.getScopId() + ".");
                if (match.hasNext()) {
                    warnMsg.append(" Other possibilities: ");
                    while (match.hasNext()) {
                        warnMsg.append(((ScopDomain)match.next()).getScopId()).append(" ");
                    }
                }
                warnMsg.append(System.getProperty("line.separator"));
                logger.warn(warnMsg.toString());
            }
            return bestMatch;
        }
        return null;
    }

    public static enum Source {
        PDB,
        SCOP,
        CATH,
        URL,
        FILE,
        ECOD,
        BIO;

    }
}

