/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat.calc;

import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.fatcat.calc.AFPChainer;
import org.biojava.nbio.structure.align.fatcat.calc.FatCatParameters;
import org.biojava.nbio.structure.align.fatcat.calc.StructureAlignmentOptimizer;
import org.biojava.nbio.structure.align.model.AFP;
import org.biojava.nbio.structure.align.model.AFPChain;

public class AFPOptimizer {
    public static final boolean debug = false;

    public static void optimizeAln(FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        int i;
        int minLen = afpChain.getMinLen();
        int fragLen = params.getFragLen();
        long optStart = System.currentTimeMillis();
        int[][] iniSet = new int[2][minLen];
        int maxi = 100;
        int[][][] optAln = afpChain.getOptAln();
        int[] optLen = afpChain.getOptLen();
        int maxTra = params.getMaxTra();
        double[] optRmsd = afpChain.getOptRmsd();
        int blockNum = afpChain.getBlockNum();
        if (optAln == null) {
            optAln = new int[maxTra + 1][2][minLen];
            optLen = new int[maxTra + 1];
            afpChain.setOptLen(optLen);
            optRmsd = new double[maxTra + 1];
            afpChain.setOptRmsd(optRmsd);
        }
        List<AFP> afpSet = afpChain.getAfpSet();
        int optLength = afpChain.getOptLength();
        int[] afpChainList = afpChain.getAfpChainList();
        int[] block2Afp = afpChain.getBlock2Afp();
        int[] blockSize = afpChain.getBlockSize();
        optLength = 0;
        int e2 = 0;
        int e1 = 0;
        int b2 = 0;
        int b1 = 0;
        for (int bk = 0; bk < blockNum; ++bk) {
            int iniLen = 0;
            if (bk > 0) {
                b1 = e1;
                b2 = e2;
            }
            if (bk < blockNum - 1) {
                int a1 = afpChainList[block2Afp[bk] + blockSize[bk] - 1];
                int a2 = afpChainList[block2Afp[bk + 1]];
                e1 = (afpSet.get(a1).getP1() + fragLen + afpSet.get(a2).getP1()) / 2;
                e2 = (afpSet.get(a1).getP2() + fragLen + afpSet.get(a2).getP2()) / 2;
            } else {
                e1 = ca1.length;
                e2 = ca2.length;
            }
            for (i = block2Afp[bk]; i < block2Afp[bk] + blockSize[bk]; ++i) {
                int a = afpChainList[i];
                int p1 = afpSet.get(a).getP1();
                int p2 = afpSet.get(a).getP2();
                for (int k = 0; k < afpSet.get(a).getFragLen(); ++k) {
                    iniSet[0][iniLen] = p1 + k - b1;
                    iniSet[1][iniLen] = p2 + k - b2;
                    ++iniLen;
                }
            }
            StructureAlignmentOptimizer opt = new StructureAlignmentOptimizer(b1, e1, ca1, b2, e2, ca2, iniLen, iniSet);
            opt.runOptimization(maxi);
            optRmsd[bk] = opt.optimizeResult(optLen, bk, optAln[bk]);
            i = 0;
            while (i < optLen[bk]) {
                int[] nArray = optAln[bk][0];
                int n = i;
                nArray[n] = nArray[n] + b1;
                int[] nArray2 = optAln[bk][1];
                int n2 = i++;
                nArray2[n2] = nArray2[n2] + b2;
            }
            optLength += optLen[bk];
        }
        long optEnd = System.currentTimeMillis();
        if (optLength < minLen) {
            int[][][] optAln_trim = new int[maxTra + 1][2][optLength];
            for (i = 0; i < maxTra + 1; ++i) {
                System.arraycopy(optAln[i][0], 0, optAln_trim[i][0], 0, optLength);
                System.arraycopy(optAln[i][1], 0, optAln_trim[i][1], 0, optLength);
            }
            afpChain.setOptAln(optAln_trim);
        } else {
            afpChain.setOptAln(optAln);
        }
        afpChain.setBlockNum(blockNum);
        afpChain.setOptLength(optLength);
        afpChain.setAfpChainList(afpChainList);
        afpChain.setBlock2Afp(block2Afp);
        afpChain.setBlockSize(blockSize);
    }

    public static void blockInfo(AFPChain afpChain) {
        int blockNum = afpChain.getBlockNum();
        int[] blockSize = afpChain.getBlockSize();
        int[] afpChainList = afpChain.getAfpChainList();
        int[] block2Afp = afpChain.getBlock2Afp();
        int[][][] blockResList = afpChain.getBlockResList();
        List<AFP> afpSet = afpChain.getAfpSet();
        int[] blockResSize = afpChain.getBlockResSize();
        for (int i = 0; i < blockNum; ++i) {
            int n = 0;
            for (int j = 0; j < blockSize[i]; ++j) {
                int a = afpChainList[block2Afp[i] + j];
                for (int k = 0; k < afpSet.get(a).getFragLen(); ++k) {
                    blockResList[i][0][n] = afpSet.get(a).getP1() + k;
                    blockResList[i][1][n] = afpSet.get(a).getP2() + k;
                    ++n;
                }
            }
            blockResSize[i] = n;
        }
        afpChain.setBlockResSize(blockResSize);
        afpChain.setBlockSize(blockSize);
        afpChain.setAfpChainList(afpChainList);
        afpChain.setBlock2Afp(block2Afp);
        afpChain.setBlockResList(blockResList);
    }

    public static void updateScore(FatCatParameters params, AFPChain afpChain) {
        afpChain.setConn(0.0);
        afpChain.setDVar(0.0);
        int blockNum = afpChain.getBlockNum();
        int alignScoreUpdate = 0;
        double[] blockScore = afpChain.getBlockScore();
        int[] blockGap = afpChain.getBlockGap();
        int[] blockSize = afpChain.getBlockSize();
        int[] afpChainList = afpChain.getAfpChainList();
        List<AFP> afpSet = afpChain.getAfpSet();
        int[] block2Afp = afpChain.getBlock2Afp();
        double torsionPenalty = params.getTorsionPenalty();
        int bkold = 0;
        for (int i = 0; i < blockNum; ++i) {
            blockScore[i] = 0.0;
            blockGap[i] = 0;
            for (int j = 0; j < blockSize[i]; ++j) {
                int bknow = afpChainList[block2Afp[i] + j];
                if (j == 0) {
                    blockScore[i] = afpSet.get(bknow).getScore();
                } else {
                    AFPChainer.afpPairConn(bkold, bknow, params, afpChain);
                    Double conn = afpChain.getConn();
                    int n = i;
                    blockScore[n] = blockScore[n] + (afpSet.get(bknow).getScore() + conn);
                    int g1 = afpSet.get(bknow).getP1() - afpSet.get(bkold).getP1() - afpSet.get(bkold).getFragLen();
                    int g2 = afpSet.get(bknow).getP2() - afpSet.get(bkold).getP2() - afpSet.get(bkold).getFragLen();
                    int n2 = i;
                    blockGap[n2] = blockGap[n2] + (g1 > g2 ? g1 : g2);
                }
                bkold = bknow;
            }
            alignScoreUpdate = (int)((double)alignScoreUpdate + blockScore[i]);
        }
        if (blockNum >= 2) {
            alignScoreUpdate = (int)((double)alignScoreUpdate + (double)(blockNum - 1) * torsionPenalty);
        }
        afpChain.setBlockGap(blockGap);
        afpChain.setAlignScoreUpdate(alignScoreUpdate);
        afpChain.setBlockScore(blockScore);
        afpChain.setBlockSize(blockSize);
        afpChain.setAfpChainList(afpChainList);
        afpChain.setBlock2Afp(block2Afp);
    }
}

