/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.MultipleSequenceAlignment;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.phylo.DistanceMatrixCalculator;
import org.biojava.nbio.phylo.TreeConstructor;
import org.biojava.nbio.phylo.TreeConstructorType;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentScorer;
import org.biojava.nbio.structure.align.util.AlignmentTools;
import org.biojava.nbio.structure.jama.Matrix;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.phylogeny.Phylogeny;

public class MultipleAlignmentTools {
    public static List<String> getSequenceAlignment(MultipleAlignment alignment, List<Integer> mapSeqToStruct) {
        int i;
        ArrayList<String> alnSequences = new ArrayList<String>();
        for (int str = 0; str < alignment.size(); ++str) {
            alnSequences.add("");
        }
        mapSeqToStruct.clear();
        List<Atom[]> atoms = alignment.getAtomArrays();
        int globalPos = -1;
        ArrayList freePool = new ArrayList();
        ArrayList blockStarts = new ArrayList();
        ArrayList aligned = new ArrayList();
        for (i = 0; i < alignment.size(); ++i) {
            ArrayList<Integer> residues = new ArrayList<Integer>();
            freePool.add(new TreeSet());
            blockStarts.add(new TreeSet());
            for (BlockSet bs : alignment.getBlockSets()) {
                for (Block b : bs.getBlocks()) {
                    boolean first = true;
                    for (int l = 0; l < b.length(); ++l) {
                        Integer residue = b.getAlignRes().get(i).get(l);
                        if (residue == null) continue;
                        if (first) {
                            ((SortedSet)blockStarts.get(i)).add(residue);
                        }
                        residues.add(residue);
                        first = false;
                    }
                }
            }
            aligned.add(residues);
        }
        for (i = 0; i < alignment.size(); ++i) {
            for (int k = 0; k < atoms.get(i).length; ++k) {
                if (((List)aligned.get(i)).contains(k)) continue;
                ((SortedSet)freePool.get(i)).add(k);
            }
        }
        for (int b = 0; b < alignment.getBlocks().size(); ++b) {
            if (b != 0) {
                for (int str = 0; str < alignment.size(); ++str) {
                    alnSequences.set(str, ((String)alnSequences.get(str)).concat("-"));
                }
                mapSeqToStruct.add(-1);
            }
            int[] previousPos = new int[alignment.size()];
            Arrays.fill(previousPos, -1);
            char[] provisionalChar = new char[alignment.size()];
            Arrays.fill(provisionalChar, '-');
            for (int pos = 0; pos < alignment.getBlocks().get(b).length(); ++pos) {
                ++globalPos;
                boolean gaps = true;
                while (gaps) {
                    int str;
                    gaps = false;
                    for (str = 0; str < alignment.size(); ++str) {
                        Atom a;
                        Integer residue;
                        if (previousPos[str] == -1) {
                            residue = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                            if (residue == null) {
                                provisionalChar[str] = 45;
                                continue;
                            }
                            Atom a2 = atoms.get(str)[residue];
                            String group = a2.getGroup().getPDBName();
                            provisionalChar[str] = StructureTools.get1LetterCode(group).charValue();
                            continue;
                        }
                        residue = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                        int nextPos = previousPos[str] + 1;
                        if (residue == null) {
                            if (((SortedSet)freePool.get(str)).contains(nextPos)) {
                                a = atoms.get(str)[nextPos];
                                String g = a.getGroup().getPDBName();
                                char aa = StructureTools.get1LetterCode(g).charValue();
                                provisionalChar[str] = Character.toLowerCase(aa);
                                continue;
                            }
                            provisionalChar[str] = 45;
                            continue;
                        }
                        if (nextPos == residue) {
                            a = atoms.get(str)[nextPos];
                            String group = a.getGroup().getPDBName();
                            provisionalChar[str] = StructureTools.get1LetterCode(group).charValue();
                            continue;
                        }
                        provisionalChar[str] = 32;
                        gaps = true;
                    }
                    if (gaps) {
                        for (str = 0; str < alignment.size(); ++str) {
                            if (provisionalChar[str] == ' ') {
                                Atom a = atoms.get(str)[previousPos[str] + 1];
                                String group = a.getGroup().getPDBName();
                                char aa = StructureTools.get1LetterCode(group).charValue();
                                alnSequences.set(str, ((String)alnSequences.get(str)).concat(String.valueOf(Character.toLowerCase(aa))));
                                int n = str;
                                previousPos[n] = previousPos[n] + 1;
                                continue;
                            }
                            alnSequences.set(str, ((String)alnSequences.get(str)).concat("-"));
                        }
                        mapSeqToStruct.add(-1);
                        continue;
                    }
                    for (str = 0; str < alignment.size(); ++str) {
                        alnSequences.set(str, ((String)alnSequences.get(str)).concat(String.valueOf(provisionalChar[str])));
                        if (provisionalChar[str] == '-') continue;
                        if (alignment.getBlocks().get(b).getAlignRes().get(str).get(pos) == null) {
                            int n = str;
                            previousPos[n] = previousPos[n] + 1;
                            continue;
                        }
                        previousPos[str] = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                    }
                    mapSeqToStruct.add(globalPos);
                }
            }
            int[] blockEnds = new int[alignment.size()];
            block14: for (int str = 0; str < alignment.size(); ++str) {
                Iterator str2 = ((SortedSet)blockStarts.get(str)).iterator();
                while (str2.hasNext()) {
                    int res = (Integer)str2.next();
                    if (previousPos[str] > res) {
                        blockEnds[str] = res;
                        continue;
                    }
                    blockEnds[str] = res;
                    continue block14;
                }
            }
            boolean allGaps = false;
            while (!allGaps) {
                int str;
                allGaps = true;
                for (str = 0; str < alignment.size(); ++str) {
                    if (previousPos[str] + 1 < blockEnds[str]) {
                        Atom a = atoms.get(str)[previousPos[str] + 1];
                        String group = a.getGroup().getPDBName();
                        char letter = StructureTools.get1LetterCode(group).charValue();
                        provisionalChar[str] = Character.toLowerCase(letter);
                        int n = str;
                        previousPos[n] = previousPos[n] + 1;
                        allGaps = false;
                        continue;
                    }
                    provisionalChar[str] = 45;
                }
                if (allGaps) continue;
                for (str = 0; str < alignment.size(); ++str) {
                    alnSequences.set(str, ((String)alnSequences.get(str)).concat(String.valueOf(provisionalChar[str])));
                }
                mapSeqToStruct.add(-1);
            }
        }
        return alnSequences;
    }

    public static List<String> getSequenceAlignment(MultipleAlignment msa) {
        return MultipleAlignmentTools.getSequenceAlignment(msa, new ArrayList<Integer>());
    }

    public static List<String> getBlockSequenceAlignment(MultipleAlignment alignment, List<Integer> mapSeqToStruct) {
        ArrayList<String> alnSequences = new ArrayList<String>();
        for (int str = 0; str < alignment.size(); ++str) {
            alnSequences.add("");
        }
        mapSeqToStruct.clear();
        List<Atom[]> atoms = alignment.getAtomArrays();
        int globalPos = -1;
        for (int b = 0; b < alignment.getBlocks().size(); ++b) {
            if (b != 0) {
                for (int str = 0; str < alignment.size(); ++str) {
                    alnSequences.set(str, ((String)alnSequences.get(str)).concat("-"));
                }
                mapSeqToStruct.add(-1);
            }
            int[] previousPos = new int[alignment.size()];
            Arrays.fill(previousPos, -1);
            char[] provisionalChar = new char[alignment.size()];
            Arrays.fill(provisionalChar, '-');
            for (int pos = 0; pos < alignment.getBlocks().get(b).length(); ++pos) {
                ++globalPos;
                boolean gaps = true;
                while (gaps) {
                    int str;
                    gaps = false;
                    for (str = 0; str < alignment.size(); ++str) {
                        char aa;
                        String g;
                        Atom a;
                        Integer residue;
                        if (previousPos[str] == -1) {
                            residue = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                            if (residue == null) {
                                provisionalChar[str] = 45;
                                continue;
                            }
                            a = atoms.get(str)[residue];
                            g = a.getGroup().getPDBName();
                            provisionalChar[str] = aa = StructureTools.get1LetterCode(g).charValue();
                            continue;
                        }
                        residue = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                        if (residue == null) {
                            provisionalChar[str] = 45;
                            continue;
                        }
                        if (previousPos[str] + 1 == residue) {
                            a = atoms.get(str)[residue];
                            g = a.getGroup().getPDBName();
                            provisionalChar[str] = aa = StructureTools.get1LetterCode(g).charValue();
                            continue;
                        }
                        provisionalChar[str] = 32;
                        gaps = true;
                    }
                    if (gaps) {
                        for (str = 0; str < alignment.size(); ++str) {
                            if (provisionalChar[str] != ' ') continue;
                            for (int s2 = 0; s2 < alignment.size(); ++s2) {
                                if (str == s2) {
                                    int next = previousPos[str] + 1;
                                    Atom a = atoms.get(s2)[next];
                                    String g = a.getGroup().getPDBName();
                                    char aa = StructureTools.get1LetterCode(g).charValue();
                                    alnSequences.set(s2, ((String)alnSequences.get(s2)).concat(String.valueOf(aa)));
                                    continue;
                                }
                                alnSequences.set(s2, ((String)alnSequences.get(s2)).concat("-"));
                            }
                            mapSeqToStruct.add(-1);
                            int n = str;
                            previousPos[n] = previousPos[n] + 1;
                        }
                        continue;
                    }
                    for (str = 0; str < alignment.size(); ++str) {
                        alnSequences.set(str, ((String)alnSequences.get(str)).concat(String.valueOf(provisionalChar[str])));
                        if (provisionalChar[str] == '-') continue;
                        previousPos[str] = alignment.getBlocks().get(b).getAlignRes().get(str).get(pos);
                    }
                    mapSeqToStruct.add(globalPos);
                }
            }
        }
        return alnSequences;
    }

    public static List<String> getBlockSequenceAlignment(MultipleAlignment ma) {
        return MultipleAlignmentTools.getBlockSequenceAlignment(ma, new ArrayList<Integer>());
    }

    public static Atom getAtomForSequencePosition(MultipleAlignment msa, List<Integer> mapSeqToStruct, int str, int sequencePos) {
        int seqPos = mapSeqToStruct.get(sequencePos);
        if (seqPos == -1) {
            return null;
        }
        Atom a = null;
        int sum = 0;
        block0: for (Block b : msa.getBlocks()) {
            if (sum + b.length() <= seqPos) {
                sum += b.length();
                continue;
            }
            for (Integer p : b.getAlignRes().get(str)) {
                if (sum == seqPos) {
                    if (p == null) break block0;
                    a = msa.getAtomArrays().get(str)[p];
                    break block0;
                }
                ++sum;
            }
        }
        return a;
    }

    public static int getBlockForSequencePosition(MultipleAlignment multAln, List<Integer> mapSeqToStruct, int sequencePos) {
        int seqPos = mapSeqToStruct.get(sequencePos);
        if (seqPos == -1) {
            return -1;
        }
        int sum = 0;
        int block = 0;
        for (Block b : multAln.getBlocks()) {
            if (sum + b.length() > seqPos) break;
            sum += b.length();
            ++block;
        }
        return block;
    }

    public static Matrix getAverageResidueDistances(MultipleAlignment msa) {
        List<Atom[]> transformed = MultipleAlignmentTools.transformAtoms(msa);
        return MultipleAlignmentTools.getAverageResidueDistances(transformed);
    }

    public static Matrix getAverageResidueDistances(List<Atom[]> transformed) {
        int size = transformed.size();
        int length = transformed.get(0).length;
        Matrix resDist = new Matrix(size, length, -1.0);
        for (int r1 = 0; r1 < size; ++r1) {
            for (int c = 0; c < transformed.get(r1).length; ++c) {
                Atom refAtom = transformed.get(r1)[c];
                if (refAtom == null) continue;
                for (int r2 = r1 + 1; r2 < size; ++r2) {
                    Atom atom = transformed.get(r2)[c];
                    if (atom == null) continue;
                    double distance = Calc.getDistance(refAtom, atom);
                    if (resDist.get(r1, c) == -1.0) {
                        resDist.set(r1, c, 1.0 + distance);
                    } else {
                        resDist.set(r1, c, resDist.get(r1, c) + distance);
                    }
                    if (resDist.get(r2, c) == -1.0) {
                        resDist.set(r2, c, 1.0 + distance);
                        continue;
                    }
                    resDist.set(r2, c, resDist.get(r2, c) + distance);
                }
            }
        }
        for (int c = 0; c < length; ++c) {
            int r;
            int nonNullRes = 0;
            for (r = 0; r < size; ++r) {
                if (resDist.get(r, c) == -1.0) continue;
                ++nonNullRes;
            }
            for (r = 0; r < size; ++r) {
                if (resDist.get(r, c) == -1.0) continue;
                resDist.set(r, c, resDist.get(r, c) / (double)nonNullRes);
            }
        }
        return resDist;
    }

    public static List<Atom[]> transformAtoms(MultipleAlignment alignment) {
        if (alignment.getEnsemble() == null) {
            throw new NullPointerException("No ensemble set for this alignment");
        }
        List<Atom[]> atomArrays = alignment.getAtomArrays();
        ArrayList<Atom[]> transformed = new ArrayList<Atom[]>(atomArrays.size());
        for (int i = 0; i < atomArrays.size(); ++i) {
            Matrix4d transform = null;
            Atom[] curr = atomArrays.get(i);
            Atom[] transformedAtoms = new Atom[alignment.length()];
            int transformedAtomsLength = 0;
            for (BlockSet bs : alignment.getBlockSets()) {
                Atom[] blocksetAtoms = new Atom[bs.length()];
                int blockPos = 0;
                for (Block blk : bs.getBlocks()) {
                    if (blk.size() != atomArrays.size()) {
                        throw new IllegalStateException(String.format("Mismatched block size. Expected %d structures, found %d.", atomArrays.size(), blk.size()));
                    }
                    for (int j = 0; j < blk.length(); ++j) {
                        Integer alignedPos = blk.getAlignRes().get(i).get(j);
                        if (alignedPos != null) {
                            blocksetAtoms[blockPos] = (Atom)curr[alignedPos].clone();
                        }
                        ++blockPos;
                    }
                }
                Matrix4d blockTrans = null;
                if (bs.getTransformations() != null) {
                    blockTrans = bs.getTransformations().get(i);
                }
                if (blockTrans == null) {
                    blockTrans = transform;
                }
                for (Atom a : blocksetAtoms) {
                    if (a != null) {
                        Calc.transform(a, blockTrans);
                    }
                    transformedAtoms[transformedAtomsLength] = a;
                    ++transformedAtomsLength;
                }
            }
            assert (transformedAtomsLength == alignment.length());
            transformed.add(transformedAtoms);
        }
        return transformed;
    }

    public static List<Integer> getCorePositions(Block block) {
        ArrayList<Integer> corePositions = new ArrayList<Integer>();
        for (int col = 0; col < block.length(); ++col) {
            boolean core = true;
            for (int str = 0; str < block.size(); ++str) {
                if (block.getAlignRes().get(str).get(col) != null) continue;
                core = false;
                break;
            }
            if (!core) continue;
            corePositions.add(col);
        }
        return corePositions;
    }

    public static void sortBlocks(List<Block> blocks, final int sortedIndex) {
        Collections.sort(blocks, new Comparator<Block>(){

            @Override
            public int compare(Block o1, Block o2) {
                List<Integer> alignres1 = o1.getAlignRes().get(sortedIndex);
                List<Integer> alignres2 = o2.getAlignRes().get(sortedIndex);
                Integer res1 = null;
                Integer res2 = null;
                for (Integer r : alignres1) {
                    if (r == null) continue;
                    res1 = r;
                    break;
                }
                for (Integer r : alignres2) {
                    if (r == null) continue;
                    res2 = r;
                    break;
                }
                return res1.compareTo(res2);
            }
        });
    }

    public static MultipleSequenceAlignment<ProteinSequence, AminoAcidCompound> toProteinMSA(MultipleAlignment msta) throws CompoundNotFoundException {
        Group g = msta.getAtomArrays().get(0)[0].getGroup();
        if (!(g instanceof AminoAcid)) {
            throw new IllegalArgumentException("Cannot convert to multiple sequence alignment: the structures aligned are not proteins");
        }
        MultipleSequenceAlignment msa = new MultipleSequenceAlignment();
        HashMap<String, Integer> uniqueID = new HashMap<String, Integer>();
        List<String> seqs = MultipleAlignmentTools.getSequenceAlignment(msta);
        for (int i = 0; i < msta.size(); ++i) {
            Object id = msta.getStructureIdentifier(i).toString();
            if (uniqueID.containsKey(id)) {
                uniqueID.put((String)id, (Integer)uniqueID.get(id) + 1);
                id = (String)id + "_" + String.valueOf(uniqueID.get(id));
            } else {
                uniqueID.put((String)id, 1);
            }
            AccessionID acc = new AccessionID((String)id);
            ProteinSequence pseq = new ProteinSequence(seqs.get(i));
            pseq.setAccession(acc);
            msa.addAlignedSequence((Sequence)pseq);
        }
        return msa;
    }

    public static Structure toMultimodelStructure(MultipleAlignment multAln, List<Atom[]> transformedAtoms) throws StructureException {
        PDBHeader header = new PDBHeader();
        String title = multAln.getEnsemble().getAlgorithmName() + " V." + multAln.getEnsemble().getVersion() + " : ";
        for (StructureIdentifier name : multAln.getEnsemble().getStructureIdentifiers()) {
            title = title + name.getIdentifier() + " ";
        }
        Structure artificial = MultipleAlignmentTools.getAlignedStructure(transformedAtoms);
        artificial.setPDBHeader(header);
        header.setTitle(title);
        return artificial;
    }

    public static final Structure getAlignedStructure(List<Atom[]> atomArrays) throws StructureException {
        StructureImpl s = new StructureImpl();
        for (int i = 0; i < atomArrays.size(); ++i) {
            List<Chain> model = AlignmentTools.getAlignedModel(atomArrays.get(i));
            s.addModel(model);
        }
        return s;
    }

    public static Matrix getRMSDMatrix(MultipleAlignment msa) {
        Matrix rmsdMat = new Matrix(msa.size(), msa.size());
        List<Atom[]> superposed = MultipleAlignmentTools.transformAtoms(msa);
        for (int i = 0; i < msa.size(); ++i) {
            for (int j = i; j < msa.size(); ++j) {
                if (i == j) {
                    rmsdMat.set(i, j, 0.0);
                }
                ArrayList<Atom[]> compared = new ArrayList<Atom[]>();
                compared.add(superposed.get(i));
                compared.add(superposed.get(j));
                double rmsd = MultipleAlignmentScorer.getRMSD(compared);
                rmsdMat.set(i, j, rmsd);
                rmsdMat.set(j, i, rmsd);
            }
        }
        return rmsdMat;
    }

    public static Phylogeny getKimuraTree(MultipleAlignment msta) throws CompoundNotFoundException, IOException {
        MultipleSequenceAlignment<ProteinSequence, AminoAcidCompound> msa = MultipleAlignmentTools.toProteinMSA(msta);
        BasicSymmetricalDistanceMatrix distmat = (BasicSymmetricalDistanceMatrix)DistanceMatrixCalculator.kimuraDistance(msa);
        Phylogeny tree = TreeConstructor.distanceTree((BasicSymmetricalDistanceMatrix)distmat, (TreeConstructorType)TreeConstructorType.NJ);
        tree.setName("Kimura Tree");
        return tree;
    }

    public static Phylogeny getHSDMTree(MultipleAlignment msta) throws CompoundNotFoundException, IOException {
        MultipleSequenceAlignment<ProteinSequence, AminoAcidCompound> msa = MultipleAlignmentTools.toProteinMSA(msta);
        BasicSymmetricalDistanceMatrix distmat = (BasicSymmetricalDistanceMatrix)DistanceMatrixCalculator.dissimilarityScore(msa, (SubstitutionMatrix)SubstitutionMatrixHelper.getAminoAcidSubstitutionMatrix((String)"PRLA000102"));
        Phylogeny tree = TreeConstructor.distanceTree((BasicSymmetricalDistanceMatrix)distmat, (TreeConstructorType)TreeConstructorType.NJ);
        tree.setName("HSDM Tree");
        return tree;
    }

    public static Phylogeny getStructuralTree(MultipleAlignment msta) {
        double[][] rmsdMat = MultipleAlignmentTools.getRMSDMatrix(msta).getArray();
        BasicSymmetricalDistanceMatrix rmsdDist = (BasicSymmetricalDistanceMatrix)DistanceMatrixCalculator.structuralDistance((double[][])rmsdMat, (double)1.0, (double)5.0, (double)0.4);
        HashMap<String, Integer> alreadySeen = new HashMap<String, Integer>();
        for (int i = 0; i < msta.size(); ++i) {
            Object id = msta.getStructureIdentifier(i).toString();
            if (alreadySeen.containsKey(id)) {
                alreadySeen.put((String)id, (Integer)alreadySeen.get(id) + 1);
                id = (String)id + "_" + String.valueOf(alreadySeen.get(id));
            } else {
                alreadySeen.put((String)id, 1);
            }
            rmsdDist.setIdentifier(i, (String)id);
        }
        Phylogeny tree = TreeConstructor.distanceTree((BasicSymmetricalDistanceMatrix)rmsdDist, (TreeConstructorType)TreeConstructorType.NJ);
        tree.setName("Structural Tree");
        return tree;
    }

    public static List<List<Integer>> getEquivalentResidues(MultipleAlignment msa, boolean coreOnly) {
        ArrayList<List<Integer>> eqr = new ArrayList<List<Integer>>();
        for (int str = 0; str < msa.size(); ++str) {
            eqr.add(new ArrayList());
        }
        for (Block block : msa.getBlocks()) {
            List<List<Integer>> aln = block.getAlignRes();
            for (int col = 0; col < block.length(); ++col) {
                if (coreOnly) {
                    boolean core = true;
                    for (int str = 0; str < block.size(); ++str) {
                        if (aln.get(str).get(col) != null) continue;
                        core = false;
                        break;
                    }
                    if (!core) continue;
                }
                for (int str = 0; str < block.size(); ++str) {
                    ((List)eqr.get(str)).add(aln.get(str).get(col));
                }
            }
        }
        return eqr;
    }
}

