/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.io.StringWriter;

public class ResidueNumber
implements Serializable,
Comparable<ResidueNumber> {
    private static final long serialVersionUID = 1773011704758536083L;
    private String chainName;
    private Character insCode;
    private Integer seqNum;

    public ResidueNumber() {
    }

    public ResidueNumber(ResidueNumber o) {
        this.chainName = o.chainName;
        this.insCode = o.insCode;
        this.seqNum = o.seqNum;
    }

    public ResidueNumber(String chainName, Integer residueNumber, Character insCode) {
        this.chainName = chainName;
        this.seqNum = residueNumber;
        this.insCode = insCode;
    }

    public String getChainName() {
        return this.chainName;
    }

    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    public Character getInsCode() {
        return this.insCode;
    }

    public void setInsCode(Character insCode) {
        this.insCode = insCode;
    }

    public Integer getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(Integer seqNum) {
        this.seqNum = seqNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResidueNumber other = (ResidueNumber)obj;
        if (this.chainName == null ? other.chainName != null : !this.chainName.equals(other.chainName)) {
            return false;
        }
        if (this.insCode == null ? other.insCode != null : !this.insCode.equals(other.insCode)) {
            return false;
        }
        return !(this.seqNum == null ? other.seqNum != null : !this.seqNum.equals(other.seqNum));
    }

    public boolean equalsPositional(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResidueNumber other = (ResidueNumber)obj;
        if (this.insCode == null ? other.insCode != null : !this.insCode.equals(other.insCode)) {
            return false;
        }
        return !(this.seqNum == null ? other.seqNum != null : !this.seqNum.equals(other.seqNum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chainName == null ? 0 : this.chainName.hashCode());
        result = 31 * result + (this.insCode == null ? 0 : this.insCode.hashCode());
        result = 31 * result + (this.seqNum == null ? 0 : this.seqNum.hashCode());
        return result;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.append(String.valueOf(this.seqNum));
        if (this.insCode != null && this.insCode.charValue() != ' ') {
            writer.append(this.insCode.charValue());
        }
        return writer.toString();
    }

    public String toPDB() {
        Object insCodeS = this.insCode != null ? "" + this.insCode : " ";
        return String.format("%s%4d%-2s", this.chainName, this.seqNum, insCodeS);
    }

    public static ResidueNumber fromString(String pdb_code) {
        String icode;
        Integer resNum;
        ResidueNumber residueNumber;
        block6: {
            if (pdb_code == null) {
                return null;
            }
            residueNumber = new ResidueNumber();
            resNum = null;
            icode = null;
            try {
                resNum = Integer.parseInt(pdb_code);
            }
            catch (NumberFormatException e) {
                String[] spl = pdb_code.split("(?<=\\d)(?=\\D)|(?<=\\D)(?=\\d)");
                if (spl.length != 2) break block6;
                resNum = Integer.parseInt(spl[0]);
                icode = spl[1];
            }
        }
        residueNumber.setSeqNum(resNum);
        if (icode == null) {
            residueNumber.setInsCode(null);
        } else if (icode.length() > 0) {
            residueNumber.setInsCode(Character.valueOf(icode.charAt(0)));
        }
        return residueNumber;
    }

    @Override
    public int compareTo(ResidueNumber other) {
        if (this.chainName != null && other.chainName != null && !this.chainName.equals(other.chainName)) {
            return this.chainName.compareTo(other.chainName);
        }
        if (this.chainName != null && other.chainName == null) {
            return 1;
        }
        if (this.chainName == null && other.chainName != null) {
            return -1;
        }
        return this.compareToPositional(other);
    }

    public int compareToPositional(ResidueNumber other) {
        if (this.seqNum != null && other.seqNum != null && !this.seqNum.equals(other.seqNum)) {
            return this.seqNum.compareTo(other.seqNum);
        }
        if (this.seqNum != null && other.seqNum == null) {
            return 1;
        }
        if (this.seqNum == null && other.seqNum != null) {
            return -1;
        }
        if (this.insCode != null && other.insCode != null && !this.insCode.equals(other.insCode)) {
            return this.insCode.compareTo(other.insCode);
        }
        if (this.insCode != null && other.insCode == null) {
            return 1;
        }
        if (this.insCode == null && other.insCode != null) {
            return -1;
        }
        return 0;
    }

    public String printFull() {
        String chain = this.chainName == null ? "" : this.chainName;
        return chain + "_" + this.toString();
    }
}

