/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Author;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.EntityType;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupIterator;
import org.biojava.nbio.structure.HetatomImpl;
import org.biojava.nbio.structure.JournalArticle;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Site;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.chem.ChemCompAtom;
import org.biojava.nbio.structure.chem.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.BondMaker;
import org.biojava.nbio.structure.io.CAConverter;
import org.biojava.nbio.structure.io.ChargeAdder;
import org.biojava.nbio.structure.io.EntityFinder;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.PDBBioAssemblyParser;
import org.biojava.nbio.structure.io.SSBondImpl;
import org.biojava.nbio.structure.io.SeqRes2AtomAligner;
import org.biojava.nbio.structure.io.util.PDBTemporaryStorageUtils;
import org.biojava.nbio.structure.secstruc.SecStrucInfo;
import org.biojava.nbio.structure.secstruc.SecStrucType;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.biojava.nbio.structure.xtal.SymoplibParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDBFileParser {
    private static final Logger logger = LoggerFactory.getLogger(PDBFileParser.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private String pdbId;
    private Structure structure = null;
    private List<List<Chain>> allModels;
    private List<Chain> currentModel = null;
    private Chain currentChain = null;
    private Group currentGroup = null;
    private List<Chain> seqResChains;
    private boolean isLegacyFormat = false;
    private boolean blankChainIdsPresent = false;
    private PDBBioAssemblyParser bioAssemblyParser = null;
    private PDBHeader pdbHeader;
    private PDBCrystallographicInfo crystallographicInfo;
    private JournalArticle journalArticle;
    private List<Map<String, Integer>> connects;
    private List<Map<String, String>> helixList;
    private List<Map<String, String>> strandList;
    private List<Map<String, String>> turnList;
    private int lengthCheck;
    private boolean isLastCompndLine = false;
    private boolean isLastSourceLine = false;
    private EntityInfo current_compound = null;
    private List<EntityInfo> entities = new ArrayList<EntityInfo>();
    private HashMap<Integer, List<String>> compoundMolIds2chainIds = new HashMap();
    private List<String> compndLines = new ArrayList<String>();
    private List<String> sourceLines = new ArrayList<String>();
    private List<String> journalLines = new ArrayList<String>();
    private List<String> keywordsLines = new ArrayList<String>();
    private List<DBRef> dbrefs;
    private Map<String, Site> siteMap = null;
    private Map<String, List<ResidueNumber>> siteToResidueMap = new LinkedHashMap<String, List<ResidueNumber>>();
    private List<SSBondImpl> ssbonds = new ArrayList<SSBondImpl>();
    private List<PDBTemporaryStorageUtils.LinkRecord> linkRecords;
    private Matrix4d currentNcsOp;
    private List<Matrix4d> ncsOperators;
    private int prevMolId;
    private String previousContinuationField;
    private String continuationField;
    private String continuationString;
    private DateFormat dateFormat;
    private float rfreeStandardLine = -1.0f;
    private float rfreeNoCutoffLine = -1.0f;
    private static final List<String> compndFieldValues = new ArrayList<String>(Arrays.asList("MOL_ID:", "MOLECULE:", "CHAIN:", "SYNONYM:", "EC:", "FRAGMENT:", "ENGINEERED:", "MUTATION:", "BIOLOGICAL_UNIT:", "OTHER_DETAILS:"));
    private static final List<String> ignoreCompndFieldValues = new ArrayList<String>(Arrays.asList("HETEROGEN:", "ENGINEEREED:", "FRAGMENT,", "MUTANT:", "SYNTHETIC:"));
    private static final List<String> sourceFieldValues = new ArrayList<String>(Arrays.asList("ENGINEERED:", "MOL_ID:", "SYNTHETIC:", "FRAGMENT:", "ORGANISM_SCIENTIFIC:", "ORGANISM_COMMON:", "ORGANISM_TAXID:", "STRAIN:", "VARIANT:", "CELL_LINE:", "ATCC:", "ORGAN:", "TISSUE:", "CELL:", "ORGANELLE:", "SECRETION:", "GENE:", "CELLULAR_LOCATION:", "EXPRESSION_SYSTEM:", "EXPRESSION_SYSTEM_TAXID:", "EXPRESSION_SYSTEM_STRAIN:", "EXPRESSION_SYSTEM_VARIANT:", "EXPRESSION_SYSTEM_CELL_LINE:", "EXPRESSION_SYSTEM_ATCC_NUMBER:", "EXPRESSION_SYSTEM_ORGAN:", "EXPRESSION_SYSTEM_TISSUE:", "EXPRESSION_SYSTEM_CELL:", "EXPRESSION_SYSTEM_ORGANELLE:", "EXPRESSION_SYSTEM_CELLULAR_LOCATION:", "EXPRESSION_SYSTEM_VECTOR_TYPE:", "EXPRESSION_SYSTEM_VECTOR:", "EXPRESSION_SYSTEM_PLASMID:", "EXPRESSION_SYSTEM_GENE:", "OTHER_DETAILS:"));
    private int atomCount = 0;
    private int atomCAThreshold;
    private int loadMaxAtoms;
    private boolean atomOverflow = false;
    private boolean parseCAonly = false;
    private FileParsingParameters params = new FileParsingParameters();
    private boolean startOfMolecule = true;
    private boolean startOfModel = true;
    Site site;
    private String[] keywords;

    public PDBFileParser() {
        this.allModels = new ArrayList<List<Chain>>();
        this.pdbHeader = new PDBHeader();
        this.crystallographicInfo = new PDBCrystallographicInfo();
        this.connects = new ArrayList<Map<String, Integer>>();
        this.helixList = new ArrayList<Map<String, String>>();
        this.strandList = new ArrayList<Map<String, String>>();
        this.turnList = new ArrayList<Map<String, String>>();
        this.dbrefs = new ArrayList<DBRef>();
        this.dateFormat = new SimpleDateFormat("dd-MMM-yy", Locale.US);
        this.loadMaxAtoms = this.params.getMaxAtoms();
        this.atomCAThreshold = this.params.getAtomCaThreshold();
        this.linkRecords = new ArrayList<PDBTemporaryStorageUtils.LinkRecord>();
    }

    private Group getNewGroup(String recordName, Character aminoCode1, String aminoCode3) {
        HetatomImpl group;
        Group g = ChemCompGroupFactory.getGroupFromChemCompDictionary(aminoCode3);
        if (g != null && !g.getChemComp().isEmpty()) {
            return g;
        }
        if (aminoCode1 == null || 'X' == aminoCode1.charValue()) {
            group = new HetatomImpl();
        } else if (StructureTools.isNucleotide(aminoCode3)) {
            NucleotideImpl nu = new NucleotideImpl();
            group = nu;
        } else {
            AminoAcidImpl aa = new AminoAcidImpl();
            aa.setAminoType(aminoCode1);
            group = aa;
        }
        return group;
    }

    private void pdb_HEADER_Handler(String line) {
        String classification = null;
        String deposition_date = null;
        String pdbCode = null;
        int len = line.trim().length();
        if (len > 10) {
            classification = line.substring(10, Math.min(len, 50)).trim();
            this.pdbHeader.setClassification(classification);
        }
        if (len > 50) {
            deposition_date = line.substring(50, Math.min(len, 59)).trim();
            try {
                Date dep = this.dateFormat.parse(deposition_date);
                this.pdbHeader.setDepDate(dep);
            }
            catch (ParseException e) {
                logger.info("Could not parse deposition date string '" + deposition_date + "'. Will continue without deposition date");
            }
        }
        if (len > 62) {
            PdbId pdbIdToSet;
            this.pdbId = pdbCode = line.substring(62, Math.min(len, 66)).trim();
            logger.debug("Parsing entry {}", (Object)this.pdbId);
            if (pdbCode.isBlank()) {
                pdbIdToSet = null;
            } else {
                try {
                    pdbIdToSet = new PdbId(pdbCode);
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Malformed PDB ID {}. setting PdbId to null", (Object)pdbCode);
                    pdbIdToSet = null;
                }
            }
            this.structure.setPdbId(pdbIdToSet);
            this.pdbHeader.setPdbId(pdbIdToSet);
        }
        if (len > 66 && this.pdbId.equals(line.substring(72, 76))) {
            this.isLegacyFormat = true;
            logger.warn(this.pdbId + " is a LEGACY entry - this will most likely not parse correctly.");
        }
    }

    private void pdb_AUTHOR_Handler(String line) {
        String authors = line.substring(10).trim();
        Object auth = this.pdbHeader.getAuthors();
        if (auth == null) {
            this.pdbHeader.setAuthors(authors);
        } else {
            auth = (String)auth + authors;
            this.pdbHeader.setAuthors((String)auth);
        }
    }

    private void pdb_HELIX_Handler(String line) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        if (line.length() < 38) {
            logger.info("HELIX line has length under 38. Ignoring it.");
            return;
        }
        String initResName = line.substring(15, 18).trim();
        String initChainId = line.substring(19, 20);
        String initSeqNum = line.substring(21, 25).trim();
        String initICode = line.substring(25, 26);
        String endResName = line.substring(27, 30).trim();
        String endChainId = line.substring(31, 32);
        String endSeqNum = line.substring(33, 37).trim();
        String endICode = line.substring(37, 38);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("initResName", initResName);
        m.put("initChainId", initChainId);
        m.put("initSeqNum", initSeqNum);
        m.put("initICode", initICode);
        m.put("endResName", endResName);
        m.put("endChainId", endChainId);
        m.put("endSeqNum", endSeqNum);
        m.put("endICode", endICode);
        this.helixList.add(m);
    }

    private void pdb_SHEET_Handler(String line) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        if (line.length() < 38) {
            logger.info("SHEET line has length under 38. Ignoring it.");
            return;
        }
        String initResName = line.substring(17, 20).trim();
        String initChainId = line.substring(21, 22);
        String initSeqNum = line.substring(22, 26).trim();
        String initICode = line.substring(26, 27);
        String endResName = line.substring(28, 31).trim();
        String endChainId = line.substring(32, 33);
        String endSeqNum = line.substring(33, 37).trim();
        String endICode = line.substring(37, 38);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("initResName", initResName);
        m.put("initChainId", initChainId);
        m.put("initSeqNum", initSeqNum);
        m.put("initICode", initICode);
        m.put("endResName", endResName);
        m.put("endChainId", endChainId);
        m.put("endSeqNum", endSeqNum);
        m.put("endICode", endICode);
        this.strandList.add(m);
    }

    private void pdb_TURN_Handler(String line) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        if (line.length() < 36) {
            logger.info("TURN line has length under 36. Ignoring it.");
            return;
        }
        String initResName = line.substring(15, 18).trim();
        String initChainId = line.substring(19, 20);
        String initSeqNum = line.substring(20, 24).trim();
        String initICode = line.substring(24, 25);
        String endResName = line.substring(26, 29).trim();
        String endChainId = line.substring(30, 31);
        String endSeqNum = line.substring(31, 35).trim();
        String endICode = line.substring(35, 36);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("initResName", initResName);
        m.put("initChainId", initChainId);
        m.put("initSeqNum", initSeqNum);
        m.put("initICode", initICode);
        m.put("endResName", endResName);
        m.put("endChainId", endChainId);
        m.put("endSeqNum", endSeqNum);
        m.put("endICode", endICode);
        this.turnList.add(m);
    }

    private void pdb_REVDAT_Handler(String line) {
        Date modDate = this.pdbHeader.getModDate();
        if (modDate == null || modDate.equals(new Date(0L))) {
            String modificationDate = line.substring(13, 22).trim();
            try {
                Date dep = this.dateFormat.parse(modificationDate);
                this.pdbHeader.setModDate(dep);
                this.pdbHeader.setRelDate(dep);
            }
            catch (ParseException e) {
                logger.info("Could not parse revision date string '" + modificationDate + "'. ");
            }
        } else {
            String releaseDate = line.substring(13, 22).trim();
            try {
                Date dep = this.dateFormat.parse(releaseDate);
                this.pdbHeader.setRelDate(dep);
            }
            catch (ParseException e) {
                logger.info("Could not parse revision date string '" + releaseDate + "'. ");
            }
        }
    }

    private void pdb_SEQRES_Handler(String line) {
        String recordName = line.substring(0, 6).trim();
        String chainID = line.substring(11, 12);
        String newLength = line.substring(13, 17).trim();
        String subSequence = line.substring(18);
        if (this.lengthCheck == -1) {
            this.lengthCheck = Integer.parseInt(newLength);
        }
        StringTokenizer subSequenceResidues = new StringTokenizer(subSequence);
        Character aminoCode1 = null;
        if (!recordName.equals("SEQRES")) {
            return;
        }
        this.currentChain = PDBFileParser.isKnownChain(chainID, this.seqResChains);
        if (this.currentChain == null) {
            this.currentChain = new ChainImpl();
            this.currentChain.setId(chainID);
            this.currentChain.setName(chainID);
        }
        while (subSequenceResidues.hasMoreTokens()) {
            String threeLetter = subSequenceResidues.nextToken();
            aminoCode1 = StructureTools.get1LetterCode(threeLetter);
            this.currentGroup = this.getNewGroup("ATOM", aminoCode1, threeLetter);
            this.currentGroup.setPDBName(threeLetter);
            if (this.currentGroup instanceof AminoAcid) {
                AminoAcid aa = (AminoAcid)this.currentGroup;
                aa.setRecordType("SEQRES");
            }
            this.currentChain.addGroup(this.currentGroup);
        }
        Chain test = PDBFileParser.isKnownChain(chainID, this.seqResChains);
        if (test == null) {
            this.seqResChains.add(this.currentChain);
        }
        if (this.currentGroup != null) {
            this.currentGroup.trimToSize();
        }
        this.currentGroup = null;
        this.currentChain = null;
        this.lengthCheck = Integer.parseInt(newLength);
    }

    private void pdb_TITLE_Handler(String line) {
        String title = line.length() > 79 ? line.substring(10, 80).trim() : line.substring(10, line.length()).trim();
        Object t = this.pdbHeader.getTitle();
        t = t != null && !"".equals(t) ? (((String)t).endsWith("-") ? (String)t : (String)t + " ") : "";
        t = (String)t + title;
        this.pdbHeader.setTitle((String)t);
    }

    private void pdb_JRNL_Handler(String line) {
        if (line.substring(line.length() - 8, line.length() - 4).equals(this.pdbId)) {
            logger.debug("trimming legacy PDB id from end of JRNL section line");
            line = line.substring(0, line.length() - 8);
            this.journalLines.add(line);
        } else {
            this.journalLines.add(line);
        }
    }

    private void pdb_COMPND_Handler(String line) {
        String[] fieldList;
        int fl;
        logger.debug("previousContinuationField  is {}", (Object)this.previousContinuationField);
        logger.debug("current continuationField  is {}", (Object)this.continuationField);
        logger.debug("current continuationString is {}", (Object)this.continuationString);
        logger.debug("current compound           is {}", (Object)this.current_compound);
        if (this.isLegacyFormat) {
            line = line.substring(0, 72);
        }
        if ((fl = (fieldList = (line = line.substring(10, line.length())).trim().split("\\s+")).length) > 0) {
            String field0 = fieldList[0];
            if (compndFieldValues.contains(field0)) {
                this.continuationField = field0;
                if ("".equals(this.previousContinuationField)) {
                    this.previousContinuationField = this.continuationField;
                }
            } else if (field0.endsWith(";") && compndFieldValues.contains(field0.substring(0, field0.length() - 1))) {
                logger.info("COMPND line does not follow the PDB 3.0 format. Note that COMPND parsing is not supported any longer in format 2.3 or earlier");
                return;
            }
        }
        line = line.replace(this.continuationField, "").trim();
        StringTokenizer compndTokens = new StringTokenizer(line);
        while (compndTokens.hasMoreTokens()) {
            String token = compndTokens.nextToken();
            if ("".equals(this.previousContinuationField)) {
                this.previousContinuationField = this.continuationField;
            }
            if (this.previousContinuationField.equals(this.continuationField) && compndFieldValues.contains(this.continuationField)) {
                logger.debug("Still in field {}", (Object)this.continuationField);
                logger.debug("token = {}", (Object)token);
                this.continuationString = this.continuationString.concat(token + " ");
                logger.debug("continuationString = {}", (Object)this.continuationString);
            }
            if (!this.continuationField.equals(this.previousContinuationField)) {
                if ("".equals(this.continuationString)) {
                    this.continuationString = token;
                    continue;
                }
                this.compndValueSetter(this.previousContinuationField, this.continuationString);
                this.previousContinuationField = this.continuationField;
                this.continuationString = token + " ";
                continue;
            }
            if (!ignoreCompndFieldValues.contains(token)) continue;
        }
        if (this.isLastCompndLine) {
            this.compndValueSetter(this.continuationField, this.continuationString);
            this.continuationString = "";
            if (this.current_compound != null) {
                this.entities.add(this.current_compound);
            }
        }
    }

    private void compndValueSetter(String field, String value) {
        value = value.trim().replace(";", "");
        if ("MOL_ID:".equals(field)) {
            int i = -1;
            try {
                i = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                logger.warn("Value '{}' does not look like a number, while trying to parse COMPND MOL_ID line.", (Object)value);
            }
            if (i > 0 && this.prevMolId != i) {
                if (this.current_compound != null) {
                    this.entities.add(this.current_compound);
                }
                logger.debug("Initialising new Compound with mol_id {}", (Object)i);
                this.current_compound = new EntityInfo();
                this.current_compound.setMolId(i);
                this.current_compound.setType(EntityType.POLYMER);
                this.prevMolId = i;
            }
        }
        if (this.current_compound == null) {
            return;
        }
        if ("MOLECULE:".equals(field)) {
            this.current_compound.setDescription(value);
        }
        if ("CHAIN:".equals(field)) {
            StringTokenizer chainTokens = new StringTokenizer(value, ",");
            ArrayList<String> chains = new ArrayList<String>();
            while (chainTokens.hasMoreTokens()) {
                String chainID = chainTokens.nextToken().trim();
                if ("NULL".equals(chainID)) {
                    chainID = " ";
                }
                chains.add(chainID);
            }
            this.compoundMolIds2chainIds.put(this.current_compound.getMolId(), chains);
        }
        if ("SYNONYM:".equals(field)) {
            StringTokenizer synonyms = new StringTokenizer(value, ",");
            ArrayList<String> names = new ArrayList<String>();
            while (synonyms.hasMoreTokens()) {
                names.add(synonyms.nextToken());
                this.current_compound.setSynonyms(names);
            }
        }
        if ("EC:".equals(field)) {
            StringTokenizer ecNumTokens = new StringTokenizer(value, ",");
            ArrayList<String> ecNums = new ArrayList<String>();
            while (ecNumTokens.hasMoreTokens()) {
                ecNums.add(ecNumTokens.nextToken());
                this.current_compound.setEcNums(ecNums);
            }
        }
        if ("FRAGMENT:".equals(field)) {
            this.current_compound.setFragment(value);
        }
        if ("ENGINEERED:".equals(field)) {
            this.current_compound.setEngineered(value);
        }
        if ("MUTATION:".equals(field)) {
            this.current_compound.setMutation(value);
        }
        if ("BIOLOGICAL_UNIT:".equals(field)) {
            this.current_compound.setBiologicalUnit(value);
        }
        if ("OTHER_DETAILS:".equals(field)) {
            this.current_compound.setDetails(value);
        }
    }

    private void pdb_SOURCE_Handler(String line) {
        String continuationNr = line.substring(9, 10).trim();
        logger.debug("current continuationNo     is {}", (Object)continuationNr);
        logger.debug("previousContinuationField  is {}", (Object)this.previousContinuationField);
        logger.debug("current continuationField  is {}", (Object)this.continuationField);
        logger.debug("current continuationString is {}", (Object)this.continuationString);
        logger.debug("current compound           is {}", (Object)this.current_compound);
        if (line.length() > 79) {
            line = line.substring(0, 79);
        }
        line = line.substring(10, line.length());
        logger.debug("LINE: >{}<", (Object)line);
        String[] fieldList = line.split("\\s+");
        if (!"".equals(fieldList[0]) && sourceFieldValues.contains(fieldList[0])) {
            this.continuationField = fieldList[0];
            if ("".equals(this.previousContinuationField)) {
                this.previousContinuationField = this.continuationField;
            }
        } else if (fieldList.length > 1 && sourceFieldValues.contains(fieldList[1])) {
            this.continuationField = fieldList[1];
            if ("".equals(this.previousContinuationField)) {
                this.previousContinuationField = this.continuationField;
            }
        } else if ("".equals(continuationNr)) {
            logger.debug("looks like an old PDB file");
            this.continuationField = "MOLECULE:";
            if ("".equals(this.previousContinuationField)) {
                this.previousContinuationField = this.continuationField;
            }
        }
        line = line.replace(this.continuationField, "").trim();
        StringTokenizer compndTokens = new StringTokenizer(line);
        while (compndTokens.hasMoreTokens()) {
            String token = compndTokens.nextToken();
            if ("".equals(this.previousContinuationField)) {
                this.previousContinuationField = this.continuationField;
            }
            if (this.previousContinuationField.equals(this.continuationField) && sourceFieldValues.contains(this.continuationField)) {
                logger.debug("Still in field {}", (Object)this.continuationField);
                this.continuationString = this.continuationString.concat(token + " ");
                logger.debug("continuationString = {}", (Object)this.continuationString);
            }
            if (!this.continuationField.equals(this.previousContinuationField)) {
                if ("".equals(this.continuationString)) {
                    this.continuationString = token;
                    continue;
                }
                this.sourceValueSetter(this.previousContinuationField, this.continuationString);
                this.previousContinuationField = this.continuationField;
                this.continuationString = token + " ";
                continue;
            }
            if (!ignoreCompndFieldValues.contains(token)) continue;
        }
        if (this.isLastSourceLine) {
            this.sourceValueSetter(this.continuationField, this.continuationString);
            this.continuationString = "";
        }
    }

    private void sourceValueSetter(String field, String value) {
        value = value.trim().replace(";", "");
        if ("MOL_ID:".equals(field)) {
            try {
                this.current_compound = this.entities.get(Integer.valueOf(value) - 1);
            }
            catch (NumberFormatException e) {
                logger.info("could not process SOURCE MOL_ID record correctly:" + e.getMessage());
                return;
            }
        }
        if ("SYNTHETIC:".equals(field)) {
            this.current_compound.setSynthetic(value);
        } else if ("FRAGMENT:".equals(field)) {
            this.current_compound.setFragment(value);
        } else if ("ORGANISM_SCIENTIFIC:".equals(field)) {
            this.current_compound.setOrganismScientific(value);
        } else if ("ORGANISM_TAXID:".equals(field)) {
            this.current_compound.setOrganismTaxId(value);
        } else if ("ORGANISM_COMMON:".equals(field)) {
            this.current_compound.setOrganismCommon(value);
        } else if ("STRAIN:".equals(field)) {
            this.current_compound.setStrain(value);
        } else if ("VARIANT:".equals(field)) {
            this.current_compound.setVariant(value);
        } else if ("CELL_LINE:".equals(field)) {
            this.current_compound.setCellLine(value);
        } else if ("ATCC:".equals(field)) {
            this.current_compound.setAtcc(value);
        } else if ("ORGAN:".equals(field)) {
            this.current_compound.setOrgan(value);
        } else if ("TISSUE:".equals(field)) {
            this.current_compound.setTissue(value);
        } else if ("CELL:".equals(field)) {
            this.current_compound.setCell(value);
        } else if ("ORGANELLE:".equals(field)) {
            this.current_compound.setOrganelle(value);
        } else if ("SECRETION:".equals(field)) {
            this.current_compound.setSecretion(value);
        } else if ("GENE:".equals(field)) {
            this.current_compound.setGene(value);
        } else if ("CELLULAR_LOCATION:".equals(field)) {
            this.current_compound.setCellularLocation(value);
        } else if ("EXPRESSION_SYSTEM:".equals(field)) {
            this.current_compound.setExpressionSystem(value);
        } else if ("EXPRESSION_SYSTEM_TAXID:".equals(field)) {
            this.current_compound.setExpressionSystemTaxId(value);
        } else if ("EXPRESSION_SYSTEM_STRAIN:".equals(field)) {
            this.current_compound.setExpressionSystemStrain(value);
        } else if ("EXPRESSION_SYSTEM_VARIANT:".equals(field)) {
            this.current_compound.setExpressionSystemVariant(value);
        } else if ("EXPRESSION_SYSTEM_CELL_LINE:".equals(field)) {
            this.current_compound.setExpressionSystemCellLine(value);
        } else if ("EXPRESSION_SYSTEM_ATCC_NUMBER:".equals(field)) {
            this.current_compound.setExpressionSystemAtccNumber(value);
        } else if ("EXPRESSION_SYSTEM_ORGAN:".equals(field)) {
            this.current_compound.setExpressionSystemOrgan(value);
        } else if ("EXPRESSION_SYSTEM_TISSUE:".equals(field)) {
            this.current_compound.setExpressionSystemTissue(value);
        } else if ("EXPRESSION_SYSTEM_CELL:".equals(field)) {
            this.current_compound.setExpressionSystemCell(value);
        } else if ("EXPRESSION_SYSTEM_ORGANELLE:".equals(field)) {
            this.current_compound.setExpressionSystemOrganelle(value);
        } else if ("EXPRESSION_SYSTEM_CELLULAR_LOCATION:".equals(field)) {
            this.current_compound.setExpressionSystemCellularLocation(value);
        } else if ("EXPRESSION_SYSTEM_VECTOR_TYPE:".equals(field)) {
            this.current_compound.setExpressionSystemVectorType(value);
        } else if ("EXPRESSION_SYSTEM_VECTOR:".equals(field)) {
            this.current_compound.setExpressionSystemVector(value);
        } else if ("EXPRESSION_SYSTEM_PLASMID:".equals(field)) {
            this.current_compound.setExpressionSystemPlasmid(value);
        } else if ("EXPRESSION_SYSTEM_GENE:".equals(field)) {
            this.current_compound.setExpressionSystemGene(value);
        } else if ("OTHER_DETAILS:".equals(field)) {
            this.current_compound.setExpressionSystemOtherDetails(value);
        }
    }

    private void pdb_REMARK_Handler(String line) {
        if (line == null || line.length() < 11) {
            return;
        }
        if (line.startsWith("REMARK 800")) {
            this.pdb_REMARK_800_Handler(line);
        } else if (line.startsWith("REMARK 350")) {
            if (this.params.isParseBioAssembly()) {
                if (this.bioAssemblyParser == null) {
                    this.bioAssemblyParser = new PDBBioAssemblyParser();
                }
                this.bioAssemblyParser.pdb_REMARK_350_Handler(line);
            }
        } else if (line.startsWith("REMARK   2")) {
            Pattern pR = Pattern.compile("^REMARK   2 RESOLUTION.\\s+(\\d+\\.\\d+)\\s+ANGSTROMS\\..*");
            this.handleResolutionLine(line, pR);
        } else if (line.startsWith("REMARK   3   FREE R VALUE")) {
            Pattern pR = Pattern.compile("^REMARK   3   FREE R VALUE\\s+(?:\\(NO CUTOFF\\))?\\s+:\\s+(\\d?\\.\\d+).*");
            Matcher mR = pR.matcher(line);
            if (mR.matches()) {
                try {
                    this.rfreeNoCutoffLine = Float.parseFloat(mR.group(1));
                }
                catch (NumberFormatException e) {
                    logger.info("Rfree value " + mR.group(1) + " does not look like a number, will ignore it");
                }
            }
            if ((mR = (pR = Pattern.compile("^REMARK   3   FREE R VALUE\\s+:\\s+(\\d?\\.\\d+).*")).matcher(line)).matches()) {
                try {
                    this.rfreeStandardLine = Float.parseFloat(mR.group(1));
                }
                catch (NumberFormatException e) {
                    logger.info("Rfree value '{}' does not look like a number, will ignore it", (Object)mR.group(1));
                }
            }
        } else if (line.startsWith("REMARK   3   RESOLUTION RANGE HIGH")) {
            Pattern pR = Pattern.compile("^REMARK   3   RESOLUTION RANGE HIGH \\(ANGSTROMS\\) :\\s+(\\d+\\.\\d+).*");
            this.handleResolutionLine(line, pR);
        } else if (line.startsWith("REMARK   3   EFFECTIVE RESOLUTION")) {
            Pattern pR = Pattern.compile("^REMARK   3   EFFECTIVE RESOLUTION \\(ANGSTROMS\\)\\s+:\\s+(\\d+\\.\\d+).*");
            this.handleResolutionLine(line, pR);
        }
    }

    public void handleResolutionLine(String line, Pattern pR) {
        Matcher mR = pR.matcher(line);
        if (mR.matches()) {
            String resString = mR.group(1);
            try {
                float res = Float.parseFloat(resString);
                float resInHeader = this.pdbHeader.getResolution();
                if (resInHeader != 99.0f && resInHeader != res) {
                    logger.warn("More than 1 resolution value present, will use last one {} and discard previous {} ", (Object)resString, (Object)String.format("%4.2f", Float.valueOf(resInHeader)));
                }
                this.pdbHeader.setResolution(res);
            }
            catch (NumberFormatException e) {
                logger.info("Could not parse resolution '{}', ignoring it", (Object)resString);
            }
        }
    }

    private void pdb_EXPDTA_Handler(String line) {
        String technique = line.length() > 69 ? line.substring(10, 70).trim() : line.substring(10).trim();
        for (String singleTechnique : technique.split(";\\s+")) {
            this.pdbHeader.setExperimentalTechnique(singleTechnique);
        }
    }

    private void pdb_CRYST1_Handler(String line) {
        float gamma;
        float beta;
        float alpha;
        float c;
        float b;
        float a;
        if (line.length() < 58) {
            logger.warn("CRYST1 record has fewer than 58 columns: will ignore it");
            return;
        }
        String spaceGroup = "";
        try {
            a = Float.parseFloat(line.substring(6, 15).trim());
            b = Float.parseFloat(line.substring(15, 24).trim());
            c = Float.parseFloat(line.substring(24, 33).trim());
            alpha = Float.parseFloat(line.substring(33, 40).trim());
            beta = Float.parseFloat(line.substring(40, 47).trim());
            gamma = Float.parseFloat(line.substring(47, 54).trim());
        }
        catch (NumberFormatException e) {
            logger.info("could not parse CRYST1 record (" + e.getMessage() + ") from line and ignoring it " + line);
            return;
        }
        spaceGroup = line.length() >= 66 ? line.substring(55, 66).trim() : line.substring(55, line.length()).trim();
        CrystalCell xtalCell = new CrystalCell();
        xtalCell.setA(a);
        xtalCell.setB(b);
        xtalCell.setC(c);
        xtalCell.setAlpha(alpha);
        xtalCell.setBeta(beta);
        xtalCell.setGamma(gamma);
        if (!xtalCell.isCellReasonable()) {
            logger.debug("The crystal cell read from file does not have reasonable dimensions (at least one dimension is below {}), discarding it.", (Object)10.0);
        } else {
            this.crystallographicInfo.setCrystalCell(xtalCell);
        }
        SpaceGroup sg = SymoplibParser.getSpaceGroup(spaceGroup);
        if (sg == null) {
            logger.warn("Space group '" + spaceGroup + "' not recognised as a standard space group");
            this.crystallographicInfo.setNonStandardSg(true);
        } else {
            this.crystallographicInfo.setSpaceGroup(sg);
            this.crystallographicInfo.setNonStandardSg(false);
        }
    }

    private void pdb_MTRIXn_Handler(String line) {
        if (line.length() < 55) {
            logger.info("MTRIXn record has fewer than 55 columns: will ignore it");
            return;
        }
        try {
            int rowIndex = Integer.parseInt(line.substring(5, 6));
            double col1Value = Double.parseDouble(line.substring(10, 20));
            double col2Value = Double.parseDouble(line.substring(20, 30));
            double col3Value = Double.parseDouble(line.substring(30, 40));
            double translValue = Double.parseDouble(line.substring(45, 55));
            int iGiven = 0;
            if (line.length() >= 60 && !line.substring(59, 60).trim().isEmpty()) {
                iGiven = Integer.parseInt(line.substring(59, 60));
            }
            if (iGiven == 1) {
                return;
            }
            if (this.ncsOperators == null) {
                this.ncsOperators = new ArrayList<Matrix4d>();
            }
            if (this.currentNcsOp == null) {
                this.currentNcsOp = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            }
            this.currentNcsOp.setElement(rowIndex - 1, 0, col1Value);
            this.currentNcsOp.setElement(rowIndex - 1, 1, col2Value);
            this.currentNcsOp.setElement(rowIndex - 1, 2, col3Value);
            this.currentNcsOp.setElement(rowIndex - 1, 3, translValue);
            if (rowIndex == 3) {
                this.ncsOperators.add(this.currentNcsOp);
                this.currentNcsOp = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            }
        }
        catch (NumberFormatException e) {
            logger.info("Could not parse a number in MTRIXn record (" + e.getMessage() + ") from line: >" + line + "<");
        }
    }

    private void pdb_ATOM_Handler(String line) {
        String elementSymbol;
        if (this.params.isHeaderOnly()) {
            return;
        }
        String chainName = line.substring(21, 22);
        if (" ".equals(chainName)) {
            this.blankChainIdsPresent = true;
        }
        if (this.currentChain != null && !this.currentChain.getName().equals(chainName)) {
            this.startOfMolecule = true;
        }
        if (this.startOfMolecule) {
            if (this.currentChain != null) {
                this.currentModel.add(this.currentChain);
                if (this.currentGroup != null) {
                    this.currentChain.addGroup(this.currentGroup);
                }
            }
            this.currentChain = new ChainImpl();
            this.currentChain.setId(chainName);
            this.currentChain.setName(chainName);
        }
        if (this.startOfModel) {
            if (this.currentModel != null) {
                this.allModels.add(this.currentModel);
            }
            this.currentModel = new ArrayList<Chain>();
        }
        String groupCode3 = line.substring(17, 20).trim();
        String resNum = line.substring(22, 26).trim();
        Character iCode = Character.valueOf(line.substring(26, 27).charAt(0));
        if (iCode.charValue() == ' ') {
            iCode = null;
        }
        ResidueNumber residueNumber = new ResidueNumber(chainName, Integer.valueOf(resNum), iCode);
        Character aminoCode1 = StructureTools.get1LetterCode(groupCode3);
        String recordName = line.substring(0, 6).trim();
        boolean isHetAtomInFile = false;
        if ("HETATM".equals(recordName)) {
            if (aminoCode1 != null && aminoCode1.equals(Character.valueOf('X'))) {
                aminoCode1 = null;
            }
            isHetAtomInFile = true;
        }
        if (this.startOfMolecule) {
            this.currentGroup = this.getNewGroup(recordName, aminoCode1, groupCode3);
            this.currentGroup.setPDBName(groupCode3);
            this.currentGroup.setResidueNumber(residueNumber);
            this.currentGroup.setHetAtomInFile(isHetAtomInFile);
        }
        this.startOfModel = false;
        this.startOfMolecule = false;
        Character altLoc = Character.valueOf(line.substring(16, 17).charAt(0));
        Group altGroup = null;
        if (!residueNumber.equals(this.currentGroup.getResidueNumber())) {
            this.currentChain.addGroup(this.currentGroup);
            this.currentGroup.trimToSize();
            this.currentGroup = this.getNewGroup(recordName, aminoCode1, groupCode3);
            this.currentGroup.setPDBName(groupCode3);
            this.currentGroup.setResidueNumber(residueNumber);
            this.currentGroup.setHetAtomInFile(isHetAtomInFile);
        } else if (!altLoc.equals(Character.valueOf(' '))) {
            logger.debug("found altLoc! " + String.valueOf(this.currentGroup) + " " + String.valueOf(altGroup));
            altGroup = this.getCorrectAltLocGroup(altLoc, recordName, aminoCode1, groupCode3);
            if (altGroup.getChain() == null) {
                altGroup.setChain(this.currentChain);
            }
        }
        ++this.atomCount;
        if (this.atomCount == this.atomCAThreshold) {
            logger.warn("more than " + this.atomCAThreshold + " atoms in this structure, ignoring the SEQRES lines");
            this.seqResChains.clear();
            this.switchCAOnly();
        }
        if (this.atomCount == this.loadMaxAtoms) {
            logger.warn("File has more atoms than max specified in parsing parameters ({}). Ignoring atoms after line: {}", (Object)this.loadMaxAtoms, (Object)line);
            return;
        }
        if (this.atomCount > this.loadMaxAtoms) {
            return;
        }
        String fullname = line.substring(12, 16);
        if (this.parseCAonly && !" CA ".equals(fullname)) {
            --this.atomCount;
            return;
        }
        if (this.params.getAcceptedAtomNames() != null) {
            boolean found = false;
            for (String ok : this.params.getAcceptedAtomNames()) {
                if (!ok.equals(fullname.trim())) continue;
                found = true;
                break;
            }
            if (!found) {
                --this.atomCount;
                return;
            }
        }
        int pdbnumber = Integer.parseInt(line.substring(6, 11).trim());
        AtomImpl atom = new AtomImpl();
        atom.setPDBserial(pdbnumber);
        atom.setAltLoc(altLoc);
        atom.setName(fullname.trim());
        double x = Double.parseDouble(line.substring(30, 38).trim());
        double y = Double.parseDouble(line.substring(38, 46).trim());
        double z = Double.parseDouble(line.substring(46, 54).trim());
        double[] coords = new double[]{x, y, z};
        atom.setCoords(coords);
        float occu = 1.0f;
        if (line.length() > 59) {
            try {
                occu = Float.parseFloat(line.substring(54, 60).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        float tempf = 0.0f;
        if (line.length() > 65) {
            try {
                tempf = Float.parseFloat(line.substring(60, 66).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        atom.setOccupancy(occu);
        atom.setTempFactor(tempf);
        Element element = Element.R;
        boolean guessElement = true;
        if (line.length() > 77) {
            elementSymbol = line.substring(76, 78).trim();
            if (elementSymbol.isEmpty()) {
                logger.info("Element column was empty for atom {} {}. Assigning atom element from Chemical Component Dictionary information", (Object)fullname.trim(), (Object)pdbnumber);
            } else {
                try {
                    element = Element.valueOfIgnoreCase(elementSymbol);
                    guessElement = false;
                }
                catch (IllegalArgumentException e) {
                    logger.info("Element {} of atom {} {} was not recognised. Assigning atom element from Chemical Component Dictionary information", new Object[]{elementSymbol, fullname.trim(), pdbnumber});
                }
            }
        } else {
            logger.info("Missformatted PDB file: element column of atom {} {} is not present. Assigning atom element from Chemical Component Dictionary information", (Object)fullname.trim(), (Object)pdbnumber);
        }
        if (guessElement) {
            elementSymbol = null;
            if (this.currentGroup.getChemComp() != null) {
                for (ChemCompAtom a : this.currentGroup.getChemComp().getAtoms()) {
                    if (!a.getAtomId().equals(fullname.trim())) continue;
                    elementSymbol = a.getTypeSymbol();
                    break;
                }
                if (elementSymbol == null) {
                    logger.info("Atom name {} was not found in the Chemical Component Dictionary information of {}. Assigning generic element R to it", (Object)fullname.trim(), (Object)this.currentGroup.getPDBName());
                } else {
                    try {
                        element = Element.valueOfIgnoreCase(elementSymbol);
                    }
                    catch (IllegalArgumentException e) {
                        logger.info("Element symbol {} found in chemical component dictionary for Atom {} {} could not be recognised as a known element. Assigning generic element R to it", new Object[]{elementSymbol, fullname.trim(), pdbnumber});
                    }
                }
            } else {
                logger.warn("Chemical Component Dictionary information was not found for Atom name {}. Assigning generic element R to it", (Object)fullname.trim());
            }
        }
        atom.setElement(element);
        if (altGroup != null) {
            altGroup.addAtom(atom);
            altGroup = null;
        } else {
            this.currentGroup.addAtom(atom);
        }
        if (!this.currentGroup.hasAtom(atom.getName())) {
            this.currentGroup.addAtom(atom);
        }
    }

    private Group getCorrectAltLocGroup(Character altLoc, String recordName, Character aminoCode1, String groupCode3) {
        Group altLocG;
        Atom a1;
        List<Atom> atoms = this.currentGroup.getAtoms();
        if (atoms.size() > 0 && (a1 = atoms.get(0)).getAltLoc().equals(altLoc)) {
            return this.currentGroup;
        }
        List<Group> altLocs = this.currentGroup.getAltLocs();
        for (Group altLocG2 : altLocs) {
            atoms = altLocG2.getAtoms();
            if (atoms.size() <= 0) continue;
            for (Atom a12 : atoms) {
                if (!a12.getAltLoc().equals(altLoc)) continue;
                return altLocG2;
            }
        }
        if (groupCode3.equals(this.currentGroup.getPDBName())) {
            if (this.currentGroup.getAtoms().isEmpty()) {
                return this.currentGroup;
            }
            altLocG = (Group)this.currentGroup.clone();
            altLocG.setAtoms(new ArrayList<Atom>());
            altLocG.getAltLocs().clear();
            this.currentGroup.addAltLoc(altLocG);
            return altLocG;
        }
        altLocG = this.getNewGroup(recordName, aminoCode1, groupCode3);
        altLocG.setPDBName(groupCode3);
        altLocG.setResidueNumber(this.currentGroup.getResidueNumber());
        this.currentGroup.addAltLoc(altLocG);
        return altLocG;
    }

    private void switchCAOnly() {
        this.parseCAonly = true;
        this.currentModel = CAConverter.getRepresentativeAtomsOnly(this.currentModel);
        for (int i = 0; i < this.structure.nrModels(); ++i) {
            List<Chain> model = this.structure.getModel(i);
            model = CAConverter.getRepresentativeAtomsOnly(model);
            this.structure.setModel(i, model);
        }
        this.currentChain = CAConverter.getRepresentativeAtomsOnly(this.currentChain);
    }

    private Integer conect_helper(String line, int start, int end) {
        if (line.length() < end) {
            return null;
        }
        String sbond = line.substring(start, end).trim();
        int bond = -1;
        Integer b = null;
        if (!"".equals(sbond)) {
            bond = Integer.parseInt(sbond);
            b = bond;
        }
        return b;
    }

    private void pdb_CONECT_Handler(String line) {
        if (this.atomOverflow) {
            return;
        }
        if (this.params.isHeaderOnly()) {
            return;
        }
        try {
            int atomserial = Integer.parseInt(line.substring(6, 11).trim());
            Integer bond1 = this.conect_helper(line, 11, 16);
            Integer bond2 = this.conect_helper(line, 16, 21);
            Integer bond3 = this.conect_helper(line, 21, 26);
            Integer bond4 = this.conect_helper(line, 26, 31);
            Integer hyd1 = this.conect_helper(line, 31, 36);
            Integer hyd2 = this.conect_helper(line, 36, 41);
            Integer salt1 = this.conect_helper(line, 41, 46);
            Integer hyd3 = this.conect_helper(line, 46, 51);
            Integer hyd4 = this.conect_helper(line, 51, 56);
            Integer salt2 = this.conect_helper(line, 56, 61);
            HashMap<String, Integer> cons = new HashMap<String, Integer>();
            cons.put("atomserial", atomserial);
            if (bond1 != null) {
                cons.put("bond1", bond1);
            }
            if (bond2 != null) {
                cons.put("bond2", bond2);
            }
            if (bond3 != null) {
                cons.put("bond3", bond3);
            }
            if (bond4 != null) {
                cons.put("bond4", bond4);
            }
            if (hyd1 != null) {
                cons.put("hydrogen1", hyd1);
            }
            if (hyd2 != null) {
                cons.put("hydrogen2", hyd2);
            }
            if (salt1 != null) {
                cons.put("salt1", salt1);
            }
            if (hyd3 != null) {
                cons.put("hydrogen3", hyd3);
            }
            if (hyd4 != null) {
                cons.put("hydrogen4", hyd4);
            }
            if (salt2 != null) {
                cons.put("salt2", salt2);
            }
            this.connects.add(cons);
        }
        catch (NumberFormatException e) {
            logger.info("could not parse CONECT line correctly (" + e.getMessage() + "), at line : " + line);
            return;
        }
    }

    private void pdb_MODEL_Handler(String line) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        this.startOfMolecule = true;
        this.startOfModel = true;
    }

    private void pdb_TER_Handler() {
        this.startOfMolecule = true;
    }

    private void pdb_DBREF_Handler(String line) {
        logger.debug("Parsing DBREF {}", (Object)line);
        DBRef dbref = new DBRef();
        String idCode = line.substring(7, 11);
        String chainName = line.substring(12, 13);
        String seqBegin = line.substring(14, 18);
        String insertBegin = line.substring(18, 19);
        String seqEnd = line.substring(20, 24);
        String insertEnd = line.substring(24, 25);
        String database = line.substring(26, 32);
        String dbAccession = line.substring(33, 41);
        String dbIdCode = line.substring(42, 54);
        String dbseqBegin = line.substring(55, 60);
        String idbnsBeg = line.substring(60, 61);
        String dbseqEnd = line.substring(62, 67);
        String dbinsEnd = line.length() >= 68 ? line.substring(67, 68) : " ";
        dbref.setIdCode(idCode);
        dbref.setChainName(chainName);
        dbref.setSeqBegin(this.intFromString(seqBegin));
        dbref.setInsertBegin(insertBegin.charAt(0));
        dbref.setSeqEnd(this.intFromString(seqEnd));
        dbref.setInsertEnd(insertEnd.charAt(0));
        dbref.setDatabase(database.trim());
        dbref.setDbAccession(dbAccession.trim());
        dbref.setDbIdCode(dbIdCode.trim());
        dbref.setDbSeqBegin(this.intFromString(dbseqBegin));
        dbref.setIdbnsBegin(idbnsBeg.charAt(0));
        dbref.setDbSeqEnd(this.intFromString(dbseqEnd));
        dbref.setIdbnsEnd(dbinsEnd.charAt(0));
        this.dbrefs.add(dbref);
    }

    private void pdb_SSBOND_Handler(String line) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        if (line.length() < 36) {
            logger.info("SSBOND line has length under 36. Ignoring it.");
            return;
        }
        String chain1 = line.substring(15, 16);
        String seqNum1 = line.substring(17, 21).trim();
        String icode1 = line.substring(21, 22);
        String chain2 = line.substring(29, 30);
        String seqNum2 = line.substring(31, 35).trim();
        String icode2 = line.substring(35, 36);
        if (line.length() >= 72) {
            String symop1 = line.substring(59, 65).trim();
            String symop2 = line.substring(66, 72).trim();
            if (!("".equals(symop1) || "".equals(symop2) || "1555".equals(symop1) && "1555".equals(symop2))) {
                logger.info("Skipping ss bond between groups {} and {} belonging to different symmetry partners, because it is not supported yet", (Object)(seqNum1 + icode1), (Object)(seqNum2 + icode2));
                return;
            }
        }
        if (" ".equals(icode1)) {
            icode1 = "";
        }
        if (" ".equals(icode2)) {
            icode2 = "";
        }
        SSBondImpl ssbond = new SSBondImpl();
        ssbond.setChainID1(chain1);
        ssbond.setResnum1(seqNum1);
        ssbond.setChainID2(chain2);
        ssbond.setResnum2(seqNum2);
        ssbond.setInsCode1(icode1);
        ssbond.setInsCode2(icode2);
        this.ssbonds.add(ssbond);
    }

    private void pdb_LINK_Handler(String line) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        if (line.length() < 56) {
            logger.info("LINK line has length under 56. Ignoring it.");
            return;
        }
        int len = line.length();
        String name1 = line.substring(12, 16).trim();
        String altLoc1 = line.substring(16, 17).trim();
        String resName1 = line.substring(17, 20).trim();
        String chainID1 = line.substring(21, 22).trim();
        String resSeq1 = line.substring(22, 26).trim();
        String iCode1 = line.substring(26, 27).trim();
        String name2 = line.substring(42, 46).trim();
        String altLoc2 = line.substring(46, 47).trim();
        String resName2 = line.substring(47, 50).trim();
        String chainID2 = line.substring(51, 52).trim();
        String resSeq2 = line.substring(52, 56).trim();
        String iCode2 = null;
        if (len > 56) {
            iCode2 = line.substring(56, 57).trim();
        }
        String sym1 = null;
        if (len > 64) {
            sym1 = line.substring(59, 65).trim();
        }
        String sym2 = null;
        if (len > 71) {
            sym2 = line.substring(66, 72).trim();
        }
        this.linkRecords.add(new PDBTemporaryStorageUtils.LinkRecord(name1, altLoc1, resName1, chainID1, resSeq1, iCode1, name2, altLoc2, resName2, chainID2, resSeq2, iCode2, sym1, sym2));
    }

    private void pdb_SITE_Handler(String line) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        logger.debug("Site Line:{}", (Object)line);
        String siteID = line.substring(11, 14);
        List<ResidueNumber> siteResidues = this.siteToResidueMap.get(siteID);
        if (siteResidues == null || !this.siteToResidueMap.containsKey(siteID.trim())) {
            siteResidues = new ArrayList<ResidueNumber>();
            this.siteToResidueMap.put(siteID.trim(), siteResidues);
            logger.debug(String.format("New Site made: %s %s", siteID, siteResidues));
            logger.debug("Now made {} sites", (Object)this.siteMap.size());
        }
        logger.debug(String.format("SiteId: %s", siteID));
        line = line.substring(18);
        String groupString = null;
        while (!"          ".equals(groupString = line.substring(0, 10))) {
            logger.debug("groupString: '{}'", (Object)groupString);
            String residueName = groupString.substring(0, 3);
            Character aminoCode1 = StructureTools.get1LetterCode(residueName);
            if (aminoCode1 != null && aminoCode1.equals(Character.valueOf('X'))) {
                aminoCode1 = null;
            }
            String chainId = groupString.substring(4, 5);
            Integer resNum = Integer.valueOf(groupString.substring(5, 9).trim());
            Character insCode = Character.valueOf(groupString.substring(9, 10).charAt(0));
            logger.debug(String.format("Site: %s: 'resName:%s resNum:%s insCode:%s'", siteID, residueName, resNum, insCode));
            ResidueNumber residueNumber = new ResidueNumber();
            logger.debug("pdbCode: '{}{}'", (Object)resNum, (Object)insCode);
            residueNumber.setChainName(chainId);
            residueNumber.setSeqNum(resNum);
            residueNumber.setInsCode(insCode);
            siteResidues.add(residueNumber);
            logger.debug("Adding residueNumber " + String.valueOf(residueNumber) + " to site " + siteID);
            line = line.substring(11);
        }
        logger.debug("Current SiteMap (contains {} sites):", (Object)this.siteToResidueMap.keySet().size());
        for (String key : this.siteToResidueMap.keySet()) {
            logger.debug(key + " : " + String.valueOf(this.siteToResidueMap.get(key)));
        }
    }

    private void pdb_REMARK_800_Handler(String line) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        String[] fields = (line = line.substring(11)).split(": ");
        if (fields.length == 2) {
            if ("SITE_IDENTIFIER".equals(fields[0])) {
                String siteID = fields[1].trim();
                logger.debug("siteID: '{}'", (Object)siteID);
                this.site = this.siteMap.get(siteID);
                if (this.site == null || !siteID.equals(this.site.getSiteID())) {
                    this.site = new Site(siteID, new ArrayList<Group>());
                    this.siteMap.put(this.site.getSiteID(), this.site);
                    logger.debug("New Site made: {}", (Object)this.site);
                    logger.debug("Now made {} sites", (Object)this.siteMap.size());
                }
            }
            if ("EVIDENCE_CODE".equals(fields[0])) {
                String evCode = fields[1].trim();
                logger.debug("evCode: '{}'", (Object)evCode);
                this.site.setEvCode(evCode);
            }
            if ("SITE_DESCRIPTION".equals(fields[0])) {
                String desc = fields[1].trim();
                logger.debug("desc: '{}'", (Object)desc);
                this.site.setDescription(desc);
                logger.debug("Finished making REMARK 800 for site {}", (Object)this.site.getSiteID());
                logger.debug(this.site.remark800toPDB());
            }
        }
    }

    private int intFromString(String intString) {
        int val = Integer.MIN_VALUE;
        try {
            val = Integer.parseInt(intString.trim());
        }
        catch (NumberFormatException ex) {
            logger.info("Could not parse a number: " + ex.getMessage());
        }
        return val;
    }

    private static Chain isKnownChain(String chainID, List<Chain> chains) {
        for (int i = 0; i < chains.size(); ++i) {
            Chain testchain = chains.get(i);
            if (!chainID.equals(testchain.getName())) continue;
            return testchain;
        }
        return null;
    }

    private BufferedReader getBufferedReader(InputStream inStream) throws IOException {
        if (inStream == null) {
            throw new IOException("input stream is null!");
        }
        BufferedReader buf = new BufferedReader(new InputStreamReader(inStream));
        return buf;
    }

    public Structure parsePDBFile(InputStream inStream) throws IOException {
        BufferedReader buf = this.getBufferedReader(inStream);
        return this.parsePDBFile(buf);
    }

    public Structure parsePDBFile(BufferedReader buf) throws IOException {
        this.loadMaxAtoms = this.params.getMaxAtoms();
        this.atomCAThreshold = this.params.getAtomCaThreshold();
        this.allModels = new ArrayList<List<Chain>>();
        this.structure = new StructureImpl();
        this.currentModel = null;
        this.currentChain = null;
        this.currentGroup = null;
        this.startOfMolecule = true;
        this.startOfModel = true;
        this.seqResChains = new ArrayList<Chain>();
        this.siteMap = new LinkedHashMap<String, Site>();
        this.pdbHeader = new PDBHeader();
        this.connects = new ArrayList<Map<String, Integer>>();
        this.previousContinuationField = "";
        this.continuationField = "";
        this.continuationString = "";
        this.current_compound = null;
        this.sourceLines.clear();
        this.compndLines.clear();
        this.keywordsLines.clear();
        this.isLastCompndLine = false;
        this.isLastSourceLine = false;
        this.prevMolId = -1;
        this.entities.clear();
        this.helixList.clear();
        this.strandList.clear();
        this.turnList.clear();
        this.lengthCheck = -1;
        this.atomCount = 0;
        this.atomOverflow = false;
        this.linkRecords = new ArrayList<PDBTemporaryStorageUtils.LinkRecord>();
        this.siteToResidueMap.clear();
        this.blankChainIdsPresent = false;
        this.parseCAonly = this.params.isParseCAOnly();
        String line = null;
        while ((line = buf.readLine()) != null) {
            if ("".equals(line) || line.equals(NEWLINE) || line.startsWith("END")) continue;
            if (line.length() < 6 && !line.startsWith("TER")) {
                logger.info("Found line length below 6. Ignoring it, line: >" + line + "<");
                continue;
            }
            String recordName = null;
            recordName = line.length() < 6 ? line.trim() : line.substring(0, 6).trim();
            try {
                if ("ATOM".equals(recordName)) {
                    this.pdb_ATOM_Handler(line);
                    continue;
                }
                if ("SEQRES".equals(recordName)) {
                    this.pdb_SEQRES_Handler(line);
                    continue;
                }
                if ("HETATM".equals(recordName)) {
                    this.pdb_ATOM_Handler(line);
                    continue;
                }
                if ("MODEL".equals(recordName)) {
                    this.pdb_MODEL_Handler(line);
                    continue;
                }
                if ("TER".equals(recordName)) {
                    this.pdb_TER_Handler();
                    continue;
                }
                if ("HEADER".equals(recordName)) {
                    this.pdb_HEADER_Handler(line);
                    continue;
                }
                if ("AUTHOR".equals(recordName)) {
                    this.pdb_AUTHOR_Handler(line);
                    continue;
                }
                if ("TITLE".equals(recordName)) {
                    this.pdb_TITLE_Handler(line);
                    continue;
                }
                if ("SOURCE".equals(recordName)) {
                    this.sourceLines.add(line);
                    continue;
                }
                if ("COMPND".equals(recordName)) {
                    this.compndLines.add(line);
                    continue;
                }
                if ("KEYWDS".equals(recordName)) {
                    this.keywordsLines.add(line);
                    continue;
                }
                if ("JRNL".equals(recordName)) {
                    this.pdb_JRNL_Handler(line);
                    continue;
                }
                if ("EXPDTA".equals(recordName)) {
                    this.pdb_EXPDTA_Handler(line);
                    continue;
                }
                if ("CRYST1".equals(recordName)) {
                    this.pdb_CRYST1_Handler(line);
                    continue;
                }
                if (recordName.startsWith("MTRIX")) {
                    this.pdb_MTRIXn_Handler(line);
                    continue;
                }
                if ("REMARK".equals(recordName)) {
                    this.pdb_REMARK_Handler(line);
                    continue;
                }
                if ("CONECT".equals(recordName)) {
                    this.pdb_CONECT_Handler(line);
                    continue;
                }
                if ("REVDAT".equals(recordName)) {
                    this.pdb_REVDAT_Handler(line);
                    continue;
                }
                if ("DBREF".equals(recordName)) {
                    this.pdb_DBREF_Handler(line);
                    continue;
                }
                if ("SITE".equals(recordName)) {
                    this.pdb_SITE_Handler(line);
                    continue;
                }
                if ("SSBOND".equals(recordName)) {
                    this.pdb_SSBOND_Handler(line);
                    continue;
                }
                if ("LINK".equals(recordName)) {
                    this.pdb_LINK_Handler(line);
                    continue;
                }
                if (!this.params.isParseSecStruc()) continue;
                if ("HELIX".equals(recordName)) {
                    this.pdb_HELIX_Handler(line);
                    continue;
                }
                if ("SHEET".equals(recordName)) {
                    this.pdb_SHEET_Handler(line);
                    continue;
                }
                if (!"TURN".equals(recordName)) continue;
                this.pdb_TURN_Handler(line);
            }
            catch (NullPointerException | StringIndexOutOfBoundsException ex) {
                logger.info("Unable to parse [" + line + "]");
            }
        }
        this.makeCompounds(this.compndLines, this.sourceLines);
        this.handlePDBKeywords(this.keywordsLines);
        this.triggerEndFileChecks();
        if (this.params.shouldCreateAtomBonds()) {
            this.formBonds();
        }
        if (this.params.shouldCreateAtomCharges()) {
            this.addCharges();
        }
        if (this.params.isParseSecStruc() && !this.params.isHeaderOnly()) {
            this.setSecStruc();
        }
        StructureTools.cleanUpAltLocs(this.structure);
        return this.structure;
    }

    private void addCharges() {
        ChargeAdder.addCharges(this.structure);
    }

    private void makeCompounds(List<String> compoundList, List<String> sourceList) {
        for (String line : compoundList) {
            if (compoundList.indexOf(line) + 1 == compoundList.size()) {
                this.isLastCompndLine = true;
            }
            this.pdb_COMPND_Handler(line);
        }
        this.current_compound = this.entities.isEmpty() ? new EntityInfo() : this.entities.get(0);
        for (String line : sourceList) {
            if (sourceList.indexOf(line) + 1 == sourceList.size()) {
                this.isLastSourceLine = true;
            }
            this.pdb_SOURCE_Handler(line);
        }
    }

    private void handlePDBKeywords(List<String> lines) {
        StringBuilder fullList = new StringBuilder();
        for (String line : lines) {
            String kwList = line.substring(10).trim();
            if (kwList.length() <= 0) continue;
            if (fullList.length() > 0 && fullList.indexOf("-", fullList.length() - 1) < 0) {
                fullList.append(' ');
            }
            fullList.append(kwList);
        }
        String fulllengthList = fullList.toString();
        this.keywords = fulllengthList.split("( )*,( )*");
        ArrayList<String> lst = new ArrayList<String>(this.keywords.length);
        for (String keyword : this.keywords) {
            if (keyword.length() == 0) {
                logger.debug("Keyword empty in structure {}", (Object)this.structure.getIdentifier().toString());
                continue;
            }
            lst.add(keyword);
        }
        this.pdbHeader.setKeywords(lst);
    }

    private void formBonds() {
        BondMaker maker = new BondMaker(this.structure, this.params);
        for (PDBTemporaryStorageUtils.LinkRecord linkRecord : this.linkRecords) {
            maker.formLinkRecordBond(linkRecord);
        }
        maker.formDisulfideBonds(this.ssbonds);
        maker.makeBonds();
    }

    private void triggerEndFileChecks() {
        Date depositionDate;
        if (this.currentChain != null && this.currentGroup != null) {
            this.currentChain.addGroup(this.currentGroup);
        }
        if (this.currentModel != null && this.currentChain != null) {
            this.currentModel.add(this.currentChain);
        }
        if (this.currentModel != null) {
            this.allModels.add(this.currentModel);
        }
        if (this.blankChainIdsPresent) {
            logger.warn("Found some blank chain ids in PDB file. Please note that support for them has been discontinued and things might not work properly.");
        }
        this.assignChainsAndEntities();
        this.structure.setEntityInfos(this.entities);
        Date modDate = this.pdbHeader.getModDate();
        if (modDate.equals(new Date(0L)) && !(depositionDate = this.pdbHeader.getDepDate()).equals(modDate)) {
            this.pdbHeader.setModDate(depositionDate);
        }
        this.structure.setPDBHeader(this.pdbHeader);
        this.structure.setCrystallographicInfo(this.crystallographicInfo);
        if (!this.journalLines.isEmpty()) {
            this.buildjournalArticle();
            this.pdbHeader.setJournalArticle(this.journalArticle);
        }
        this.structure.setDBRefs(this.dbrefs);
        if (this.params.isAlignSeqRes() && !this.params.isHeaderOnly() && !this.seqResChains.isEmpty()) {
            logger.debug("Parsing mode align_seqres, will parse SEQRES and align to ATOM sequence");
            SeqRes2AtomAligner aligner = new SeqRes2AtomAligner();
            aligner.align(this.structure, this.seqResChains);
        } else {
            logger.debug("Parsing mode unalign_seqres, will parse SEQRES but not align it to ATOM sequence");
            SeqRes2AtomAligner.storeUnAlignedSeqRes(this.structure, this.seqResChains, this.params.isHeaderOnly());
        }
        if (!this.params.isHeaderOnly()) {
            this.linkSitesToGroups();
        }
        if (this.bioAssemblyParser != null) {
            this.bioAssemblyParser.setMacromolecularSizes();
            this.pdbHeader.setBioAssemblies(this.bioAssemblyParser.getTransformationMap());
        }
        if (this.ncsOperators != null && this.ncsOperators.size() > 0) {
            this.crystallographicInfo.setNcsOperators(this.ncsOperators.toArray(new Matrix4d[this.ncsOperators.size()]));
        }
        if (this.rfreeNoCutoffLine > 0.0f && this.rfreeStandardLine < 0.0f) {
            this.pdbHeader.setRfree(this.rfreeNoCutoffLine);
        } else if (this.rfreeNoCutoffLine > 0.0f && this.rfreeStandardLine > 0.0f) {
            this.pdbHeader.setRfree(this.rfreeStandardLine);
        } else if (this.rfreeNoCutoffLine < 0.0f && this.rfreeStandardLine > 0.0f) {
            this.pdbHeader.setRfree(this.rfreeStandardLine);
        }
    }

    private void setSecStruc() {
        this.setSecElement(this.helixList, "PDB_AUTHOR_ASSIGNMENT", SecStrucType.helix4);
        this.setSecElement(this.strandList, "PDB_AUTHOR_ASSIGNMENT", SecStrucType.extended);
        this.setSecElement(this.turnList, "PDB_AUTHOR_ASSIGNMENT", SecStrucType.turn);
        GroupIterator gi = new GroupIterator(this.structure);
        while (gi.hasNext()) {
            Group g = gi.next();
            if (!g.hasAminoAtoms() || g.getProperty("secstruc") != null) continue;
            SecStrucInfo ss = new SecStrucInfo(g, "PDB_AUTHOR_ASSIGNMENT", SecStrucType.coil);
            g.setProperty("secstruc", ss);
        }
    }

    private void setSecElement(List<Map<String, String>> secList, String assignment, SecStrucType type) {
        block0: for (Map<String, String> m : secList) {
            String initChainId = m.get("initChainId");
            String initSeqNum = m.get("initSeqNum");
            String initICode = m.get("initICode");
            String endChainId = m.get("endChainId");
            String endSeqNum = m.get("endSeqNum");
            String endICode = m.get("endICode");
            if (" ".equals(initICode)) {
                initICode = "";
            }
            if (" ".equals(endICode)) {
                endICode = "";
            }
            GroupIterator gi = new GroupIterator(this.structure);
            boolean inRange = false;
            while (gi.hasNext()) {
                String pdbCode;
                Group g = gi.next();
                Chain c = g.getChain();
                if (c.getName().equals(initChainId)) {
                    pdbCode = initSeqNum + initICode;
                    if (g.getResidueNumber().toString().equals(pdbCode)) {
                        inRange = true;
                    }
                }
                if (inRange && g.hasAminoAtoms()) {
                    SecStrucInfo ss = new SecStrucInfo(g, assignment, type);
                    g.setProperty("secstruc", ss);
                }
                if (!c.getName().equals(endChainId) || !(pdbCode = endSeqNum + endICode).equals(g.getResidueNumber().toString())) continue;
                inRange = false;
                continue block0;
            }
        }
    }

    private static List<List<Chain>> findChains(String chainName, List<List<Chain>> polyModels) {
        ArrayList<List<Chain>> models = new ArrayList<List<Chain>>();
        for (List<Chain> chains : polyModels) {
            ArrayList<Chain> matchingChains = new ArrayList<Chain>();
            models.add(matchingChains);
            for (Chain c : chains) {
                if (!c.getName().equals(chainName)) continue;
                matchingChains.add(c);
            }
        }
        return models;
    }

    private static List<List<Chain>> splitNonPolyChain(Chain chain) {
        ArrayList<ChainImpl> splitNonPolys = new ArrayList<ChainImpl>();
        ArrayList<ChainImpl> waterChains = new ArrayList<ChainImpl>();
        ChainImpl split = null;
        boolean previousGroupIsWater = false;
        for (Group g : chain.getAtomGroups()) {
            if (!previousGroupIsWater) {
                if (split != null) {
                    splitNonPolys.add(split);
                }
                split = new ChainImpl();
                split.setName(chain.getName());
            } else if (!g.isWater()) {
                waterChains.add(split);
                split = new ChainImpl();
                split.setName(chain.getName());
            }
            previousGroupIsWater = g.isWater();
            split.addGroup(g);
        }
        if (split != null) {
            if (previousGroupIsWater) {
                waterChains.add(split);
            } else {
                splitNonPolys.add(split);
            }
        }
        ArrayList<List<Chain>> all = new ArrayList<List<Chain>>(2);
        all.add(splitNonPolys);
        all.add(waterChains);
        return all;
    }

    private void assignAsymIds(List<List<Chain>> polys, List<List<Chain>> nonPolys, List<List<Chain>> waters) {
        for (int i = 0; i < polys.size(); ++i) {
            String asymId = "A";
            for (Chain poly : polys.get(i)) {
                poly.setId(asymId);
                asymId = this.getNextAsymId(asymId);
            }
            for (Chain nonPoly : nonPolys.get(i)) {
                nonPoly.setId(asymId);
                asymId = this.getNextAsymId(asymId);
            }
            for (Chain water : waters.get(i)) {
                water.setId(asymId);
                asymId = this.getNextAsymId(asymId);
            }
        }
    }

    private String getNextAsymId(String asymId) {
        if (asymId.length() == 1) {
            if (!"Z".equals(asymId)) {
                return Character.toString(this.getNextChar(asymId.charAt(0)));
            }
            return "AA";
        }
        if (asymId.length() == 2) {
            if ("ZZ".equals(asymId)) {
                return "AAA";
            }
            char[] c = new char[2];
            asymId.getChars(0, 2, c, 0);
            c[0] = this.getNextChar(c[0]);
            if (c[0] == 'A') {
                c[1] = this.getNextChar(c[1]);
            }
            return String.valueOf(c);
        }
        if (asymId.length() == 3) {
            char[] c = new char[3];
            asymId.getChars(0, 3, c, 0);
            c[0] = this.getNextChar(c[0]);
            if (c[0] == 'A') {
                c[1] = this.getNextChar(c[1]);
                if (c[1] == 'A') {
                    c[2] = this.getNextChar(c[2]);
                }
            }
            return String.valueOf(c);
        }
        return null;
    }

    private char getNextChar(char c) {
        if (c != 'Z') {
            return (char)(c + '\u0001');
        }
        return 'A';
    }

    private void assignChainsAndEntities() {
        ArrayList<List<Chain>> polyModels = new ArrayList<List<Chain>>();
        ArrayList nonPolyModels = new ArrayList();
        ArrayList<List<Chain>> waterModels = new ArrayList<List<Chain>>();
        for (List<Chain> model : this.allModels) {
            ArrayList<Chain> polyChains = new ArrayList<Chain>();
            ArrayList<Chain> nonPolyChains = new ArrayList<Chain>();
            ArrayList<Chain> waterChains = new ArrayList<Chain>();
            polyModels.add(polyChains);
            nonPolyModels.add(nonPolyChains);
            waterModels.add(waterChains);
            for (Chain c : model) {
                if (c.isWaterOnly()) {
                    waterChains.add(c);
                    continue;
                }
                if (c.isPureNonPolymer()) {
                    nonPolyChains.add(c);
                    continue;
                }
                polyChains.add(c);
            }
        }
        ArrayList<List<Chain>> splitNonPolyModels = new ArrayList<List<Chain>>();
        for (int i = 0; i < nonPolyModels.size(); ++i) {
            List nonPolyModel = (List)nonPolyModels.get(i);
            List waterModel = (List)waterModels.get(i);
            ArrayList splitNonPolys = new ArrayList();
            splitNonPolyModels.add(splitNonPolys);
            for (Chain nonPoly : nonPolyModel) {
                List<List<Chain>> splits = PDBFileParser.splitNonPolyChain(nonPoly);
                splitNonPolys.addAll(splits.get(0));
                waterModel.addAll((Collection)splits.get(1));
            }
        }
        this.assignAsymIds(polyModels, splitNonPolyModels, waterModels);
        if (!this.entities.isEmpty()) {
            for (EntityInfo comp : this.entities) {
                List<String> chainIds = this.compoundMolIds2chainIds.get(comp.getMolId());
                if (chainIds == null) continue;
                for (String chainId : chainIds) {
                    List<List<Chain>> models = PDBFileParser.findChains(chainId, polyModels);
                    for (List<Chain> matchingChains : models) {
                        for (Chain chain : matchingChains) {
                            comp.addChain(chain);
                            chain.setEntityInfo(comp);
                        }
                        if (!matchingChains.isEmpty()) continue;
                        logger.warn("Could not find polymeric chain {} to link to entity {}. The chain will be missing in the entity.", (Object)chainId, (Object)comp.getMolId());
                    }
                }
            }
        } else {
            logger.info("Entity information (COMPOUND record) not found in file. Will assign entities heuristically");
            this.entities = EntityFinder.findPolyEntities(polyModels);
        }
        EntityFinder.createPurelyNonPolyEntities(splitNonPolyModels, waterModels, this.entities);
        for (int i = 0; i < this.allModels.size(); ++i) {
            ArrayList<Chain> model = new ArrayList<Chain>();
            model.addAll((Collection)polyModels.get(i));
            model.addAll((Collection)splitNonPolyModels.get(i));
            model.addAll((Collection)waterModels.get(i));
            this.structure.addModel(model);
        }
    }

    private void linkSitesToGroups() {
        if (this.siteMap == null || this.siteToResidueMap == null) {
            logger.info("Sites can not be linked to residues!");
            return;
        }
        ArrayList<Site> sites = null;
        if (this.structure.getChains().isEmpty()) {
            sites = new ArrayList<Site>(this.siteMap.values());
            logger.info("No chains to link Site Groups with - Sites will not be present in the Structure");
            return;
        }
        if (!this.siteMap.keySet().equals(this.siteToResidueMap.keySet())) {
            logger.info("Not all sites have been properly described in the PDB " + this.pdbId + " header - some Sites will not be present in the Structure");
            logger.debug(String.valueOf(this.siteMap.keySet()) + " | " + String.valueOf(this.siteToResidueMap.keySet()));
        }
        for (String key : this.siteMap.keySet()) {
            Site currentSite = this.siteMap.get(key);
            List<ResidueNumber> linkedGroups = this.siteToResidueMap.get(key);
            if (linkedGroups == null) continue;
            for (ResidueNumber residueNumber : linkedGroups) {
                String pdbCode = residueNumber.toString();
                String chain = residueNumber.getChainName();
                Group linkedGroup = null;
                try {
                    linkedGroup = this.structure.findGroup(chain, pdbCode);
                }
                catch (StructureException ex) {
                    logger.info("Can't find group " + pdbCode + " in chain " + chain + " in order to link up SITE records (PDB ID " + this.pdbId + ")");
                    continue;
                }
                currentSite.getGroups().add(linkedGroup);
            }
        }
        sites = new ArrayList<Site>(this.siteMap.values());
        this.structure.setSites(sites);
    }

    private void buildjournalArticle() {
        logger.debug("building new JournalArticle");
        this.journalArticle = new JournalArticle();
        StringBuffer auth = new StringBuffer();
        StringBuffer titl = new StringBuffer();
        StringBuffer edit = new StringBuffer();
        StringBuffer ref = new StringBuffer();
        StringBuffer publ = new StringBuffer();
        StringBuffer refn = new StringBuffer();
        StringBuffer pmid = new StringBuffer();
        StringBuffer doi = new StringBuffer();
        for (String line : this.journalLines) {
            if (line.length() < 19) {
                logger.info("can not process Journal line: " + line);
                continue;
            }
            String subField = line.substring(12, 16);
            if ("AUTH".equals(subField)) {
                auth.append(line.substring(19, line.length()).trim());
                logger.debug("AUTH '{}'", (Object)auth.toString());
            }
            if ("TITL".equals(subField)) {
                titl.append(line.substring(19, line.length()).trim()).append(" ");
                logger.debug("TITL '{}'", (Object)titl.toString());
            }
            if ("EDIT".equals(subField)) {
                edit.append(line.substring(19, line.length()).trim());
                logger.debug("EDIT '{}'", (Object)edit.toString());
            }
            if ("REF ".equals(subField)) {
                ref.append(line.substring(19, line.length()).trim()).append(" ");
                logger.debug("REF '{}'", (Object)ref.toString());
            }
            if ("PUBL".equals(subField)) {
                publ.append(line.substring(19, line.length()).trim()).append(" ");
                logger.debug("PUBL '{}'", (Object)publ.toString());
            }
            if ("REFN".equals(subField)) {
                if (line.length() < 35) {
                    logger.info("can not process Journal REFN line: " + line);
                    continue;
                }
                refn.append(line.substring(35, line.length()).trim());
                logger.debug("REFN '{}'", (Object)refn.toString());
            }
            if ("PMID".equals(subField)) {
                pmid.append(line.substring(19, line.length()).trim());
                logger.debug("PMID '{}'", (Object)pmid.toString());
            }
            if (!"DOI ".equals(subField)) continue;
            doi.append(line.substring(19, line.length()).trim());
            logger.debug("DOI '{}'", (Object)doi.toString());
        }
        this.journalArticle.setAuthorList(this.authorBuilder(auth.toString()));
        this.journalArticle.setEditorList(this.authorBuilder(edit.toString()));
        this.journalArticle.setRef(ref.toString());
        JournalParser journalParser = new JournalParser(ref.toString());
        this.journalArticle.setJournalName(journalParser.getJournalName());
        if (!"TO BE PUBLISHED".equals(this.journalArticle.getJournalName())) {
            this.journalArticle.setIsPublished(true);
        }
        this.journalArticle.setVolume(journalParser.getVolume());
        this.journalArticle.setStartPage(journalParser.getStartPage());
        this.journalArticle.setPublicationDate(journalParser.getPublicationDate());
        this.journalArticle.setPublisher(publ.toString().trim());
        this.journalArticle.setTitle(titl.toString().trim());
        this.journalArticle.setRefn(refn.toString().trim());
        this.journalArticle.setPmid(pmid.toString().trim());
        this.journalArticle.setDoi(doi.toString().trim());
        logger.debug("Made JournalArticle:");
        logger.debug(this.journalArticle.toString());
    }

    private List<Author> authorBuilder(String authorString) {
        ArrayList<Author> authorList = new ArrayList<Author>();
        if ("".equals(authorString)) {
            return authorList;
        }
        String[] authors = authorString.split(",");
        if (authors.length == 1) {
            Author author = new Author();
            author.setSurname(authors[0]);
            logger.debug("Set consortium author name {}", (Object)author.getSurname());
            authorList.add(author);
        } else {
            for (int i = 0; i < authors.length; ++i) {
                String authorFullName = authors[i];
                logger.debug("Building author {}", (Object)authorFullName);
                Author author = new Author();
                String regex = "\\.";
                String[] authorNames = authorFullName.split(regex);
                if (authorNames.length == 0) {
                    author.setSurname(authorFullName);
                    logger.debug("Unable to split using '" + regex + "' Setting whole name " + author.getSurname());
                } else if (authorNames.length == 1) {
                    author.setSurname(authorNames[0]);
                    logger.debug("Set consortium author name in multiple author block {}", (Object)author.getSurname());
                } else {
                    Object initials = "";
                    for (int j = 0; j < authorNames.length - 1; ++j) {
                        String initial = authorNames[j];
                        initials = (String)initials + initial + ".";
                    }
                    logger.debug("built initials '{}'", initials);
                    author.setInitials((String)initials);
                    int lastName = authorNames.length - 1;
                    String surname = authorNames[lastName];
                    logger.debug("built author surname {}", (Object)surname);
                    author.setSurname(surname);
                }
                authorList.add(author);
            }
        }
        return authorList;
    }

    public void setFileParsingParameters(FileParsingParameters params) {
        this.params = params;
        this.loadMaxAtoms = params.getMaxAtoms();
        this.atomCAThreshold = params.getAtomCaThreshold();
    }

    public FileParsingParameters getFileParsingParameters() {
        return this.params;
    }

    private class JournalParser {
        private String journalName;
        private String volume;
        private String startPage;
        private int publicationDate;

        public JournalParser(String ref) {
            logger.debug("JournalParser init '{}'", (Object)ref);
            if ("TO BE PUBLISHED ".equals(ref)) {
                this.journalName = ref.trim();
                logger.debug(String.format("JournalParser found journalString '%s'", this.journalName));
                return;
            }
            if (ref.length() < 48) {
                logger.info("REF line too short - must be at least 48 characters to be valid for parsing.");
                this.journalName = "";
                this.volume = "";
                this.startPage = "";
                this.publicationDate = 0;
                return;
            }
            String volumeInformation = ref.substring(30, 48);
            logger.debug(String.format("Parsing volumeInformation: '%s'", volumeInformation));
            String dateString = volumeInformation.substring(volumeInformation.length() - 5, volumeInformation.length() - 1).trim();
            String startPageString = volumeInformation.substring(volumeInformation.length() - 11, volumeInformation.length() - 6).trim();
            String volumeString = volumeInformation.substring(volumeInformation.length() - 16, volumeInformation.length() - 12).trim();
            Object journalString = ref.substring(0, 29).trim() + " " + ref.substring(30, ref.length() - 1).replace(volumeInformation.trim(), "").trim();
            journalString = ((String)journalString).trim();
            logger.debug(String.format("JournalParser found volumeString '%s'", volumeString));
            logger.debug(String.format("JournalParser found startPageString '%s'", startPageString));
            logger.debug(String.format("JournalParser found dateString '%s'", dateString));
            logger.debug(String.format("JournalParser found journalString '%s'", journalString));
            if (!"    ".equals(dateString)) {
                try {
                    this.publicationDate = Integer.valueOf(dateString);
                }
                catch (NumberFormatException nfe) {
                    logger.info(dateString + " is not a valid integer for a date in JRNL sub-section REF line 1");
                }
            }
            if (!"    ".equals(startPageString)) {
                this.startPage = startPageString;
            }
            if (!"    ".equals(volumeString)) {
                this.volume = volumeString;
            }
            if (!"    ".equals(journalString)) {
                this.journalName = journalString;
                logger.debug("JournalParser set journalName {}", (Object)this.journalName);
            }
        }

        private String getJournalName() {
            return this.journalName;
        }

        private int getPublicationDate() {
            return this.publicationDate;
        }

        private String getStartPage() {
            return this.startPage;
        }

        private String getVolume() {
            return this.volume;
        }
    }
}

