/*
 * Decompiled with CFR 0.152.
 */
package org.n0pe.asadmin.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.n0pe.asadmin.AbstractAsAdminCmd;
import org.n0pe.asadmin.Util;

public class CreateMessageSecurityProvider
extends AbstractAsAdminCmd {
    public static final String SECURITY_PROVIDER = "create-message-security-provider";
    public static final String LAYER_OPT = "--layer";
    public static final String PROVIDER_TYPE_OPT = "--providertype";
    public static final String CLASSNAME = "--classname";
    public static final String PROPERTY_OPT = "--property";
    private String providerName;
    private String providerType;
    private String layer;
    private String classname;
    private Map properties;

    private CreateMessageSecurityProvider() {
    }

    public CreateMessageSecurityProvider(String providerName) {
        this.providerName = providerName;
    }

    public CreateMessageSecurityProvider withLayer(String layer) {
        this.layer = layer;
        return this;
    }

    public CreateMessageSecurityProvider withProviderType(String providerType) {
        this.providerType = providerType;
        return this;
    }

    public CreateMessageSecurityProvider withClassName(String classname) {
        this.classname = classname;
        return this;
    }

    public CreateMessageSecurityProvider addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return this;
    }

    @Override
    public boolean needCredentials() {
        return true;
    }

    @Override
    public String getActionCommand() {
        if (this.providerName == null) {
            throw new IllegalStateException();
        }
        return SECURITY_PROVIDER;
    }

    @Override
    public String[] getParameters() {
        String[] params;
        if (this.providerType == null || this.layer == null || this.classname == null) {
            throw new IllegalStateException();
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            StringBuffer sw = new StringBuffer();
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                sw.append(key).append("=").append(Util.quoteCommandArgument((String)this.properties.get(key)));
                if (!it.hasNext()) continue;
                sw.append(":");
            }
            params = new String[]{LAYER_OPT, this.layer, PROVIDER_TYPE_OPT, this.providerType, CLASSNAME, this.classname, PROPERTY_OPT, sw.toString(), this.providerName};
        } else {
            params = new String[]{LAYER_OPT, this.layer, PROVIDER_TYPE_OPT, this.providerType, CLASSNAME, this.classname, this.providerName};
        }
        return params;
    }
}

