/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.checks.ChecksHelper;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ClassCyclomaticComplexity", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ClassComplexityCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAX = 200;
    @RuleProperty(defaultValue="200")
    private int max = 200;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION});
    }

    public void leaveNode(AstNode node) {
        SourceClass sourceClass = (SourceClass)this.getContext().peekSourceCode();
        int complexity = ChecksHelper.getRecursiveMeasureInt((SourceCode)sourceClass, (MetricDef)JavaMetric.COMPLEXITY);
        if (complexity > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "The Cyclomatic Complexity of this class is {0,number,integer} which is greater than {1,number,integer} authorized.", node, new Object[]{complexity, this.max});
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

