/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="ClassVariableVisibilityCheck", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ClassVariableVisibilityCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "ClassVariableVisibilityCheck";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"ClassVariableVisibilityCheck");
    private Deque<Boolean> isClassStack = new ArrayDeque<Boolean>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        this.isClassStack.push(tree.is(Tree.Kind.CLASS) || tree.is(Tree.Kind.ENUM));
        super.visitClass(tree);
        this.isClassStack.pop();
    }

    public void visitVariable(VariableTree tree) {
        List modifiers = tree.modifiers().modifiers();
        List annotations = tree.modifiers().annotations();
        if (this.isClass() && ClassVariableVisibilityCheck.isPublic(modifiers) && !ClassVariableVisibilityCheck.isConstant(modifiers) && annotations.isEmpty()) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Make " + tree.simpleName() + " a static final constant or non-public and provide accessors if needed.");
        }
        super.visitVariable(tree);
    }

    private boolean isClass() {
        return !this.isClassStack.isEmpty() && this.isClassStack.peek() != false;
    }

    private static boolean isConstant(List<Modifier> modifiers) {
        return !modifiers.isEmpty() && modifiers.contains(Modifier.FINAL) && modifiers.contains(Modifier.STATIC);
    }

    private static boolean isPublic(List<Modifier> modifiers) {
        return !modifiers.isEmpty() && modifiers.contains(Modifier.PUBLIC);
    }
}

