/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1170", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ConstantsShouldBeStaticFinalCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.FIELD_DECLARATION});
    }

    public void visitNode(AstNode node) {
        AstNode classMemberDeclaration = node.getFirstAncestor((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION);
        if (ConstantsShouldBeStaticFinalCheck.isFinal(classMemberDeclaration) && !ConstantsShouldBeStaticFinalCheck.isStatic(classMemberDeclaration)) {
            for (AstNode variableDeclarator : node.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS}).getChildren(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR})) {
                if (this.isObjectInInnerClass(classMemberDeclaration) || !ConstantsShouldBeStaticFinalCheck.hasConstantInitializer(variableDeclarator)) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Make this final field static too.", variableDeclarator, new Object[0]);
            }
        }
    }

    private boolean isObjectInInnerClass(AstNode classMemberDeclaration) {
        AstNode outerClassDeclaration;
        AstNode innerClassDeclaration = classMemberDeclaration.getFirstAncestor((AstNodeType)JavaGrammar.CLASS_DECLARATION);
        if (innerClassDeclaration != null && (outerClassDeclaration = innerClassDeclaration.getFirstAncestor((AstNodeType)JavaGrammar.CLASS_DECLARATION)) != null) {
            AstNode classType = classMemberDeclaration.getFirstDescendant(new AstNodeType[]{JavaGrammar.CLASS_TYPE});
            return classType != null && !this.isClassTypeString(classType);
        }
        return false;
    }

    private boolean isClassTypeString(AstNode classType) {
        return "String".equals(classType.getTokenValue()) && classType.getNextSibling() == null;
    }

    private static boolean isFinal(AstNode node) {
        return node.select().children((AstNodeType)JavaGrammar.MODIFIER).children((AstNodeType)JavaKeyword.FINAL).isNotEmpty();
    }

    private static boolean isStatic(AstNode node) {
        return node.select().children((AstNodeType)JavaGrammar.MODIFIER).children((AstNodeType)JavaKeyword.STATIC).isNotEmpty();
    }

    private static boolean hasConstantInitializer(AstNode node) {
        AstNode variableInitializer = node.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_INITIALIZER});
        return variableInitializer != null && !variableInitializer.hasDescendant(new AstNodeType[]{JavaPunctuator.LPAR, JavaPunctuator.LBRK});
    }
}

