/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1165", priority=Priority.MAJOR, tags={"error-handling"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ExceptionsShouldBeImmutableCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION});
    }

    public void visitNode(AstNode node) {
        if (ExceptionsShouldBeImmutableCheck.isException(node)) {
            for (AstNode field : ExceptionsShouldBeImmutableCheck.getFields(node)) {
                if (ExceptionsShouldBeImmutableCheck.isFinal(field)) continue;
                for (AstNode variableDeclarator : field.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS}).getChildren(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR})) {
                    this.getContext().createLineViolation((CodeCheck)this, "Make this \"" + variableDeclarator.getTokenOriginalValue() + "\" field final.", field, new Object[0]);
                }
            }
        }
    }

    private static boolean isException(AstNode node) {
        String name = node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenOriginalValue();
        return name.endsWith("Exception") || name.endsWith("Error");
    }

    private static Iterable<AstNode> getFields(AstNode node) {
        return node.select().children((AstNodeType)JavaGrammar.CLASS_BODY).children((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION).children((AstNodeType)JavaGrammar.MEMBER_DECL).children((AstNodeType)JavaGrammar.FIELD_DECLARATION);
    }

    private static boolean isFinal(AstNode node) {
        return node.select().firstAncestor((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION).children((AstNodeType)JavaGrammar.MODIFIER).children((AstNodeType)JavaKeyword.FINAL).isNotEmpty();
    }
}

