/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00121", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class MissingCurlyBraces_S00121_Check
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.IF_STATEMENT, JavaGrammar.FOR_STATEMENT, JavaGrammar.WHILE_STATEMENT, JavaGrammar.DO_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        AstNode elseClause;
        AstNode statement = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT});
        if (!statement.getFirstChild().is(new AstNodeType[]{JavaGrammar.BLOCK})) {
            this.getContext().createLineViolation((CodeCheck)this, "Missing curly brace.", astNode, new Object[0]);
        }
        if (astNode.is(new AstNodeType[]{JavaGrammar.IF_STATEMENT}) && (elseClause = astNode.getFirstChild(new AstNodeType[]{JavaKeyword.ELSE})) != null && !(statement = elseClause.getNextSibling()).getFirstChild().is(new AstNodeType[]{JavaGrammar.BLOCK}) && !statement.getFirstChild().is(new AstNodeType[]{JavaGrammar.IF_STATEMENT})) {
            this.getContext().createLineViolation((CodeCheck)this, "Missing curly brace.", elseClause, new Object[0]);
        }
    }
}

