/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1695", priority=Priority.MAJOR, tags={"pitfall"})
public class NPEThrowCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1695";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1695");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        this.raiseIssueOnNpe((AbstractTypedTree)tree.expression());
        super.visitThrowStatement(tree);
    }

    public void visitMethod(MethodTree tree) {
        for (ExpressionTree throwClauses : tree.throwsClauses()) {
            this.raiseIssueOnNpe((AbstractTypedTree)throwClauses);
        }
        super.visitMethod(tree);
    }

    private void raiseIssueOnNpe(AbstractTypedTree tree) {
        if (this.isNPE(tree)) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Throw some other exception here, such as \"IllegalArgumentException\".");
        }
    }

    private boolean isNPE(AbstractTypedTree tree) {
        if (tree.getType().isTagged(10)) {
            Type.ClassType type = (Type.ClassType)tree.getType();
            return "NullPointerException".equals(type.getSymbol().getName());
        }
        return false;
    }
}

