/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1174", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ObjectFinalizeOverridenNotPublicCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.MEMBER_DECL});
    }

    public void visitNode(AstNode node) {
        if (ObjectFinalizeOverridenNotPublicCheck.isFinalizeMethodMember(node) && ObjectFinalizeOverridenNotPublicCheck.isPublic(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Make this finalize() method protected.", node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}), new Object[0]);
        }
    }

    private static boolean isFinalizeMethodMember(AstNode node) {
        return node.hasDirectChildren(new AstNodeType[]{JavaGrammar.VOID_METHOD_DECLARATOR_REST}) && "finalize".equals(node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenOriginalValue());
    }

    private static boolean isPublic(AstNode node) {
        return node.select().firstAncestor((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION).children((AstNodeType)JavaGrammar.MODIFIER).children((AstNodeType)JavaKeyword.PUBLIC).isNotEmpty();
    }
}

